/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.stream;

import java.io.IOException;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.io.TiStream;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.util.TiConfig;
import ti.modules.titanium.BufferProxy;
import ti.modules.titanium.stream.BlobStreamProxy;
import ti.modules.titanium.stream.BufferStreamProxy;

public class StreamModule
extends KrollModule {
    public static final int MODE_READ = 0;
    public static final int MODE_WRITE = 1;
    public static final int MODE_APPEND = 2;
    private static final String LCAT = "StreamModule";
    private static final boolean DBG = TiConfig.LOGD;

    public StreamModule(TiContext tiContext) {
        super(tiContext);
    }

    public Object createStream(KrollDict params) {
        Object source = params.get("source");
        Object rawMode = params.get("mode");
        if (!(rawMode instanceof Double)) {
            throw new IllegalArgumentException("Unable to create stream, invalid mode");
        }
        int mode = ((Double)rawMode).intValue();
        if (source instanceof TiBlob) {
            if (mode != 0) {
                throw new IllegalArgumentException("Unable to create a blob stream in a mode other than read");
            }
            return new BlobStreamProxy((TiBlob)source);
        }
        if (source instanceof BufferProxy) {
            return new BufferStreamProxy((BufferProxy)source, mode);
        }
        throw new IllegalArgumentException("Unable to create a stream for the specified argument");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read(Object[] args) {
        TiStream sourceStream = null;
        BufferProxy buffer = null;
        int offset = 0;
        int length = 0;
        KrollCallback resultsCallback = null;
        if (args.length != 3 && args.length != 5) throw new IllegalArgumentException("Invalid number of arguments");
        if (!(args[0] instanceof TiStream)) {
            throw new IllegalArgumentException("Invalid stream argument");
        }
        sourceStream = (TiStream)args[0];
        if (!(args[1] instanceof BufferProxy)) {
            throw new IllegalArgumentException("Invalid buffer argument");
        }
        buffer = (BufferProxy)args[1];
        length = buffer.getLength();
        if (args.length == 3) {
            if (!(args[2] instanceof KrollCallback)) throw new IllegalArgumentException("Invalid callback argument");
            resultsCallback = (KrollCallback)args[2];
        } else if (args.length == 5) {
            if (!(args[2] instanceof Double)) {
                throw new IllegalArgumentException("Invalid offset argument");
            }
            offset = ((Double)args[2]).intValue();
            if (!(args[3] instanceof Double)) {
                throw new IllegalArgumentException("Invalid length argument");
            }
            length = ((Double)args[3]).intValue();
            if (!(args[4] instanceof KrollCallback)) throw new IllegalArgumentException("Invalid callback argument");
            resultsCallback = (KrollCallback)args[4];
        }
        final TiStream fsourceStream = sourceStream;
        final BufferProxy fbuffer = buffer;
        final int foffset = offset;
        final int flength = length;
        final KrollCallback fresultsCallback = resultsCallback;
        new Thread(new Runnable(){

            @Override
            public void run() {
                int bytesRead = -1;
                int errorState = 0;
                String errorDescription = "";
                try {
                    bytesRead = fsourceStream.read(new Object[]{fbuffer, foffset, flength});
                }
                catch (IOException e) {
                    e.printStackTrace();
                    errorState = 1;
                    errorDescription = e.getMessage();
                }
                fresultsCallback.callAsync(StreamModule.this.buildRWCallbackArgs(fsourceStream, bytesRead, errorState, errorDescription));
            }
        }){}.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object readAll(Object[] args) throws IOException {
        TiStream sourceStream = null;
        BufferProxy bufferArg = null;
        KrollCallback resultsCallback = null;
        if (args.length != 1 && args.length != 3) throw new IllegalArgumentException("Invalid number of arguments");
        if (!(args[0] instanceof TiStream)) {
            throw new IllegalArgumentException("Invalid stream argument");
        }
        sourceStream = (TiStream)args[0];
        if (args.length == 3) {
            if (!(args[1] instanceof BufferProxy)) {
                throw new IllegalArgumentException("Invalid buffer argument");
            }
            bufferArg = (BufferProxy)args[1];
            if (!(args[2] instanceof KrollCallback)) throw new IllegalArgumentException("Invalid callback argument");
            resultsCallback = (KrollCallback)args[2];
        }
        if (args.length == 1) {
            BufferProxy buffer = new BufferProxy(this.context, 1024);
            int offset = 0;
            this.readAll(sourceStream, buffer, offset);
            return buffer;
        }
        final TiStream fsourceStream = sourceStream;
        final BufferProxy fbuffer = bufferArg;
        final KrollCallback fresultsCallback = resultsCallback;
        new Thread(new Runnable(){

            @Override
            public void run() {
                int offset = 0;
                int errorState = 0;
                String errorDescription = "";
                if (fbuffer.getLength() < 1024) {
                    fbuffer.resize(1024);
                }
                try {
                    StreamModule.this.readAll(fsourceStream, fbuffer, offset);
                }
                catch (IOException e) {
                    errorState = 1;
                    errorDescription = e.getMessage();
                }
                fresultsCallback.callAsync(StreamModule.this.buildRWCallbackArgs(fsourceStream, fbuffer.getLength(), errorState, errorDescription));
            }
        }){}.start();
        return KrollProxy.UNDEFINED;
    }

    private void readAll(TiStream sourceStream, BufferProxy buffer, int offset) throws IOException {
        int bytesRead;
        int totalBytesRead = 0;
        while ((bytesRead = sourceStream.read(new Object[]{buffer, offset, 1024})) != -1) {
            buffer.resize(1024 + (totalBytesRead += bytesRead));
            offset += bytesRead;
        }
        buffer.resize(totalBytesRead);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(Object[] args) {
        TiStream outputStream = null;
        BufferProxy buffer = null;
        int offset = 0;
        int length = 0;
        KrollCallback resultsCallback = null;
        if (args.length != 3 && args.length != 5) throw new IllegalArgumentException("Invalid number of arguments");
        if (!(args[0] instanceof TiStream)) {
            throw new IllegalArgumentException("Invalid stream argument");
        }
        outputStream = (TiStream)args[0];
        if (!(args[1] instanceof BufferProxy)) {
            throw new IllegalArgumentException("Invalid buffer argument");
        }
        buffer = (BufferProxy)args[1];
        length = buffer.getLength();
        if (args.length == 3) {
            if (!(args[2] instanceof KrollCallback)) throw new IllegalArgumentException("Invalid callback argument");
            resultsCallback = (KrollCallback)args[2];
        } else if (args.length == 5) {
            if (!(args[2] instanceof Double)) {
                throw new IllegalArgumentException("Invalid offset argument");
            }
            offset = ((Double)args[2]).intValue();
            if (!(args[3] instanceof Double)) {
                throw new IllegalArgumentException("Invalid length argument");
            }
            length = ((Double)args[3]).intValue();
            if (!(args[4] instanceof KrollCallback)) throw new IllegalArgumentException("Invalid callback argument");
            resultsCallback = (KrollCallback)args[4];
        }
        final TiStream foutputStream = outputStream;
        final BufferProxy fbuffer = buffer;
        final int foffset = offset;
        final int flength = length;
        final KrollCallback fresultsCallback = resultsCallback;
        new Thread(new Runnable(){

            @Override
            public void run() {
                int bytesWritten = -1;
                int errorState = 0;
                String errorDescription = "";
                try {
                    bytesWritten = foutputStream.write(new Object[]{fbuffer, foffset, flength});
                }
                catch (IOException e) {
                    e.printStackTrace();
                    errorState = 1;
                    errorDescription = e.getMessage();
                }
                fresultsCallback.callAsync(StreamModule.this.buildRWCallbackArgs(foutputStream, bytesWritten, errorState, errorDescription));
            }
        }){}.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int writeStream(Object[] args) throws IOException {
        TiStream inputStream = null;
        TiStream outputStream = null;
        int maxChunkSize = 0;
        KrollCallback resultsCallback = null;
        if (args.length != 3 && args.length != 4) throw new IllegalArgumentException("Invalid number of arguments");
        if (!(args[0] instanceof TiStream)) {
            throw new IllegalArgumentException("Invalid input stream argument");
        }
        inputStream = (TiStream)args[0];
        if (!(args[1] instanceof TiStream)) {
            throw new IllegalArgumentException("Invalid output stream argument");
        }
        outputStream = (TiStream)args[1];
        if (!(args[2] instanceof Double)) {
            throw new IllegalArgumentException("Invalid max chunk size argument");
        }
        maxChunkSize = ((Double)args[2]).intValue();
        if (args.length == 4) {
            if (!(args[3] instanceof KrollCallback)) throw new IllegalArgumentException("Invalid callback argument");
            resultsCallback = (KrollCallback)args[3];
        }
        if (args.length == 3) {
            return this.writeStream(inputStream, outputStream, maxChunkSize);
        }
        final TiStream finputStream = inputStream;
        final TiStream foutputStream = outputStream;
        final int fmaxChunkSize = maxChunkSize;
        final KrollCallback fresultsCallback = resultsCallback;
        new Thread(new Runnable(){

            @Override
            public void run() {
                int totalBytesWritten = 0;
                int errorState = 0;
                String errorDescription = "";
                try {
                    totalBytesWritten = StreamModule.this.writeStream(finputStream, foutputStream, fmaxChunkSize);
                }
                catch (IOException e) {
                    errorState = 1;
                    errorDescription = e.getMessage();
                }
                fresultsCallback.callAsync(StreamModule.this.buildWriteStreamCallbackArgs(finputStream, foutputStream, totalBytesWritten, errorState, errorDescription));
            }
        }){}.start();
        return 0;
    }

    private int writeStream(TiStream inputStream, TiStream outputStream, int maxChunkSize) throws IOException {
        int bytesRead;
        BufferProxy buffer = new BufferProxy(this.getTiContext(), maxChunkSize);
        int totalBytesWritten = 0;
        while ((bytesRead = inputStream.read(new Object[]{buffer, 0, maxChunkSize})) != -1) {
            int bytesWritten = outputStream.write(new Object[]{buffer, 0, bytesRead});
            totalBytesWritten += bytesWritten;
            buffer.clear();
        }
        return totalBytesWritten;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pump(Object[] args) {
        TiStream inputStream = null;
        KrollCallback handler = null;
        int maxChunkSize = 0;
        boolean isAsync = false;
        if (args.length != 3 && args.length != 4) throw new IllegalArgumentException("Invalid number of arguments");
        if (!(args[0] instanceof TiStream)) {
            throw new IllegalArgumentException("Invalid stream argument");
        }
        inputStream = (TiStream)args[0];
        if (!(args[1] instanceof KrollCallback)) {
            throw new IllegalArgumentException("Invalid handler argument");
        }
        handler = (KrollCallback)args[1];
        if (!(args[2] instanceof Double)) {
            throw new IllegalArgumentException("Invalid max chunk size argument");
        }
        maxChunkSize = ((Double)args[2]).intValue();
        if (args.length == 4) {
            if (!(args[3] instanceof Boolean)) throw new IllegalArgumentException("Invalid async flag argument");
            isAsync = (Boolean)args[3];
        }
        if (isAsync) {
            final TiStream finputStream = inputStream;
            final KrollCallback fhandler = handler;
            final int fmaxChunkSize = maxChunkSize;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    StreamModule.this.pump(finputStream, fhandler, fmaxChunkSize);
                }
            }){}.start();
            return;
        } else {
            this.pump(inputStream, handler, maxChunkSize);
        }
    }

    private void pump(TiStream inputStream, KrollCallback handler, int maxChunkSize) {
        int totalBytesRead = 0;
        int errorState = 0;
        String errorDescription = "";
        try {
            int bytesRead;
            do {
                BufferProxy buffer = new BufferProxy(this.getTiContext(), maxChunkSize);
                bytesRead = inputStream.read(new Object[]{buffer, 0, maxChunkSize});
                if (bytesRead != -1) {
                    totalBytesRead += bytesRead;
                }
                if (bytesRead != buffer.getLength()) {
                    if (bytesRead == -1) {
                        buffer.resize(0);
                    } else {
                        buffer.resize(bytesRead);
                    }
                }
                handler.callSync(this.buildPumpCallbackArgs(inputStream, buffer, bytesRead, totalBytesRead, errorState, errorDescription));
                buffer = null;
            } while (bytesRead != -1);
        }
        catch (IOException e) {
            errorState = 1;
            errorDescription = e.getMessage();
            handler.callSync(this.buildPumpCallbackArgs(inputStream, new BufferProxy(this.getTiContext()), 0, totalBytesRead, errorState, errorDescription));
        }
    }

    private KrollDict buildRWCallbackArgs(TiStream sourceStream, int bytesProcessed, int errorState, String errorDescription) {
        KrollDict callbackArgs = new KrollDict();
        callbackArgs.put("source", sourceStream);
        callbackArgs.put("bytesProcessed", bytesProcessed);
        callbackArgs.put("errorState", errorState);
        callbackArgs.put("errorDescription", errorDescription);
        return callbackArgs;
    }

    private KrollDict buildWriteStreamCallbackArgs(TiStream fromStream, TiStream toStream, int bytesProcessed, int errorState, String errorDescription) {
        KrollDict callbackArgs = new KrollDict();
        callbackArgs.put("fromStream", fromStream);
        callbackArgs.put("toStream", toStream);
        callbackArgs.put("bytesProcessed", bytesProcessed);
        callbackArgs.put("errorState", errorState);
        callbackArgs.put("errorDescription", errorDescription);
        return callbackArgs;
    }

    private KrollDict buildPumpCallbackArgs(TiStream sourceStream, BufferProxy buffer, int bytesProcessed, int totalBytesProcessed, int errorState, String errorDescription) {
        KrollDict callbackArgs = new KrollDict();
        callbackArgs.put("source", sourceStream);
        callbackArgs.put("buffer", buffer);
        callbackArgs.put("bytesProcessed", bytesProcessed);
        callbackArgs.put("totalBytesProcessed", totalBytesProcessed);
        callbackArgs.put("errorState", errorState);
        callbackArgs.put("errorDescription", errorDescription);
        return callbackArgs;
    }
}

