/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.io.TiStream;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiStreamHelper;
import ti.modules.titanium.BufferProxy;

public class BufferStreamProxy
extends KrollProxy
implements TiStream {
    private static final String LCAT = "BufferStream";
    private static final boolean DBG = TiConfig.LOGD;
    private BufferProxy buffer;
    private int mode = -1;
    private int position = -1;
    private boolean isOpen = false;

    public BufferStreamProxy(BufferProxy buffer, int mode) {
        super(buffer.getTiContext());
        if (mode == 0) {
            this.position = 0;
        } else if (mode == 1) {
            this.position = 0;
        } else if (mode == 2) {
            this.position = buffer.getLength();
        } else {
            throw new IllegalArgumentException("invalid mode");
        }
        this.buffer = buffer;
        this.mode = mode;
        this.isOpen = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read(Object[] args) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Unable to read from buffer, not open");
        }
        if (this.mode != 0) {
            throw new IOException("Unable to read on a stream, not opened in read mode");
        }
        BufferProxy bufferProxy = null;
        int offset = 0;
        int length = 0;
        if (args.length != 1 && args.length != 3) throw new IllegalArgumentException("Invalid number of arguments");
        if (args.length > 0) {
            if (!(args[0] instanceof BufferProxy)) throw new IllegalArgumentException("Invalid buffer argument");
            bufferProxy = (BufferProxy)args[0];
            length = bufferProxy.getLength();
        }
        if (args.length == 3) {
            if (args[1] instanceof Integer) {
                offset = (Integer)args[1];
            } else {
                if (!(args[1] instanceof Double)) throw new IllegalArgumentException("Invalid offset argument");
                offset = ((Double)args[1]).intValue();
            }
            if (args[2] instanceof Integer) {
                length = (Integer)args[2];
            } else {
                if (!(args[2] instanceof Double)) throw new IllegalArgumentException("Invalid length argument");
                length = ((Double)args[2]).intValue();
            }
        }
        ByteArrayInputStream bufferInputStream = new ByteArrayInputStream(this.buffer.getBuffer(), this.position, this.buffer.getLength() - this.position);
        try {
            int bytesRead = TiStreamHelper.read(bufferInputStream, bufferProxy, offset, length);
            if (bytesRead <= -1) return bytesRead;
            this.position += bytesRead;
            return bytesRead;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("Unable to read from file, IO error");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int write(Object[] args) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Unable to write to buffer, not open");
        }
        if (this.mode != 1 && this.mode != 2) {
            throw new IOException("Unable to write on stream, not opened in read or append mode");
        }
        BufferProxy bufferProxy = null;
        int offset = 0;
        int length = 0;
        if (args.length != 1 && args.length != 3) throw new IllegalArgumentException("Invalid number of arguments");
        if (args.length > 0) {
            if (!(args[0] instanceof BufferProxy)) throw new IllegalArgumentException("Invalid buffer argument");
            bufferProxy = (BufferProxy)args[0];
            length = bufferProxy.getLength();
        }
        if (args.length == 3) {
            if (args[1] instanceof Integer) {
                offset = (Integer)args[1];
            } else {
                if (!(args[1] instanceof Double)) throw new IllegalArgumentException("Invalid offset argument");
                offset = ((Double)args[1]).intValue();
            }
            if (args[2] instanceof Integer) {
                length = (Integer)args[2];
            } else {
                if (!(args[2] instanceof Double)) throw new IllegalArgumentException("Invalid length argument");
                length = ((Double)args[2]).intValue();
            }
        }
        int bytesWritten = this.buffer.write(this.position, bufferProxy.getBuffer(), offset, length);
        this.position += bytesWritten;
        return bytesWritten;
    }

    @Override
    public boolean isWritable() {
        return this.mode == 1 || this.mode == 2;
    }

    @Override
    public boolean isReadable() {
        return this.mode == 0;
    }

    @Override
    public void close() throws IOException {
        this.buffer = null;
        this.mode = -1;
        this.position = -1;
        this.isOpen = false;
    }
}

