/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.stream;

import java.io.IOException;
import java.io.InputStream;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.io.TiStream;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiStreamHelper;
import ti.modules.titanium.BufferProxy;

public class BlobStreamProxy
extends KrollProxy
implements TiStream {
    private static final String LCAT = "BlobStream";
    private static final boolean DBG = TiConfig.LOGD;
    private TiBlob tiBlob;
    private InputStream inputStream = null;
    private boolean isOpen = false;

    public BlobStreamProxy(TiBlob tiBlob) {
        super(tiBlob.getTiContext());
        this.tiBlob = tiBlob;
        this.isOpen = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read(Object[] args) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Unable to read from blob, not open");
        }
        BufferProxy bufferProxy = null;
        int offset = 0;
        int length = 0;
        if (args.length != 1 && args.length != 3) throw new IllegalArgumentException("Invalid number of arguments");
        if (args.length > 0) {
            if (!(args[0] instanceof BufferProxy)) throw new IllegalArgumentException("Invalid buffer argument");
            bufferProxy = (BufferProxy)args[0];
            length = bufferProxy.getLength();
        }
        if (args.length == 3) {
            if (args[1] instanceof Integer) {
                offset = (Integer)args[1];
            } else {
                if (!(args[1] instanceof Double)) throw new IllegalArgumentException("Invalid offset argument");
                offset = ((Double)args[1]).intValue();
            }
            if (args[2] instanceof Integer) {
                length = (Integer)args[2];
            } else {
                if (!(args[2] instanceof Double)) throw new IllegalArgumentException("Invalid length argument");
                length = ((Double)args[2]).intValue();
            }
        }
        if (this.inputStream == null) {
            this.inputStream = this.tiBlob.getInputStream();
        }
        if (this.inputStream == null) throw new IOException("Unable to read from blob, input stream is null");
        try {
            return TiStreamHelper.read(this.inputStream, bufferProxy, offset, length);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("Unable to read from blob, IO error");
        }
    }

    @Override
    public int write(Object[] args) throws IOException {
        throw new IOException("Unable to write, blob is read only");
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.tiBlob = null;
        this.inputStream.close();
        this.isOpen = false;
    }
}

