/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium.codec;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConvert;
import org.mozilla.javascript.Scriptable;
import ti.modules.titanium.BufferProxy;

public class CodecModule
extends KrollModule {
    private static final String TAG = "TiCodec";
    public static final String CHARSET_ASCII = "ascii";
    public static final String CHARSET_ISO_LATIN_1 = "latin1";
    public static final String CHARSET_UTF8 = "utf8";
    public static final String CHARSET_UTF16 = "utf16";
    public static final String CHARSET_UTF16BE = "utf16be";
    public static final String CHARSET_UTF16LE = "utf16le";
    public static final String TYPE_BYTE = "byte";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_INT = "int";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_DOUBLE = "double";
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;

    public CodecModule(TiContext context) {
        super(context);
    }

    public int encodeNumber(KrollDict args) {
        if (!args.containsKey("dest")) {
            throw new IllegalArgumentException("dest was not specified for encodeNumber");
        }
        if (!args.containsKey("source")) {
            throw new IllegalArgumentException("src was not specified for encodeNumber");
        }
        if (!args.containsKey("type")) {
            throw new IllegalArgumentException("type was not specified for encodeNumber");
        }
        BufferProxy dest = (BufferProxy)args.get("dest");
        Double src = (Double)args.get("source");
        String type = TiConvert.toString(args, "type");
        int byteOrder = CodecModule.getByteOrder(args.get("byteOrder"));
        int position = 0;
        if (args.containsKey("position")) {
            position = TiConvert.toInt(args, "position");
        }
        byte[] buffer = dest.getBuffer();
        return CodecModule.encodeNumber(src, type, buffer, position, byteOrder);
    }

    public static int encodeNumber(Number src, String type, byte[] dest, int position, int byteOrder) {
        long l = src.longValue();
        if (type.equals(TYPE_BYTE)) {
            dest[position] = (byte)(l & 0xFFL);
            return position + 1;
        }
        if (type.equals(TYPE_SHORT)) {
            int bits = byteOrder == 0 ? 8 : 0;
            int step = byteOrder == 0 ? -8 : 8;
            int i = position;
            while (i < position + 2) {
                dest[i] = (byte)(l >>> bits & 0xFFL);
                ++i;
                bits += step;
            }
            return position + 2;
        }
        if (type.equals(TYPE_INT) || type.equals(TYPE_FLOAT)) {
            if (type.equals(TYPE_FLOAT)) {
                l = Float.floatToIntBits(src.floatValue());
            }
            int bits = byteOrder == 0 ? 24 : 0;
            int step = byteOrder == 0 ? -8 : 8;
            int j = position;
            while (j < position + 4) {
                dest[j] = (byte)(l >>> bits & 0xFFL);
                ++j;
                bits += step;
            }
            return position + 4;
        }
        if (type.equals(TYPE_LONG) || type.equals(TYPE_DOUBLE)) {
            if (type.equals(TYPE_DOUBLE)) {
                l = Double.doubleToLongBits(src.doubleValue());
            }
            int bits = byteOrder == 0 ? 56 : 0;
            int step = byteOrder == 0 ? -8 : 8;
            int i = position;
            while (i < position + 8) {
                dest[i] = (byte)(l >>> bits & 0xFFL);
                ++i;
                bits += step;
            }
            return position + 8;
        }
        return position;
    }

    public Object decodeNumber(KrollDict args) {
        if (!args.containsKey("source")) {
            throw new IllegalArgumentException("src was not specified for encodeNumber");
        }
        if (!args.containsKey("type")) {
            throw new IllegalArgumentException("type was not specified for encodeNumber");
        }
        BufferProxy buffer = (BufferProxy)args.get("source");
        String type = (String)args.get("type");
        int byteOrder = CodecModule.getByteOrder(args.get("byteOrder"));
        int position = 0;
        if (args.containsKey("position")) {
            position = TiConvert.toInt(args, "position");
        }
        byte[] src = buffer.getBuffer();
        if (type.equals(TYPE_BYTE)) {
            return src[position];
        }
        if (type.equals(TYPE_SHORT)) {
            short s1 = (short)(src[position] & 0xFF);
            short s2 = (short)(src[position + 1] & 0xFF);
            switch (byteOrder) {
                case 0: {
                    return (s1 << 8) + s2;
                }
                case 1: {
                    return (s2 << 8) + s1;
                }
            }
        } else {
            if (type.equals(TYPE_INT) || type.equals(TYPE_FLOAT)) {
                int bits = 0;
                int shiftBits = byteOrder == 0 ? 24 : 0;
                int step = byteOrder == 0 ? -8 : 8;
                int i = 0;
                while (i < 4) {
                    int part = src[position + i] & 0xFF;
                    bits += part << shiftBits;
                    ++i;
                    shiftBits += step;
                }
                if (type.equals(TYPE_FLOAT)) {
                    return Float.valueOf(Float.intBitsToFloat(bits));
                }
                return bits;
            }
            if (type.equals(TYPE_LONG) || type.equals(TYPE_DOUBLE)) {
                long bits = 0L;
                int shiftBits = byteOrder == 0 ? 56 : 0;
                int step = byteOrder == 0 ? -8 : 8;
                int i = 0;
                while (i < 8) {
                    long part = src[position + i] & 0xFF;
                    bits += part << shiftBits;
                    ++i;
                    shiftBits += step;
                }
                if (type.equals(TYPE_DOUBLE)) {
                    return Double.longBitsToDouble(bits);
                }
                return bits;
            }
        }
        return 0;
    }

    public int encodeString(KrollDict args) {
        if (!args.containsKey("dest")) {
            throw new IllegalArgumentException("dest was not specified for encodeString");
        }
        if (!args.containsKey("source") || args.get("source") == null) {
            throw new IllegalArgumentException("src was not specified for encodeString");
        }
        BufferProxy dest = (BufferProxy)args.get("dest");
        String src = (String)args.get("source");
        int destPosition = 0;
        if (args.containsKey("destPosition")) {
            destPosition = TiConvert.toInt(args, "destPosition");
        }
        int srcPosition = 0;
        if (args.containsKey("sourcePosition")) {
            srcPosition = TiConvert.toInt(args, "sourcePosition");
        }
        int srcLength = src.length();
        if (args.containsKey("sourceLength")) {
            srcLength = TiConvert.toInt(args, "sourceLength");
        }
        String charset = this.validateCharset(args);
        byte[] destBuffer = dest.getBuffer();
        this.validatePositionAndLength(srcPosition, srcLength, src.length());
        if (srcPosition != 0 || srcLength != src.length()) {
            src = src.substring(srcPosition, srcPosition + srcLength);
        }
        try {
            byte[] encoded = src.getBytes(charset);
            System.arraycopy(encoded, 0, destBuffer, destPosition, encoded.length);
            return destPosition + encoded.length;
        }
        catch (UnsupportedEncodingException e) {
            Log.w(TAG, e.getMessage(), e);
            throw new IllegalArgumentException("Unsupported Encoding: " + charset);
        }
    }

    public String decodeString(KrollDict args) {
        if (!args.containsKey("source") || args.get("source") == null) {
            throw new IllegalArgumentException("src was not specified for decodeString");
        }
        BufferProxy src = (BufferProxy)args.get("source");
        byte[] buffer = src.getBuffer();
        int position = 0;
        if (args.containsKey("position")) {
            position = TiConvert.toInt(args, "position");
        }
        int length = buffer.length;
        if (args.containsKey("length")) {
            length = TiConvert.toInt(args, "length");
        }
        this.validatePositionAndLength(position, length, buffer.length);
        String charset = this.validateCharset(args);
        try {
            return new String(buffer, position, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            Log.w(TAG, e.getMessage(), e);
            throw new IllegalArgumentException("Unsupported Encoding: " + charset);
        }
    }

    public int getNativeByteOrder() {
        return CodecModule.getByteOrder(null);
    }

    protected byte getByte(Scriptable scope, KrollProxy buffer, int position) {
        return ((Number)buffer.get(scope, position)).byteValue();
    }

    public static int getWidth(String dataType) {
        if (TYPE_BYTE.equals(dataType)) {
            return 1;
        }
        if (TYPE_SHORT.equals(dataType)) {
            return 2;
        }
        if (TYPE_INT.equals(dataType) || TYPE_FLOAT.equals(dataType)) {
            return 4;
        }
        if (TYPE_LONG.equals(dataType) || TYPE_DOUBLE.equals(dataType)) {
            return 8;
        }
        return 0;
    }

    public static int getByteOrder(Object byteOrder) {
        if (byteOrder instanceof Number) {
            return ((Number)byteOrder).intValue();
        }
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            return 0;
        }
        return 1;
    }

    public static String getCharset(String charset) {
        if (CHARSET_ASCII.equals(charset)) {
            return "US-ASCII";
        }
        if (CHARSET_ISO_LATIN_1.equals(charset)) {
            return "ISO-8859-1";
        }
        if (CHARSET_UTF8.equals(charset)) {
            return "UTF-8";
        }
        if (CHARSET_UTF16.equals(charset)) {
            return "UTF-16";
        }
        if (CHARSET_UTF16LE.equals(charset)) {
            return "UTF-16LE";
        }
        if (CHARSET_UTF16BE.equals(charset)) {
            return "UTF-16BE";
        }
        return null;
    }

    protected String validateCharset(KrollDict args) {
        String charset = "UTF-8";
        if (args.containsKey("charset")) {
            charset = CodecModule.getCharset(TiConvert.toString(args, "charset"));
        }
        if (charset == null) {
            throw new IllegalArgumentException("could not find a valid charset for " + args.get("charset"));
        }
        return charset;
    }

    protected void validatePositionAndLength(int position, int length, int expectedLength) {
        if (position + length > expectedLength) {
            throw new IllegalArgumentException("position " + position + " and length " + length + " is bigger than the expected length: " + expectedLength);
        }
    }
}

