/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium;

import android.app.Activity;
import android.app.Service;
import android.os.Handler;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.kroll.KrollModuleInfo;
import org.appcelerator.kroll.annotations.Kroll;
import org.appcelerator.titanium.TiBaseActivity;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiLaunchActivity;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.kroll.KrollContext;
import org.appcelerator.titanium.kroll.KrollHandlerThread;
import org.appcelerator.titanium.proxy.TiWindowProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiPlatformHelper;
import org.appcelerator.titanium.util.TiRHelper;
import org.appcelerator.titanium.util.TiUIHelper;
import org.mozilla.javascript.Context;

public class TitaniumModule
extends KrollModule
implements TiContext.OnLifecycleEvent,
TiContext.OnServiceLifecycleEvent {
    private static final String LCAT = "TitaniumModule";
    private static final boolean DBG = TiConfig.LOGD;
    private Stack<String> basePath;
    private Map<String, NumberFormat> numberFormats = Collections.synchronizedMap(new HashMap());
    private HashMap<Thread, HashMap<Integer, Timer>> timers = new HashMap();
    private int currentTimerId;

    public TitaniumModule(TiContext tiContext) {
        super(tiContext);
        this.basePath = new Stack();
        this.basePath.push(tiContext.getBaseUrl());
        if (tiContext.isServiceContext()) {
            tiContext.addOnServiceLifecycleEventListener(this);
        } else {
            tiContext.addOnLifecycleEventListener(this);
        }
    }

    public String getUserAgent() {
        StringBuilder builder = new StringBuilder();
        String httpAgent = System.getProperty("http.agent");
        if (httpAgent != null) {
            builder.append(httpAgent);
        }
        builder.append(" Titanium/").append(this.getVersion());
        return builder.toString();
    }

    public String getVersion() {
        return this.getTiContext().getTiApp().getTiBuildVersion();
    }

    public String getBuildTimestamp() {
        return this.getTiContext().getTiApp().getTiBuildTimestamp();
    }

    public String getBuildDate() {
        return this.getTiContext().getTiApp().getTiBuildTimestamp();
    }

    public String getBuildHash() {
        return this.getTiContext().getTiApp().getTiBuildHash();
    }

    public void testThrow() {
        throw new Error("Testing throwing throwables");
    }

    public void include(KrollInvocation invocation, Object[] files) {
        TiContext tiContext = invocation.getTiContext();
        for (Object filename : files) {
            try {
                boolean popContext = false;
                if (!this.basePath.contains(tiContext.getBaseUrl())) {
                    this.basePath.push(tiContext.getBaseUrl());
                    popContext = true;
                }
                String resolved = tiContext.resolveUrl(null, TiConvert.toString(filename), this.basePath.peek());
                this.basePath.push(resolved.substring(0, resolved.lastIndexOf(47) + 1));
                tiContext.evalFile(resolved);
                this.basePath.pop();
                if (!popContext) continue;
                this.basePath.pop();
            }
            catch (IOException e) {
                Log.e(LCAT, "Error while evaluating: " + filename, e);
            }
        }
    }

    private int createTimer(KrollContext context, Object fn, long timeout, Object[] args, boolean interval) throws IllegalArgumentException {
        if (fn instanceof KrollCallback) {
            KrollCallback callback = (KrollCallback)fn;
            int timerId = this.currentTimerId++;
            Handler handler = context.getMessageQueue().getHandler();
            Timer timer = new Timer(timerId, handler, callback, timeout, args, interval);
            Thread thread = handler.getLooper().getThread();
            HashMap<Integer, Timer> threadTimers = this.timers.get(thread);
            if (threadTimers == null) {
                threadTimers = new HashMap();
                this.timers.put(thread, threadTimers);
            }
            threadTimers.put(timerId, timer);
            timer.schedule();
            return timerId;
        }
        throw new IllegalArgumentException("Don't know how to call callback of type: " + fn.getClass().getName());
    }

    public int setTimeout(KrollInvocation invocation, Object fn, long timeout, Object[] args) throws IllegalArgumentException {
        return this.createTimer(invocation.getTiContext().getKrollContext(), fn, timeout, args, false);
    }

    public void clearTimeout(int timerId) {
        for (Thread thread : this.timers.keySet()) {
            HashMap<Integer, Timer> threadTimers = this.timers.get(thread);
            if (!threadTimers.containsKey(timerId)) continue;
            Timer timer = threadTimers.remove(timerId);
            timer.cancel();
            break;
        }
    }

    public int setInterval(KrollInvocation invocation, Object fn, long timeout, Object[] args) throws IllegalArgumentException {
        return this.createTimer(invocation.getTiContext().getKrollContext(), fn, timeout, args, true);
    }

    public void clearInterval(int timerId) {
        this.clearTimeout(timerId);
    }

    public void alert(KrollInvocation invocation, Object message) {
        String msg = message == null ? null : message.toString();
        Log.i("ALERT", msg);
        if (invocation.getTiContext().isServiceContext()) {
            Log.w(LCAT, "alert() called inside service -- no attempt will be made to display it to user interface.");
            return;
        }
        TiUIHelper.doOkDialog("Alert", msg, null);
    }

    public void cancelTimers(TiBaseActivity activity) {
        TiWindowProxy window = activity.getWindowProxy();
        KrollHandlerThread thread = null;
        if (window != null) {
            thread = this.getKrollBridge().getKrollContext().getThread();
        } else if (activity instanceof TiLaunchActivity) {
            TiLaunchActivity launchActivity = (TiLaunchActivity)activity;
            thread = launchActivity.getTiContext().getKrollContext().getThread();
        }
        if (thread != null) {
            this.cancelTimers(thread);
        } else {
            Log.w(LCAT, "Tried cancelling timers for an activity with no associated JS thread: " + activity);
        }
    }

    public void cancelTimers(Thread thread) {
        HashMap<Integer, Timer> threadTimers = this.timers.get(thread);
        if (threadTimers == null) {
            return;
        }
        Iterator<Timer> timerIter = threadTimers.values().iterator();
        while (timerIter.hasNext()) {
            Timer timer = timerIter.next();
            if (timer == null) continue;
            timer.cancel();
            timerIter.remove();
        }
        threadTimers.clear();
    }

    public String stringFormat(String format, Object[] args) {
        try {
            format = format.replaceAll("%d", "%1.0f");
            format = format.replaceAll("%@", "%s");
            if (args.length == 0) {
                return String.format(format, new Object[0]);
            }
            return String.format(format, args);
        }
        catch (Exception ex) {
            Log.e(LCAT, "Error in string format", ex);
            return null;
        }
    }

    public String stringFormatDate(Date date, @Kroll.argument(optional=true) String format) {
        int style = 3;
        if (format.equals("medium")) {
            style = 2;
        } else if (format.equals("long")) {
            style = 1;
        }
        DateFormat fmt = DateFormat.getDateInstance(style);
        return fmt.format(date);
    }

    public String stringFormatTime(Date time) {
        int style = 3;
        DateFormat fmt = DateFormat.getTimeInstance(style);
        return fmt.format(time);
    }

    public String stringFormatCurrency(double currency) {
        return NumberFormat.getCurrencyInstance().format(currency);
    }

    public String stringFormatDecimal(Object[] args) {
        NumberFormat format;
        String pattern = null;
        String locale = null;
        if (args.length == 2) {
            String test = TiConvert.toString(args[1]);
            if (test != null && test.length() > 0) {
                if (test.contains(".") || test.contains("#") || test.contains("0")) {
                    pattern = test;
                } else {
                    locale = test;
                }
            }
        } else if (args.length >= 3) {
            locale = TiConvert.toString(args[1]);
            pattern = TiConvert.toString(args[2]);
        }
        String key = (locale == null ? "" : locale) + " keysep " + (pattern == null ? "" : pattern);
        if (this.numberFormats.containsKey(key)) {
            format = this.numberFormats.get(key);
        } else {
            format = locale != null ? NumberFormat.getInstance(TiPlatformHelper.getLocale(locale)) : NumberFormat.getInstance();
            if (pattern != null && format instanceof DecimalFormat) {
                ((DecimalFormat)format).applyPattern(pattern);
            }
            this.numberFormats.put(key, format);
        }
        return format.format((Number)args[0]);
    }

    public String localize(KrollInvocation invocation, Object[] args) {
        String key = (String)args[0];
        String defaultValue = args.length > 1 ? (String)args[1] : null;
        try {
            int resid = TiRHelper.getResource("string." + key);
            if (resid != 0) {
                return invocation.getTiContext().getAndroidContext().getString(resid);
            }
            return defaultValue;
        }
        catch (TiRHelper.ResourceNotFoundException e) {
            if (DBG) {
                Log.d(LCAT, "Resource string with key '" + key + "' not found.  Returning default value.");
            }
            return defaultValue;
        }
        catch (Exception e) {
            Log.e(LCAT, "Exception trying to localize string '" + key + "': ", e);
            return defaultValue;
        }
    }

    protected KrollModule requireNativeModule(TiContext context, String path) {
        KrollModuleInfo info;
        if (DBG) {
            Log.d(LCAT, "Attempting to include native module: " + path);
        }
        if ((info = KrollModule.getModuleInfo(path)) == null) {
            return null;
        }
        return context.getTiApp().requireModule(context, info);
    }

    public Object require(KrollInvocation invocation, String path) {
        TiContext ctx = invocation.getTiContext().getRootActivity().getTiContext();
        KrollModule module2 = this.requireNativeModule(ctx, path);
        StringBuilder builder = new StringBuilder();
        if (module2 != null) {
            KrollModuleInfo info = module2.getModuleInfo();
            builder.append("Succesfully loaded module: ").append(info.getName()).append("/").append(info.getVersion());
            Log.i(LCAT, builder.toString());
            return module2;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((ctx = invocation.getTiContext()) == null) {
            Context.reportError((String)("Couldn't load module: " + path + " because execution context has been destroyed."));
            return null;
        }
        builder.setLength(0);
        builder.append("app://").append(path).append(".js");
        String fileUrl = builder.toString();
        try {
            return ctx.evalCommonJsModule(fileUrl);
        }
        catch (Exception ex) {
            Log.e(LCAT, "Error loading module named: " + path, ex);
            Context.throwAsScriptRuntimeEx((Throwable)ex);
            return null;
        }
    }

    @Override
    public void onDestroy(Activity activity) {
        if (activity instanceof TiBaseActivity) {
            this.cancelTimers((TiBaseActivity)activity);
        }
        super.onDestroy(activity);
    }

    @Override
    public void onDestroy(Service service) {
    }

    protected class Timer
    implements Runnable {
        protected long timeout;
        protected boolean interval;
        protected Object[] args;
        protected KrollCallback callback;
        protected Handler handler;
        protected int id;
        protected boolean canceled;

        public Timer(int id, Handler handler, KrollCallback callback, long timeout, Object[] args, boolean interval) {
            this.id = id;
            this.handler = handler;
            this.callback = callback;
            this.timeout = timeout;
            this.args = args;
            this.interval = interval;
        }

        public void schedule() {
            this.handler.postDelayed((Runnable)this, this.timeout);
        }

        @Override
        public void run() {
            if (this.canceled) {
                return;
            }
            if (DBG) {
                StringBuilder message = new StringBuilder("calling ").append(this.interval ? "interval" : "timeout").append(" timer ").append(this.id).append(" @").append(new Date().getTime());
                Log.d(TitaniumModule.LCAT, message.toString());
            }
            long start = System.currentTimeMillis();
            this.callback.callSync(this.args);
            if (this.interval && !this.canceled) {
                this.handler.postDelayed((Runnable)this, this.timeout - (System.currentTimeMillis() - start));
            }
        }

        public void cancel() {
            this.handler.removeCallbacks((Runnable)this);
            this.canceled = true;
        }
    }
}

