/*
 * Decompiled with CFR 0.152.
 */
package ti.modules.titanium;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.appcelerator.kroll.KrollConverter;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.kroll.KrollScriptableDict;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.mozilla.javascript.Scriptable;
import ti.modules.titanium.codec.CodecModule;

public class BufferProxy
extends KrollProxy {
    private static final String LCAT = "BufferProxy";
    private static final boolean DBG = TiConfig.LOGD;
    private byte[] buffer;

    public BufferProxy(TiContext context) {
        super(context);
    }

    public BufferProxy(TiContext context, int bufferSize) {
        super(context);
        this.buffer = new byte[bufferSize];
    }

    public BufferProxy(TiContext context, byte[] existingBuffer) {
        super(context);
        this.buffer = existingBuffer;
    }

    @Override
    public Object handleCreate(KrollInvocation invocation, Object[] args) {
        this.createdInModule = (KrollModule)invocation.getProxy();
        if (args.length > 0 && args[0] instanceof Scriptable) {
            KrollScriptableDict dict = new KrollScriptableDict((Scriptable)args[0]);
            this.handleCreationDict(dict);
        } else {
            this.buffer = new byte[0];
        }
        return KrollConverter.getInstance().convertNative(invocation, this);
    }

    @Override
    public void handleCreationDict(KrollDict dict) {
        super.handleCreationDict(dict);
        int length = 0;
        Object lengthProperty = dict.get("length");
        if (lengthProperty != null) {
            length = TiConvert.toInt(lengthProperty);
        }
        this.buffer = new byte[length];
        Object value = dict.get("value");
        if (value instanceof Number) {
            this.encodeNumber((Number)value, dict);
        } else if (value instanceof String) {
            this.encodeString((String)value, dict);
        }
    }

    protected void encodeNumber(Number value, KrollDict dict) {
        String type = TiConvert.toString(dict, "type");
        if (type == null) {
            throw new IllegalArgumentException("data is a Number, but no type was given");
        }
        if (this.buffer.length == 0) {
            this.buffer = new byte[CodecModule.getWidth(type)];
        }
        int byteOrder = CodecModule.getByteOrder(dict.get("byteOrder"));
        CodecModule.encodeNumber(value, type, this.buffer, 0, byteOrder);
    }

    protected void encodeString(String value, KrollDict dict) {
        String type = TiConvert.toString(dict, "type");
        if (type == null) {
            type = "utf8";
        }
        String charset = CodecModule.getCharset(type);
        try {
            byte[] bytes = value.getBytes(charset);
            if (this.buffer.length == 0) {
                this.buffer = bytes;
            } else {
                System.arraycopy(bytes, 0, this.buffer, 0, bytes.length);
            }
        }
        catch (UnsupportedEncodingException e) {
            Log.w(LCAT, e.getMessage(), e);
            throw new IllegalArgumentException("Unsupported Encoding: " + charset);
        }
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public boolean has(Scriptable scope, int index) {
        return this.buffer.length < index;
    }

    @Override
    public Object get(Scriptable scope, int index) {
        return this.buffer[index] & 0xFF;
    }

    @Override
    public void set(Scriptable scope, int index, Object value) {
        if (value instanceof Number) {
            this.buffer[index] = ((Number)value).byteValue();
        } else {
            super.set(scope, index, value);
        }
    }

    protected byte[] copyOf(byte[] array, int newLength) {
        byte[] newArray = new byte[newLength];
        int length = newLength;
        if (length > array.length) {
            length = array.length;
        }
        System.arraycopy(array, 0, newArray, 0, length);
        return newArray;
    }

    protected byte[] copyOfRange(byte[] array, int from, int to) {
        int length = to - from;
        byte[] newArray = new byte[length];
        System.arraycopy(array, from, newArray, 0, length);
        return newArray;
    }

    protected void validateOffsetAndLength(int offset, int length, int bufferLength) {
        if (length > offset + bufferLength) {
            throw new IllegalArgumentException("offset of " + offset + " and length of " + length + " is larger than the buffer length: " + bufferLength);
        }
    }

    public int write(int position, byte[] sourceBuffer, int sourceOffset, int sourceLength) {
        if (position + sourceLength > this.buffer.length) {
            this.buffer = this.copyOf(this.buffer, position + sourceLength);
        }
        System.arraycopy(sourceBuffer, sourceOffset, this.buffer, position, sourceLength);
        return sourceLength;
    }

    public int append(Object[] args) {
        int destLength = this.buffer.length;
        BufferProxy src = (BufferProxy)args[0];
        byte[] sourceBuffer = src.getBuffer();
        int offset = 0;
        if (args.length > 1 && args[1] != null) {
            offset = TiConvert.toInt(args[1]);
        }
        int sourceLength = sourceBuffer.length;
        if (args.length > 2 && args[2] != null) {
            sourceLength = TiConvert.toInt(args[2]);
        }
        this.validateOffsetAndLength(offset, sourceLength, sourceBuffer.length);
        this.buffer = this.copyOf(this.buffer, destLength + sourceLength);
        System.arraycopy(sourceBuffer, offset, this.buffer, destLength, sourceLength);
        return sourceLength;
    }

    public int insert(Object[] args) {
        if (args.length < 2) {
            throw new IllegalArgumentException("At least 2 arguments required for insert: src, offset");
        }
        BufferProxy sourceBufferProxy = (BufferProxy)args[0];
        byte[] sourceBuffer = sourceBufferProxy.getBuffer();
        int offset = TiConvert.toInt(args[1]);
        int sourceOffset = 0;
        if (args.length > 2 && args[2] != null) {
            sourceOffset = TiConvert.toInt(args[2]);
        }
        int sourceLength = sourceBuffer.length;
        if (args.length > 3 && args[3] != null) {
            sourceLength = TiConvert.toInt(args[3]);
        }
        this.validateOffsetAndLength(sourceOffset, sourceLength, sourceBuffer.length);
        byte[] preInsertBuffer = this.copyOf(this.buffer, offset);
        byte[] postInsertBuffer = this.copyOfRange(this.buffer, offset, this.buffer.length);
        this.buffer = new byte[preInsertBuffer.length + sourceLength + postInsertBuffer.length];
        System.arraycopy(preInsertBuffer, 0, this.buffer, 0, preInsertBuffer.length);
        System.arraycopy(sourceBuffer, sourceOffset, this.buffer, preInsertBuffer.length, sourceLength);
        System.arraycopy(postInsertBuffer, 0, this.buffer, preInsertBuffer.length + sourceLength, postInsertBuffer.length);
        return sourceLength;
    }

    public int copy(Object[] args) {
        if (args.length < 1) {
            throw new IllegalArgumentException("At least 1 argument required for copy: srcBuffer");
        }
        BufferProxy sourceBufferProxy = (BufferProxy)args[0];
        byte[] sourceBuffer = sourceBufferProxy.getBuffer();
        int offset = 0;
        if (args.length > 1 && args[1] != null) {
            offset = TiConvert.toInt(args[1]);
        }
        int sourceOffset = 0;
        if (args.length > 2 && args[2] != null) {
            sourceOffset = TiConvert.toInt(args[2]);
        }
        int sourceLength = sourceBuffer.length;
        if (args.length > 3 && args[3] != null) {
            sourceLength = TiConvert.toInt(args[3]);
        }
        this.validateOffsetAndLength(sourceOffset, sourceLength, sourceBuffer.length);
        System.arraycopy(sourceBuffer, sourceOffset, this.buffer, offset, sourceLength);
        return sourceLength;
    }

    public BufferProxy clone(Object[] args) {
        int offset = 0;
        if (args.length > 0 && args[0] != null) {
            offset = TiConvert.toInt(args[0]);
        }
        int length = this.buffer.length;
        if (args.length > 1 && args[1] != null) {
            length = TiConvert.toInt(args[1]);
        }
        this.validateOffsetAndLength(offset, length, this.buffer.length);
        return new BufferProxy(this.context, this.copyOfRange(this.buffer, offset, offset + length));
    }

    public void fill(Object[] args) {
        if (args.length < 1) {
            throw new IllegalArgumentException("fill requires at least 1 argument: fillByte");
        }
        int fillByte = TiConvert.toInt(args[0]);
        int offset = 0;
        if (args.length > 1 && args[1] != null) {
            offset = TiConvert.toInt(args[1]);
        }
        int length = this.buffer.length;
        if (args.length > 2 && args[2] != null) {
            length = TiConvert.toInt(args[2]);
        }
        this.validateOffsetAndLength(offset, length, this.buffer.length);
        Arrays.fill(this.buffer, offset, offset + length, (byte)fillByte);
    }

    public void clear() {
        Arrays.fill(this.buffer, (byte)0);
    }

    public void release() {
        this.buffer = new byte[0];
    }

    @Override
    public String toString() {
        return new String(this.buffer);
    }

    public TiBlob toBlob() {
        return TiBlob.blobFromData(this.context, this.buffer);
    }

    public int getLength() {
        return this.buffer.length;
    }

    public void setLength(int length) {
        this.resize(length);
    }

    public void resize(int length) {
        this.buffer = this.copyOf(this.buffer, length);
    }
}

