/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.view;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollPropertyChange;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.kroll.KrollProxyListener;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiAnimationBuilder;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiUIHelper;
import org.appcelerator.titanium.view.Ti2DMatrix;
import org.appcelerator.titanium.view.TiBackgroundDrawable;
import org.appcelerator.titanium.view.TiCompositeLayout;

public abstract class TiUIView
implements KrollProxyListener,
View.OnFocusChangeListener {
    private static final String LCAT = "TiUIView";
    private static final boolean DBG = TiConfig.LOGD;
    private static AtomicInteger idGenerator;
    public static final int SOFT_KEYBOARD_DEFAULT_ON_FOCUS = 0;
    public static final int SOFT_KEYBOARD_HIDE_ON_FOCUS = 1;
    public static final int SOFT_KEYBOARD_SHOW_ON_FOCUS = 2;
    protected View nativeView;
    protected TiViewProxy proxy;
    protected TiViewProxy parent;
    protected ArrayList<TiUIView> children = new ArrayList();
    protected TiCompositeLayout.LayoutParams layoutParams;
    protected int zIndex;
    protected TiAnimationBuilder animBuilder;
    protected TiBackgroundDrawable background;
    private KrollDict lastUpEvent = new KrollDict(2);
    private WeakReference<View> mTouchView = null;
    private static HashMap<Integer, String> motionEvents;

    public TiUIView(TiViewProxy proxy2) {
        if (idGenerator == null) {
            idGenerator = new AtomicInteger(0);
        }
        this.proxy = proxy2;
        this.layoutParams = new TiCompositeLayout.LayoutParams();
    }

    public void add(TiUIView child) {
        View nv;
        View cv;
        if (child != null && (cv = child.getNativeView()) != null && (nv = this.getNativeView()) instanceof ViewGroup) {
            if (cv.getParent() == null) {
                ((ViewGroup)nv).addView(cv, (ViewGroup.LayoutParams)child.getLayoutParams());
            }
            this.children.add(child);
        }
    }

    public void remove(TiUIView child) {
        View nv;
        View cv;
        if (child != null && (cv = child.getNativeView()) != null && (nv = this.getNativeView()) instanceof ViewGroup) {
            ((ViewGroup)nv).removeView(cv);
            this.children.remove(child);
        }
    }

    public List<TiUIView> getChildren() {
        return this.children;
    }

    public TiViewProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(TiViewProxy proxy2) {
        this.proxy = proxy2;
    }

    public TiViewProxy getParent() {
        return this.parent;
    }

    public void setParent(TiViewProxy parent) {
        this.parent = parent;
    }

    public TiCompositeLayout.LayoutParams getLayoutParams() {
        return this.layoutParams;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public View getNativeView() {
        return this.nativeView;
    }

    protected void setNativeView(View view) {
        if (view.getId() == -1) {
            view.setId(idGenerator.incrementAndGet());
        }
        this.nativeView = view;
        boolean clickable = true;
        if (this.proxy.hasProperty("touchEnabled")) {
            clickable = TiConvert.toBoolean(this.proxy.getProperty("touchEnabled"));
        }
        this.doSetClickable(this.nativeView, clickable);
        this.nativeView.setOnFocusChangeListener((View.OnFocusChangeListener)this);
    }

    protected void setLayoutParams(TiCompositeLayout.LayoutParams layoutParams) {
        this.layoutParams = layoutParams;
    }

    protected void setZIndex(int index) {
        this.zIndex = index;
    }

    public void animate() {
        TiAnimationBuilder builder = this.proxy.getPendingAnimation();
        if (builder != null && this.nativeView != null) {
            AnimationSet as = builder.render(this.proxy, this.nativeView);
            if (DBG) {
                Log.d(LCAT, "starting animation: " + as);
            }
            this.nativeView.startAnimation((Animation)as);
            this.proxy.clearAnimation();
        }
    }

    @Override
    public void listenerAdded(String type, int count, KrollProxy proxy2) {
    }

    @Override
    public void listenerRemoved(String type, int count, KrollProxy proxy2) {
    }

    private boolean hasImage(KrollDict d) {
        return d.containsKeyAndNotNull("backgroundImage") || d.containsKeyAndNotNull("backgroundSelectedImage") || d.containsKeyAndNotNull("backgroundFocusedImage") || d.containsKeyAndNotNull("backgroundDisabledImage");
    }

    private boolean hasBorder(KrollDict d) {
        return d.containsKeyAndNotNull("borderColor") || d.containsKeyAndNotNull("borderRadius") || d.containsKeyAndNotNull("borderWidth");
    }

    private boolean hasColorState(KrollDict d) {
        return d.containsKeyAndNotNull("backgroundSelectedColor") || d.containsKeyAndNotNull("backgroundFocusedColor") || d.containsKeyAndNotNull("backgroundFocusedColor");
    }

    protected void applyTransform(Ti2DMatrix matrix) {
        this.layoutParams.optionTransform = matrix;
        if (this.animBuilder == null) {
            this.animBuilder = new TiAnimationBuilder();
        }
        if (this.nativeView != null) {
            if (matrix != null) {
                TiAnimationBuilder.TiMatrixAnimation matrixAnimation = this.animBuilder.createMatrixAnimation(matrix);
                matrixAnimation.interpolate = false;
                matrixAnimation.setDuration(1L);
                matrixAnimation.setFillAfter(true);
                this.nativeView.startAnimation((Animation)matrixAnimation);
            } else {
                this.nativeView.clearAnimation();
            }
        }
    }

    protected void layoutNativeView() {
        if (this.nativeView != null) {
            Animation a = this.nativeView.getAnimation();
            if (a != null && a instanceof TiAnimationBuilder.TiMatrixAnimation) {
                TiAnimationBuilder.TiMatrixAnimation matrixAnimation = (TiAnimationBuilder.TiMatrixAnimation)a;
                matrixAnimation.invalidateWithMatrix(this.nativeView);
            }
            this.nativeView.requestLayout();
        }
    }

    @Override
    public void propertyChanged(String key, Object oldValue, Object newValue, KrollProxy proxy2) {
        if (key.equals("left")) {
            this.layoutParams.optionLeft = newValue != null ? TiConvert.toTiDimension(TiConvert.toString(newValue), 0) : null;
            this.layoutNativeView();
        } else if (key.equals("top")) {
            this.layoutParams.optionTop = newValue != null ? TiConvert.toTiDimension(TiConvert.toString(newValue), 3) : null;
            this.layoutNativeView();
        } else if (key.equals("center")) {
            TiConvert.updateLayoutCenter(newValue, this.layoutParams);
            this.layoutNativeView();
        } else if (key.equals("right")) {
            this.layoutParams.optionRight = newValue != null ? TiConvert.toTiDimension(TiConvert.toString(newValue), 2) : null;
            this.layoutNativeView();
        } else if (key.equals("bottom")) {
            this.layoutParams.optionBottom = newValue != null ? TiConvert.toTiDimension(TiConvert.toString(newValue), 5) : null;
            this.layoutNativeView();
        } else if (key.equals("size")) {
            if (newValue instanceof KrollDict) {
                KrollDict d = (KrollDict)newValue;
                this.propertyChanged("width", oldValue, d.get("width"), proxy2);
                this.propertyChanged("height", oldValue, d.get("height"), proxy2);
            } else if (newValue != null) {
                Log.w(LCAT, "Unsupported property type (" + newValue.getClass().getSimpleName() + ") for key: " + key + ". Must be an object/dictionary");
            }
        } else if (key.equals("height")) {
            if (newValue != null) {
                if (!newValue.equals("auto")) {
                    this.layoutParams.optionHeight = TiConvert.toTiDimension(TiConvert.toString(newValue), 7);
                    this.layoutParams.autoHeight = false;
                } else {
                    this.layoutParams.optionHeight = null;
                    this.layoutParams.autoHeight = true;
                }
            } else {
                this.layoutParams.optionHeight = null;
            }
            this.layoutNativeView();
        } else if (key.equals("width")) {
            if (newValue != null) {
                if (!newValue.equals("auto")) {
                    this.layoutParams.optionWidth = TiConvert.toTiDimension(TiConvert.toString(newValue), 6);
                    this.layoutParams.autoWidth = false;
                } else {
                    this.layoutParams.optionWidth = null;
                    this.layoutParams.autoWidth = true;
                }
            } else {
                this.layoutParams.optionWidth = null;
            }
            this.layoutNativeView();
        } else if (key.equals("zIndex")) {
            this.layoutParams.optionZIndex = newValue != null ? TiConvert.toInt(TiConvert.toString(newValue)) : 0;
            this.layoutNativeView();
        } else if (key.equals("focusable")) {
            boolean focusable = TiConvert.toBoolean(proxy2.getProperty("focusable"));
            this.nativeView.setFocusable(focusable);
            if (focusable) {
                this.registerForKeyClick(this.nativeView);
            } else {
                this.nativeView.setOnKeyListener(null);
            }
        } else if (key.equals("touchEnabled")) {
            this.doSetClickable(TiConvert.toBoolean(newValue));
        } else if (key.equals("visible")) {
            this.nativeView.setVisibility(TiConvert.toBoolean(newValue) ? 0 : 4);
        } else if (key.equals("enabled")) {
            this.nativeView.setEnabled(TiConvert.toBoolean(newValue));
        } else if (key.startsWith("backgroundPadding")) {
            Log.i(LCAT, key + " not yet implemented.");
        } else if (key.equals("opacity") || key.startsWith("background") || key.startsWith("border")) {
            boolean requiresCustomBackground;
            proxy2.setProperty(key, newValue, false);
            KrollDict d = proxy2.getProperties();
            boolean hasImage = this.hasImage(d);
            boolean hasColorState = this.hasColorState(d);
            boolean hasBorder = this.hasBorder(d);
            boolean bl = requiresCustomBackground = hasImage || hasColorState || hasBorder;
            if (!requiresCustomBackground) {
                if (this.background != null) {
                    this.background.releaseDelegate();
                    this.background.setCallback(null);
                    this.background = null;
                }
                if (d.containsKeyAndNotNull("backgroundColor")) {
                    Integer bgColor = TiConvert.toColor(d, "backgroundColor");
                    if (this.nativeView != null) {
                        this.nativeView.setBackgroundColor(bgColor.intValue());
                        this.nativeView.postInvalidate();
                    }
                } else {
                    if (key.equals("opacity")) {
                        this.setOpacity(TiConvert.toFloat(newValue));
                    }
                    if (this.nativeView != null) {
                        this.nativeView.setBackgroundDrawable(null);
                        this.nativeView.postInvalidate();
                    }
                }
            } else {
                boolean newBackground;
                boolean bl2 = newBackground = this.background == null;
                if (newBackground) {
                    this.background = new TiBackgroundDrawable();
                }
                Integer bgColor = null;
                if (!hasColorState && d.get("backgroundColor") != null) {
                    bgColor = TiConvert.toColor(d, "backgroundColor");
                    if (newBackground || key.equals("opacity") || key.equals("backgroundColor")) {
                        this.background.setBackgroundColor(bgColor);
                    }
                }
                if ((hasImage || hasColorState) && (newBackground || key.startsWith("background"))) {
                    this.handleBackgroundImage(d);
                }
                if (hasBorder) {
                    if (newBackground) {
                        this.initializeBorder(d, bgColor);
                    } else if (key.startsWith("border")) {
                        this.handleBorderProperty(key, newValue);
                    }
                }
                this.applyCustomBackground();
            }
            if (this.nativeView != null) {
                this.nativeView.postInvalidate();
            }
        } else if (key.equals("softKeyboardOnFocus")) {
            Log.w(LCAT, "Focus state changed to " + TiConvert.toString(newValue) + " not honored until next focus event.");
        } else if (key.equals("transform")) {
            if (this.nativeView != null) {
                this.applyTransform((Ti2DMatrix)newValue);
            }
        } else if (DBG) {
            Log.d(LCAT, "Unhandled property key: " + key);
        }
    }

    @Override
    public void processProperties(KrollDict d) {
        Ti2DMatrix matrix;
        if (d.containsKey("layout")) {
            String layout = TiConvert.toString(d, "layout");
            if (this.nativeView instanceof TiCompositeLayout) {
                ((TiCompositeLayout)this.nativeView).setLayoutArrangement(layout);
            }
        }
        if (TiConvert.fillLayout(d, this.layoutParams) && this.nativeView != null) {
            this.nativeView.requestLayout();
        }
        Integer bgColor = null;
        if (this.hasImage(d) || this.hasColorState(d) || this.hasBorder(d)) {
            this.handleBackgroundImage(d);
        } else if (d.containsKey("backgroundColor")) {
            bgColor = TiConvert.toColor(d, "backgroundColor");
            this.nativeView.setBackgroundColor(bgColor.intValue());
        }
        if (d.containsKey("opacity") && this.nativeView != null) {
            this.setOpacity(TiConvert.toFloat(d, "opacity"));
        }
        if (d.containsKey("visible")) {
            this.nativeView.setVisibility(TiConvert.toBoolean(d, "visible") ? 0 : 4);
        }
        if (d.containsKey("enabled")) {
            this.nativeView.setEnabled(TiConvert.toBoolean(d, "enabled"));
        }
        if (d.containsKey("focusable")) {
            boolean focusable = TiConvert.toBoolean(d, "focusable");
            this.nativeView.setFocusable(focusable);
            if (focusable) {
                this.registerForKeyClick(this.nativeView);
            } else {
                this.nativeView.setOnKeyListener(null);
            }
        }
        this.initializeBorder(d, bgColor);
        if (d.containsKey("transform") && (matrix = (Ti2DMatrix)d.get("transform")) != null) {
            this.applyTransform(matrix);
        }
    }

    @Override
    public void propertiesChanged(List<KrollPropertyChange> changes, KrollProxy proxy2) {
        for (KrollPropertyChange change : changes) {
            this.propertyChanged(change.getName(), change.getOldValue(), change.getNewValue(), proxy2);
        }
    }

    private void applyCustomBackground() {
        this.applyCustomBackground(true);
    }

    private void applyCustomBackground(boolean reuseCurrentDrawable) {
        if (this.nativeView != null) {
            if (this.background == null) {
                this.background = new TiBackgroundDrawable();
                Drawable currentDrawable = this.nativeView.getBackground();
                if (currentDrawable != null) {
                    if (reuseCurrentDrawable) {
                        this.background.setBackgroundDrawable(currentDrawable);
                    } else {
                        this.nativeView.setBackgroundDrawable(null);
                        currentDrawable.setCallback(null);
                        if (currentDrawable instanceof TiBackgroundDrawable) {
                            ((TiBackgroundDrawable)currentDrawable).releaseDelegate();
                        }
                    }
                }
            }
            this.nativeView.setBackgroundDrawable((Drawable)this.background);
        }
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (hasFocus) {
            TiUIHelper.requestSoftInputChange(this.proxy, v);
            this.proxy.fireEvent("focus", this.getFocusEventObject(hasFocus));
        } else {
            this.proxy.fireEvent("blur", this.getFocusEventObject(hasFocus));
        }
    }

    protected KrollDict getFocusEventObject(boolean hasFocus) {
        return null;
    }

    protected InputMethodManager getIMM() {
        InputMethodManager imm = null;
        imm = (InputMethodManager)this.proxy.getTiContext().getTiApp().getSystemService("input_method");
        return imm;
    }

    public void focus() {
        if (this.nativeView != null) {
            this.nativeView.requestFocus();
        }
    }

    public void blur() {
        if (this.nativeView != null) {
            InputMethodManager imm = this.getIMM();
            if (imm != null) {
                imm.hideSoftInputFromWindow(this.nativeView.getWindowToken(), 0);
            }
            this.nativeView.clearFocus();
        }
    }

    public void release() {
        View nv;
        if (DBG) {
            Log.d(LCAT, "Releasing: " + this);
        }
        if ((nv = this.getNativeView()) != null) {
            Drawable d;
            if (nv instanceof ViewGroup) {
                ViewGroup vg = (ViewGroup)nv;
                if (DBG) {
                    Log.d(LCAT, "Group has: " + vg.getChildCount());
                }
                if (!(vg instanceof AdapterView)) {
                    vg.removeAllViews();
                }
            }
            if ((d = nv.getBackground()) != null) {
                nv.setBackgroundDrawable(null);
                d.setCallback(null);
                if (d instanceof TiBackgroundDrawable) {
                    ((TiBackgroundDrawable)d).releaseDelegate();
                }
                d = null;
            }
            this.nativeView = null;
            if (this.proxy != null) {
                this.proxy.setModelListener(null);
            }
        }
    }

    public void show() {
        if (this.nativeView != null) {
            this.nativeView.setVisibility(0);
        } else if (DBG) {
            Log.w(LCAT, "Attempt to show null native control");
        }
    }

    public void hide() {
        if (this.nativeView != null) {
            this.nativeView.setVisibility(4);
        } else if (DBG) {
            Log.w(LCAT, "Attempt to hide null native control");
        }
    }

    private void handleBackgroundImage(KrollDict d) {
        String bg = d.getString("backgroundImage");
        String bgSelected = d.getString("backgroundSelectedImage");
        String bgFocused = d.getString("backgroundFocusedImage");
        String bgDisabled = d.getString("backgroundDisabledImage");
        String bgColor = d.getString("backgroundColor");
        String bgSelectedColor = d.getString("backgroundSelectedColor");
        String bgFocusedColor = d.getString("backgroundFocusedColor");
        String bgDisabledColor = d.getString("backgroundDisabledColor");
        TiContext tiContext = this.getProxy().getTiContext();
        if (bg != null) {
            bg = tiContext.resolveUrl(null, bg);
        }
        if (bgSelected != null) {
            bgSelected = tiContext.resolveUrl(null, bgSelected);
        }
        if (bgFocused != null) {
            bgFocused = tiContext.resolveUrl(null, bgFocused);
        }
        if (bgDisabled != null) {
            bgDisabled = tiContext.resolveUrl(null, bgDisabled);
        }
        if (bg != null || bgSelected != null || bgFocused != null || bgDisabled != null || bgColor != null || bgSelectedColor != null || bgFocusedColor != null || bgDisabledColor != null) {
            if (this.background == null) {
                this.applyCustomBackground(false);
            }
            StateListDrawable bgDrawable = TiUIHelper.buildBackgroundDrawable(tiContext, bg, bgColor, bgSelected, bgSelectedColor, bgDisabled, bgDisabledColor, bgFocused, bgFocusedColor);
            this.background.setBackgroundDrawable((Drawable)bgDrawable);
        }
    }

    private void initializeBorder(KrollDict d, Integer bgColor) {
        if ((d.containsKey("borderRadius") || d.containsKey("borderColor") || d.containsKey("borderWidth")) && this.nativeView != null) {
            if (this.background == null) {
                this.applyCustomBackground();
            }
            if (this.background.getBorder() == null) {
                this.background.setBorder(new TiBackgroundDrawable.Border());
            }
            TiBackgroundDrawable.Border border = this.background.getBorder();
            if (d.containsKey("borderRadius")) {
                border.setRadius(TiConvert.toFloat(d, "borderRadius"));
            }
            if (d.containsKey("borderColor") || d.containsKey("borderWidth")) {
                if (d.containsKey("borderColor")) {
                    border.setColor(TiConvert.toColor(d, "borderColor"));
                } else if (bgColor != null) {
                    border.setColor(bgColor);
                }
                if (d.containsKey("borderWidth")) {
                    border.setWidth(TiConvert.toFloat(d, "borderWidth"));
                }
            }
        }
    }

    private void handleBorderProperty(String property2, Object value) {
        if (this.background.getBorder() == null) {
            this.background.setBorder(new TiBackgroundDrawable.Border());
        }
        TiBackgroundDrawable.Border border = this.background.getBorder();
        if (property2.equals("borderColor")) {
            border.setColor(TiConvert.toColor(value.toString()));
        } else if (property2.equals("borderRadius")) {
            border.setRadius(TiConvert.toFloat(value));
        } else if (property2.equals("borderWidth")) {
            border.setWidth(TiConvert.toFloat(value));
        }
        this.applyCustomBackground();
    }

    private KrollDict dictFromEvent(MotionEvent e) {
        KrollDict data = new KrollDict();
        data.put("x", Double.valueOf(e.getX()));
        data.put("y", Double.valueOf(e.getY()));
        data.put("source", this.proxy);
        return data;
    }

    private KrollDict dictFromEvent(KrollDict dictToCopy) {
        KrollDict data = new KrollDict();
        if (dictToCopy.containsKey("x")) {
            data.put("x", dictToCopy.get("x"));
        } else {
            data.put("x", 0.0);
        }
        if (dictToCopy.containsKey("y")) {
            data.put("y", dictToCopy.get("y"));
        } else {
            data.put("y", 0.0);
        }
        data.put("source", this.proxy);
        return data;
    }

    protected boolean allowRegisterForTouch() {
        return true;
    }

    public void registerForTouch() {
        if (this.allowRegisterForTouch()) {
            this.registerForTouch(this.getNativeView());
        }
    }

    protected void registerForTouch(final View touchable) {
        if (touchable == null) {
            return;
        }
        this.mTouchView = new WeakReference<View>(touchable);
        final GestureDetector detector = new GestureDetector((Context)this.proxy.getTiContext().getActivity(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent e) {
                boolean handledTap = TiUIView.this.proxy.fireEvent("doubletap", TiUIView.this.dictFromEvent(e));
                boolean handledClick = TiUIView.this.proxy.fireEvent("dblclick", TiUIView.this.dictFromEvent(e));
                return handledTap || handledClick;
            }

            public boolean onSingleTapConfirmed(MotionEvent e) {
                if (DBG) {
                    Log.d(TiUIView.LCAT, "TAP, TAP, TAP on " + TiUIView.this.proxy);
                }
                boolean handledTap = TiUIView.this.proxy.fireEvent("singletap", TiUIView.this.dictFromEvent(e));
                return handledTap;
            }
        });
        touchable.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                boolean handled;
                if (event.getAction() == 1) {
                    TiUIView.this.lastUpEvent.put("x", Double.valueOf(event.getX()));
                    TiUIView.this.lastUpEvent.put("y", Double.valueOf(event.getY()));
                }
                if (!(handled = detector.onTouchEvent(event)) && motionEvents.containsKey(event.getAction())) {
                    if (event.getAction() == 1) {
                        Rect r = new Rect(0, 0, view.getWidth(), view.getHeight());
                        int actualAction = r.contains((int)event.getX(), (int)event.getY()) ? 1 : 3;
                        handled = TiUIView.this.proxy.fireEvent((String)motionEvents.get(actualAction), TiUIView.this.dictFromEvent(event));
                        if (handled && actualAction == 1) {
                            touchable.performClick();
                        }
                        return handled;
                    }
                    handled = TiUIView.this.proxy.fireEvent((String)motionEvents.get(event.getAction()), TiUIView.this.dictFromEvent(event));
                }
                return handled;
            }
        });
        this.doSetClickable(touchable);
    }

    public void setOpacity(float opacity) {
        this.setOpacity(this.nativeView, opacity);
    }

    protected void setOpacity(View view, float opacity) {
        if (view != null) {
            TiUIHelper.setDrawableOpacity(view.getBackground(), opacity);
            if (opacity == 1.0f) {
                this.clearOpacity(view);
            }
            view.invalidate();
        }
    }

    public void clearOpacity(View view) {
        Drawable d = view.getBackground();
        if (d != null) {
            d.clearColorFilter();
        }
    }

    protected void registerForKeyClick(View clickable) {
        clickable.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int keyCode, KeyEvent event) {
                if (event.getAction() == 1) {
                    switch (keyCode) {
                        case 23: 
                        case 66: {
                            if (!TiUIView.this.proxy.hasListeners("click")) break;
                            TiUIView.this.proxy.fireEvent("click", null);
                            return true;
                        }
                    }
                }
                return false;
            }
        });
    }

    public KrollDict toImage() {
        return TiUIHelper.viewToImage(this.proxy.getTiContext(), this.proxy.getProperties(), this.getNativeView());
    }

    private View getTouchView() {
        if (this.nativeView != null) {
            return this.nativeView;
        }
        if (this.mTouchView != null) {
            return (View)this.mTouchView.get();
        }
        return null;
    }

    private void doSetClickable(View view, boolean clickable) {
        if (view == null) {
            return;
        }
        if (!clickable) {
            view.setOnClickListener(null);
            view.setClickable(false);
        } else if (!(view instanceof AdapterView)) {
            this.setOnClickListener(view);
        }
    }

    private void doSetClickable(boolean clickable) {
        this.doSetClickable(this.getTouchView(), clickable);
    }

    private void doSetClickable(View view) {
        if (view == null) {
            return;
        }
        this.doSetClickable(view, view.isClickable());
    }

    private void doSetClickable() {
        View view = this.getTouchView();
        if (view == null) {
            return;
        }
        this.doSetClickable(view, view.isClickable());
    }

    protected void setOnClickListener(View view) {
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TiUIView.this.proxy.fireEvent("click", TiUIView.this.dictFromEvent(TiUIView.this.lastUpEvent));
            }
        });
    }

    static {
        motionEvents = new HashMap();
        motionEvents.put(0, "touchstart");
        motionEvents.put(1, "touchend");
        motionEvents.put(2, "touchmove");
        motionEvents.put(3, "touchcancel");
    }
}

