/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.view;

import android.content.ContextWrapper;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.webkit.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiDimension;
import org.appcelerator.titanium.TiFastDev;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.io.TiFileFactory;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiBackgroundImageLoadTask;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiDownloadListener;
import org.appcelerator.titanium.util.TiDownloadManager;
import org.appcelerator.titanium.util.TiFileHelper;
import org.appcelerator.titanium.util.TiUIHelper;

public class TiDrawableReference {
    private static Map<Integer, Bounds> boundsCache = Collections.synchronizedMap(new HashMap());
    private static final String LCAT = "TiDrawableReference";
    private static final int UNKNOWN = -1;
    private static final int DEFAULT_SAMPLE_SIZE = 1;
    private int resourceId = -1;
    private String url;
    private TiBlob blob;
    private TiBaseFile file;
    private DrawableReferenceType type;
    private boolean oomOccurred = false;
    private SoftReference<TiContext> softContext = null;
    private TiFileHelper fileHelper = null;

    public TiDrawableReference(TiContext context, DrawableReferenceType type) {
        this.type = type;
        this.softContext = new SoftReference<TiContext>(context);
    }

    public int hashCode() {
        int total = 17;
        int constant2 = 37;
        total = total * 37 + this.type.ordinal();
        total = total * 37 + (this.url == null ? 0 : this.url.hashCode());
        total = total * 37 + (this.blob == null ? 0 : this.blob.hashCode());
        total = total * 37 + (this.file == null ? 0 : this.file.hashCode());
        total = total * 37 + this.resourceId;
        return total;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TiDrawableReference)) {
            return super.equals(object);
        }
        return this.hashCode() == ((TiDrawableReference)object).hashCode();
    }

    public static TiDrawableReference fromResourceId(TiContext context, int resourceId) {
        TiDrawableReference ref = new TiDrawableReference(context, DrawableReferenceType.RESOURCE_ID);
        ref.resourceId = resourceId;
        return ref;
    }

    public static TiDrawableReference fromBlob(TiContext context, TiBlob blob) {
        TiDrawableReference ref = new TiDrawableReference(context, DrawableReferenceType.BLOB);
        ref.blob = blob;
        return ref;
    }

    public static TiDrawableReference fromUrl(TiContext context, String url) {
        int id;
        TiDrawableReference ref = new TiDrawableReference(context, DrawableReferenceType.URL);
        ref.url = url;
        if (url != null && (id = TiUIHelper.getResourceId(context.resolveUrl(null, url))) != 0) {
            ref.type = DrawableReferenceType.RESOURCE_ID;
            ref.resourceId = id;
        }
        return ref;
    }

    public static TiDrawableReference fromFile(TiContext context, TiBaseFile file) {
        TiDrawableReference ref = new TiDrawableReference(context, DrawableReferenceType.FILE);
        ref.file = file;
        return ref;
    }

    public static TiDrawableReference fromDictionary(TiContext context, KrollDict dict) {
        if (dict.containsKey("media")) {
            return TiDrawableReference.fromBlob(context, TiConvert.toBlob(dict, "media"));
        }
        Log.w(LCAT, "Unknown drawable reference inside dictionary.  Expected key 'media' to be a blob.  Returning null drawable reference");
        return TiDrawableReference.fromObject(context, null);
    }

    public static TiDrawableReference fromObject(TiContext context, Object object) {
        if (object == null) {
            return new TiDrawableReference(context, DrawableReferenceType.NULL);
        }
        if (object instanceof String) {
            return TiDrawableReference.fromUrl(context, TiConvert.toString(object));
        }
        if (object instanceof KrollDict) {
            return TiDrawableReference.fromDictionary(context, (KrollDict)object);
        }
        if (object instanceof TiBaseFile) {
            return TiDrawableReference.fromFile(context, (TiBaseFile)object);
        }
        if (object instanceof TiBlob) {
            return TiDrawableReference.fromBlob(context, TiConvert.toBlob(object));
        }
        if (object instanceof Number) {
            return TiDrawableReference.fromResourceId(context, ((Number)object).intValue());
        }
        Log.w(LCAT, "Unknown image resource type: " + object.getClass().getSimpleName() + ". Returning null drawable reference");
        return TiDrawableReference.fromObject(context, null);
    }

    public boolean isNetworkUrl() {
        return this.type == DrawableReferenceType.URL && this.url != null && URLUtil.isNetworkUrl((String)this.url);
    }

    public boolean isTypeUrl() {
        return this.type == DrawableReferenceType.URL;
    }

    public boolean isTypeFile() {
        return this.type == DrawableReferenceType.FILE;
    }

    public boolean isTypeBlob() {
        return this.type == DrawableReferenceType.BLOB;
    }

    public boolean isTypeResourceId() {
        return this.type == DrawableReferenceType.RESOURCE_ID;
    }

    public boolean isTypeNull() {
        return this.type == DrawableReferenceType.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmap() {
        InputStream is = this.getInputStream();
        if (is == null) {
            Log.w(LCAT, "Could not open stream to get bitmap");
            return null;
        }
        Bitmap b = null;
        try {
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inInputShareable = true;
            opts.inPurgeable = true;
            try {
                this.oomOccurred = false;
                b = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)opts);
            }
            catch (OutOfMemoryError e) {
                this.oomOccurred = true;
                Log.e(LCAT, "Unable to load bitmap. Not enough memory: " + e.getMessage(), e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                Log.e(LCAT, "Problem closing stream: " + e.getMessage(), e);
            }
        }
        return b;
    }

    private Resources getResources() {
        ContextWrapper context;
        TiContext tiContext = this.softContext.get();
        if (tiContext != null && (context = tiContext.getAndroidContext()) != null) {
            return context.getResources();
        }
        return null;
    }

    private Drawable getResourceDrawable() {
        if (!this.isTypeResourceId()) {
            return null;
        }
        Drawable drawable = null;
        Resources resources = this.getResources();
        if (resources != null && this.resourceId > 0) {
            try {
                drawable = resources.getDrawable(this.resourceId);
            }
            catch (Resources.NotFoundException e) {
                drawable = null;
            }
        }
        return drawable;
    }

    public Drawable getDrawable(View parent, TiDimension destWidthDimension, TiDimension destHeightDimension) {
        Bitmap b;
        Drawable drawable = this.getResourceDrawable();
        if (drawable == null && (b = this.getBitmap(parent, destWidthDimension, destHeightDimension)) != null) {
            drawable = new BitmapDrawable(b);
        }
        return drawable;
    }

    public Drawable getDrawable(int destWidth, int destHeight) {
        Bitmap b;
        Drawable drawable = this.getResourceDrawable();
        if (drawable == null && (b = this.getBitmap(destWidth, destHeight)) != null) {
            drawable = new BitmapDrawable(b);
        }
        return drawable;
    }

    public Drawable getDrawable() {
        Bitmap b;
        Drawable drawable = this.getResourceDrawable();
        if (drawable == null && (b = this.getBitmap()) != null) {
            drawable = new BitmapDrawable(b);
        }
        return drawable;
    }

    public Bitmap getBitmap(int destWidth, int destHeight) {
        return this.getBitmap(null, TiConvert.toTiDimension(new Integer(destWidth), 6), TiConvert.toTiDimension(new Integer(destHeight), 7));
    }

    public Bitmap getBitmap(int destWidth) {
        Bounds orig = this.peekBounds();
        int srcWidth = orig.width;
        int srcHeight = orig.height;
        if (srcWidth <= 0 || srcHeight <= 0) {
            Log.w(LCAT, "Bitmap bounds could not be determined.  If bitmap is loaded, it won't be scaled.");
            return this.getBitmap();
        }
        double aspectRatio = (double)srcWidth / (double)srcHeight;
        int destHeight = (int)((double)destWidth / aspectRatio);
        return this.getBitmap(destWidth, destHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmap(View parent, TiDimension destWidthDimension, TiDimension destHeightDimension) {
        Bounds bounds = this.peekBounds();
        int srcWidth = bounds.width;
        int srcHeight = bounds.height;
        if (srcWidth <= 0 || srcHeight <= 0) {
            Log.w(LCAT, "Bitmap bounds could not be determined.  If bitmap is loaded, it won't be scaled.");
            return this.getBitmap();
        }
        InputStream is = this.getInputStream();
        if (is == null) {
            Log.w(LCAT, "Could not open stream to get bitmap");
            return null;
        }
        Bitmap b = null;
        try {
            int destWidth;
            if (destWidthDimension == null) {
                int parentWidth;
                destWidth = srcWidth;
                TiContext context = this.softContext.get();
                if (context != null && context.getActivity() != null && context.getActivity().getWindow() != null && (parentWidth = context.getActivity().getWindow().getDecorView().getWidth()) > 0) {
                    destWidth = parentWidth;
                }
            } else {
                int n = destWidth = destWidthDimension.isUnitAuto() ? srcWidth : destWidthDimension.getAsPixels(parent);
            }
            int destHeight = destHeightDimension == null ? (int)((float)srcHeight / (float)srcWidth * (float)destWidth) : (destHeightDimension.isUnitAuto() ? srcHeight : destHeightDimension.getAsPixels(parent));
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inInputShareable = true;
            opts.inPurgeable = true;
            opts.inSampleSize = this.calcSampleSize(srcWidth, srcHeight, destWidth, destHeight);
            Bitmap bTemp = null;
            try {
                this.oomOccurred = false;
                bTemp = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)opts);
                if (bTemp == null) {
                    Log.w(LCAT, "Decoded bitmap is null");
                    Bitmap bitmap = null;
                    return bitmap;
                }
                b = Bitmap.createScaledBitmap((Bitmap)bTemp, (int)destWidth, (int)destHeight, (boolean)true);
            }
            catch (OutOfMemoryError e) {
                this.oomOccurred = true;
                Log.e(LCAT, "Unable to load bitmap. Not enough memory: " + e.getMessage(), e);
            }
            finally {
                if (bTemp != null) {
                    bTemp.recycle();
                    bTemp = null;
                }
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                Log.e(LCAT, "Problem closing stream: " + e.getMessage(), e);
            }
        }
        return b;
    }

    public void getBitmapAsync(TiDownloadListener listener) {
        if (!this.isNetworkUrl()) {
            Log.w(LCAT, "getBitmapAsync called on non-network url.  Will attempt load.");
        }
        try {
            TiDownloadManager.getInstance().download(new URI(this.url), listener);
        }
        catch (URISyntaxException e) {
            Log.e(LCAT, "URI Invalid: " + this.url, e);
        }
    }

    public void getBitmapAsync(TiBackgroundImageLoadTask asyncTask) {
        if (!this.isNetworkUrl()) {
            Log.w(LCAT, "getBitmapAsync called on non-network url.  Will attempt load.");
        }
        asyncTask.load(this.url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bounds peekBounds() {
        int hash = this.hashCode();
        if (boundsCache.containsKey(hash)) {
            return boundsCache.get(hash);
        }
        Bounds bounds = new Bounds();
        if (this.isTypeNull()) {
            return bounds;
        }
        InputStream stream = this.getInputStream();
        try {
            if (stream != null) {
                BitmapFactory.Options bfo = new BitmapFactory.Options();
                bfo.inJustDecodeBounds = true;
                BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)bfo);
                bounds.height = bfo.outHeight;
                bounds.width = bfo.outWidth;
            } else {
                Log.w(LCAT, "Could not open stream for drawable, therefore bounds checking could not be completed");
            }
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                Log.e(LCAT, "problem closing stream: " + e.getMessage(), e);
            }
        }
        boundsCache.put(hash, bounds);
        return bounds;
    }

    public InputStream getInputStream() {
        InputStream stream;
        block16: {
            TiContext context = this.softContext.get();
            if (context == null) {
                Log.w(LCAT, "TiContext has been GC'd, so opening stream may not be possible.");
            }
            stream = null;
            if (this.isTypeUrl() && this.url != null) {
                if (context != null) {
                    try {
                        String resolved = context.resolveUrl(null, this.url);
                        if (resolved.startsWith("file:///android_asset/Resources/") && TiFastDev.isFastDevEnabled()) {
                            TiBaseFile tbf = TiFileFactory.createTitaniumFile(context, new String[]{resolved}, false);
                            stream = tbf.getInputStream();
                            break block16;
                        }
                        stream = this.getTiFileHelper().openInputStream(resolved, false);
                    }
                    catch (IOException e) {
                        Log.e(LCAT, "Problem opening stream with url " + this.url + ": " + e.getMessage(), e);
                    }
                }
            } else if (this.isTypeFile() && this.file != null) {
                try {
                    stream = this.file.getInputStream();
                }
                catch (IOException e) {
                    Log.e(LCAT, "Problem opening stream from file " + this.file.name() + ": " + e.getMessage(), e);
                }
            } else if (this.isTypeBlob() && this.blob != null) {
                stream = this.blob.getInputStream();
            } else if (this.isTypeResourceId() && this.resourceId != -1 && context != null) {
                try {
                    stream = context.getTiApp().getResources().openRawResource(this.resourceId);
                }
                catch (Resources.NotFoundException e) {
                    Log.e(LCAT, "Drawable resource could not be opened. Are you sure you have the resource for the current device configuration (orientation, screen size, etc.)?");
                    throw e;
                }
            }
        }
        return stream;
    }

    public int calcSampleSize(int srcWidth, int srcHeight, int destWidth, int destHeight) {
        if (srcWidth <= 0 || srcHeight <= 0 || destWidth <= 0 || destHeight <= 0) {
            return 1;
        }
        return Math.max(srcWidth / destWidth, srcHeight / destHeight);
    }

    public int calcSampleSize(int destWidth, int destHeight) {
        Bounds bounds = this.peekBounds();
        return this.calcSampleSize(bounds.width, bounds.height, destWidth, destHeight);
    }

    public int calcSampleSize(View parent, int srcWidth, int srcHeight, TiDimension destWidthDimension, TiDimension destHeightDimension) {
        int destWidth;
        if (destWidthDimension == null) {
            destWidth = srcWidth;
            TiContext context = this.softContext.get();
            if (context != null && context.getActivity() != null && context.getActivity().getWindow() != null) {
                destWidth = context.getActivity().getWindow().getDecorView().getWidth();
            }
        } else {
            int n = destWidth = destWidthDimension.isUnitAuto() ? srcWidth : destWidthDimension.getAsPixels(parent);
        }
        int destHeight = destHeightDimension == null ? (int)((float)srcHeight / (float)srcWidth * (float)destWidth) : (destHeightDimension.isUnitAuto() ? srcHeight : destHeightDimension.getAsPixels(parent));
        return this.calcSampleSize(srcWidth, srcHeight, destWidth, destHeight);
    }

    public int calcSampleSize(View parent, TiDimension destWidthDimension, TiDimension destHeightDimension) {
        Bounds bounds = this.peekBounds();
        int srcWidth = bounds.width;
        int srcHeight = bounds.height;
        return this.calcSampleSize(parent, srcWidth, srcHeight, destWidthDimension, destHeightDimension);
    }

    private TiFileHelper getTiFileHelper() {
        TiContext context;
        if (this.fileHelper == null && (context = this.softContext.get()) != null) {
            this.fileHelper = context.getTiFileHelper();
        }
        return this.fileHelper;
    }

    public boolean outOfMemoryOccurred() {
        return this.oomOccurred;
    }

    public String getUrl() {
        return this.url;
    }

    public class Bounds {
        public static final int UNKNOWN = -1;
        private int height = -1;
        private int width = -1;

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }
    }

    public static enum DrawableReferenceType {
        NULL,
        URL,
        RESOURCE_ID,
        BLOB,
        FILE;

    }
}

