/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import java.util.Comparator;
import java.util.TreeSet;
import org.appcelerator.titanium.TiDimension;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.view.Ti2DMatrix;

public class TiCompositeLayout
extends ViewGroup
implements ViewGroup.OnHierarchyChangeListener {
    protected static final String TAG = "TiCompositeLayout";
    protected static final boolean DBG;
    public static final int NOT_SET = Integer.MIN_VALUE;
    private TreeSet<View> viewSorter;
    private boolean needsSort;
    protected LayoutArrangement arrangement;
    private int horizontalLayoutTopBuffer = 0;
    private int horizontalLayoutCurrentLeft = 0;
    private int horizontalLayoutLineHeight = 0;
    private boolean disableHorizontalWrap = false;

    public TiCompositeLayout(Context context) {
        this(context, LayoutArrangement.DEFAULT);
    }

    public TiCompositeLayout(Context context, LayoutArrangement arrangement) {
        super(context);
        this.arrangement = arrangement;
        this.viewSorter = new TreeSet<View>(new Comparator<View>(){

            @Override
            public int compare(View o1, View o2) {
                LayoutParams p1 = (LayoutParams)o1.getLayoutParams();
                LayoutParams p2 = (LayoutParams)o2.getLayoutParams();
                int result = 0;
                if (p1.optionZIndex != Integer.MIN_VALUE && p2.optionZIndex != Integer.MIN_VALUE) {
                    if (p1.optionZIndex < p2.optionZIndex) {
                        result = -1;
                    } else if (p1.optionZIndex > p2.optionZIndex) {
                        result = 1;
                    }
                } else if (p1.optionZIndex != Integer.MIN_VALUE) {
                    if (p1.optionZIndex < 0) {
                        result = -1;
                    }
                    if (p1.optionZIndex > 0) {
                        result = 1;
                    }
                } else if (p2.optionZIndex != Integer.MIN_VALUE) {
                    if (p2.optionZIndex < 0) {
                        result = 1;
                    }
                    if (p2.optionZIndex > 0) {
                        result = -1;
                    }
                }
                if (result == 0) {
                    if (p1.index < p2.index) {
                        result = -1;
                    } else if (p1.index > p2.index) {
                        result = 1;
                    } else {
                        throw new IllegalStateException("Ambiguous Z-Order");
                    }
                }
                return result;
            }
        });
        this.needsSort = true;
        this.setOnHierarchyChangeListener(this);
    }

    public TiCompositeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TiCompositeLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    private String viewToString(View view) {
        return view.getClass().getSimpleName() + "@" + Integer.toHexString(view.hashCode());
    }

    public void onChildViewAdded(View parent, View child) {
        this.needsSort = true;
        if (DBG && parent != null && child != null) {
            Log.d(TAG, "Attaching: " + this.viewToString(child) + " to " + this.viewToString(parent));
        }
    }

    public void onChildViewRemoved(View parent, View child) {
        this.needsSort = true;
        if (DBG) {
            Log.d(TAG, "Removing: " + this.viewToString(child) + " from " + this.viewToString(parent));
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        LayoutParams params = new LayoutParams();
        params.optionLeft = null;
        params.optionRight = null;
        params.optionTop = null;
        params.optionBottom = null;
        params.optionZIndex = Integer.MIN_VALUE;
        params.autoHeight = true;
        params.autoWidth = true;
        return params;
    }

    protected int getViewWidthPadding(View child, int parentWidth) {
        LayoutParams p = (LayoutParams)child.getLayoutParams();
        int padding = 0;
        if (p.optionLeft != null) {
            padding = p.optionLeft.isUnitPercent() ? (padding += (int)(p.optionLeft.getValue() / 100.0 * (double)parentWidth)) : (padding += p.optionLeft.getAsPixels((View)this));
        }
        if (p.optionRight != null) {
            padding = p.optionRight.isUnitPercent() ? (padding += (int)(p.optionRight.getValue() / 100.0 * (double)parentWidth)) : (padding += p.optionRight.getAsPixels((View)this));
        }
        return padding;
    }

    protected int getViewHeightPadding(View child, int parentHeight) {
        LayoutParams p = (LayoutParams)child.getLayoutParams();
        int padding = 0;
        if (p.optionTop != null) {
            padding = p.optionTop.isUnitPercent() ? (padding += (int)(p.optionTop.getValue() / 100.0 * (double)parentHeight)) : (padding += p.optionTop.getAsPixels((View)this));
        }
        if (p.optionBottom != null) {
            padding = p.optionBottom.isUnitPercent() ? (padding += (int)(p.optionBottom.getValue() / 100.0 * (double)parentHeight)) : (padding += p.optionBottom.getAsPixels((View)this));
        }
        return padding;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childCount = this.getChildCount();
        int wFromSpec = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int hFromSpec = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int wSuggested = this.getSuggestedMinimumWidth();
        int hSuggested = this.getSuggestedMinimumHeight();
        int w = Math.max(wFromSpec, wSuggested);
        int wMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int h = Math.max(hFromSpec, hSuggested);
        int hMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i = 0; i < childCount; ++i) {
            LayoutParams p;
            View child = this.getChildAt(i);
            if (child.getVisibility() != 8) {
                this.constrainChild(child, w, wMode, h, hMode);
            }
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            if (child.getVisibility() != 8) {
                childWidth += this.getViewWidthPadding(child, w);
                childHeight += this.getViewHeightPadding(child, h);
            }
            if (this.isHorizontalArrangement()) {
                p = (LayoutParams)child.getLayoutParams();
                maxWidth += childWidth;
                if (p.optionLeft != null) {
                    maxWidth += p.optionLeft.getAsPixels((View)this);
                }
            } else {
                maxWidth = Math.max(maxWidth, childWidth);
            }
            if (this.isVerticalArrangement()) {
                p = (LayoutParams)child.getLayoutParams();
                maxHeight += childHeight;
                if (p.optionTop == null) continue;
                maxHeight += p.optionTop.getAsPixels((View)this);
                continue;
            }
            maxHeight = Math.max(maxHeight, childHeight);
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        int measuredWidth = this.getMeasuredWidth(maxWidth, widthMeasureSpec);
        int measuredHeight = this.getMeasuredHeight(maxHeight, heightMeasureSpec);
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    protected void constrainChild(View child, int width, int wMode, int height, int hMode) {
        LayoutParams p = (LayoutParams)child.getLayoutParams();
        int childDimension = -2;
        if (p.optionWidth != null) {
            childDimension = p.optionWidth.isUnitPercent() && width > 0 ? (int)(p.optionWidth.getValue() / 100.0 * (double)width) : p.optionWidth.getAsPixels((View)this);
        } else if (p.autoWidth && p.autoFillsWidth && !this.isHorizontalArrangement()) {
            childDimension = -1;
        }
        int widthPadding = this.getViewWidthPadding(child, width);
        int widthSpec = ViewGroup.getChildMeasureSpec((int)View.MeasureSpec.makeMeasureSpec((int)width, (int)wMode), (int)widthPadding, (int)childDimension);
        childDimension = -2;
        if (p.optionHeight != null) {
            childDimension = p.optionHeight.isUnitPercent() && height > 0 ? (int)(p.optionHeight.getValue() / 100.0 * (double)height) : p.optionHeight.getAsPixels((View)this);
        } else if (p.autoHeight && p.autoFillsHeight && !this.isVerticalArrangement()) {
            childDimension = -1;
        }
        int heightPadding = this.getViewHeightPadding(child, height);
        int heightSpec = ViewGroup.getChildMeasureSpec((int)View.MeasureSpec.makeMeasureSpec((int)height, (int)hMode), (int)heightPadding, (int)childDimension);
        child.measure(widthSpec, heightSpec);
    }

    protected int getMeasuredWidth(int maxWidth, int widthSpec) {
        return TiCompositeLayout.resolveSize((int)maxWidth, (int)widthSpec);
    }

    protected int getMeasuredHeight(int maxHeight, int heightSpec) {
        return TiCompositeLayout.resolveSize((int)maxHeight, (int)heightSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        int left = 0;
        int top = 0;
        int right = r - l;
        int bottom = b - t;
        if (this.needsSort) {
            if (count > 1) {
                this.viewSorter.clear();
                int i = 0;
                while (i < count) {
                    View child = this.getChildAt(i);
                    LayoutParams params = (LayoutParams)child.getLayoutParams();
                    params.index = i++;
                    this.viewSorter.add(child);
                }
                this.detachAllViewsFromParent();
                i = 0;
                for (View child : this.viewSorter) {
                    this.attachViewToParent(child, i++, child.getLayoutParams());
                }
            }
            this.needsSort = false;
        }
        int[] horizontal = new int[2];
        int[] vertical = new int[2];
        int currentHeight = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            LayoutParams params = (LayoutParams)child.getLayoutParams();
            if (child.getVisibility() == 8) continue;
            int childMeasuredWidth = child.getMeasuredWidth();
            int childMeasuredHeight = child.getMeasuredHeight();
            if (this.isHorizontalArrangement()) {
                if (i == 0) {
                    this.horizontalLayoutCurrentLeft = left;
                    this.horizontalLayoutLineHeight = 0;
                    this.horizontalLayoutTopBuffer = 0;
                }
                this.computeHorizontalLayoutPosition(params, childMeasuredWidth, childMeasuredHeight, right, top, bottom, horizontal, vertical);
            } else {
                TiCompositeLayout.computePosition((View)this, params.optionLeft, params.optionCenterX, params.optionRight, childMeasuredWidth, left, right, horizontal);
                if (this.isVerticalArrangement()) {
                    this.computeVerticalLayoutPosition(currentHeight, params.optionTop, params.optionBottom, childMeasuredHeight, top, bottom, vertical);
                } else {
                    TiCompositeLayout.computePosition((View)this, params.optionTop, params.optionCenterY, params.optionBottom, childMeasuredHeight, top, bottom, vertical);
                }
            }
            if (DBG) {
                Log.d(TAG, child.getClass().getName() + " {" + horizontal[0] + "," + vertical[0] + "," + horizontal[1] + "," + vertical[1] + "}");
            }
            int newWidth = horizontal[1] - horizontal[0];
            int newHeight = vertical[1] - vertical[0];
            if (newWidth != childMeasuredWidth || newHeight != childMeasuredHeight) {
                int newWidthSpec = View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000);
                int newHeightSpec = View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000);
                child.measure(newWidthSpec, newHeightSpec);
            }
            child.layout(horizontal[0], vertical[0], horizontal[1], vertical[1]);
            currentHeight += newHeight;
            if (params.optionTop == null) continue;
            currentHeight += params.optionTop.getAsPixels((View)this);
        }
    }

    public static void computePosition(View parent, TiDimension option0, TiDimension optionCenter, TiDimension option1, int measuredSize, int layoutPosition0, int layoutPosition1, int[] pos) {
        int dist = layoutPosition1 - layoutPosition0;
        if (optionCenter != null) {
            int halfSize = measuredSize / 2;
            pos[0] = layoutPosition0 + optionCenter.getAsPixels(parent) - halfSize;
            pos[1] = pos[0] + measuredSize;
        } else if (option0 == null && option1 == null) {
            int offset = (dist - measuredSize) / 2;
            pos[0] = layoutPosition0 + offset;
            pos[1] = pos[0] + measuredSize;
        } else if (option0 == null) {
            int option1Pixels = option1.getAsPixels(parent);
            pos[0] = dist - option1Pixels - measuredSize;
            pos[1] = dist - option1Pixels;
        } else if (option1 == null) {
            int option0Pixels = option0.getAsPixels(parent);
            pos[0] = layoutPosition0 + option0Pixels;
            pos[1] = layoutPosition0 + option0Pixels + measuredSize;
        } else {
            pos[0] = layoutPosition0 + option0.getAsPixels(parent);
            pos[1] = layoutPosition1 - option1.getAsPixels(parent);
        }
    }

    private void computeVerticalLayoutPosition(int currentHeight, TiDimension optionTop, TiDimension optionBottom, int measuredHeight, int layoutTop, int layoutBottom, int[] pos) {
        int top = layoutTop + currentHeight;
        if (optionTop != null) {
            top += optionTop.getAsPixels((View)this);
        }
        int bottom = top + measuredHeight;
        pos[0] = top;
        pos[1] = bottom;
    }

    private void computeHorizontalLayoutPosition(LayoutParams params, int measuredWidth, int measuredHeight, int layoutRight, int layoutTop, int layoutBottom, int[] hpos, int[] vpos) {
        int right;
        TiDimension optionLeft = params.optionLeft;
        int left = this.horizontalLayoutCurrentLeft;
        if (optionLeft != null) {
            left += optionLeft.getAsPixels((View)this);
        }
        if ((right = left + measuredWidth) > layoutRight && !this.disableHorizontalWrap) {
            left = 0;
            right = measuredWidth;
            this.horizontalLayoutTopBuffer += this.horizontalLayoutLineHeight;
            this.horizontalLayoutLineHeight = 0;
        }
        hpos[0] = left;
        hpos[1] = right;
        this.horizontalLayoutCurrentLeft = right;
        TiCompositeLayout.computePosition((View)this, params.optionTop, params.optionCenterY, params.optionBottom, measuredHeight, layoutTop, layoutBottom, vpos);
        this.horizontalLayoutLineHeight = Math.max(this.horizontalLayoutLineHeight, vpos[1] - vpos[0]);
        vpos[0] = vpos[0] + this.horizontalLayoutTopBuffer;
        vpos[1] = vpos[1] + this.horizontalLayoutTopBuffer;
    }

    protected int getWidthMeasureSpec(View child) {
        return 0x40000000;
    }

    protected int getHeightMeasureSpec(View child) {
        return 0x40000000;
    }

    protected boolean isVerticalArrangement() {
        return this.arrangement == LayoutArrangement.VERTICAL;
    }

    protected boolean isHorizontalArrangement() {
        return this.arrangement == LayoutArrangement.HORIZONTAL;
    }

    protected boolean isDefaultArrangement() {
        return this.arrangement == LayoutArrangement.DEFAULT;
    }

    public void setLayoutArrangement(String arrangementProperty) {
        this.arrangement = arrangementProperty != null && arrangementProperty.equals("horizontal") ? LayoutArrangement.HORIZONTAL : (arrangementProperty != null && arrangementProperty.equals("vertical") ? LayoutArrangement.VERTICAL : LayoutArrangement.DEFAULT);
    }

    public void setDisableHorizontalWrap(boolean disable) {
        this.disableHorizontalWrap = disable;
    }

    static {
        if (TiConfig.LOGD) {
            // empty if block
        }
        DBG = false;
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        protected int index;
        public int optionZIndex = Integer.MIN_VALUE;
        public TiDimension optionLeft = null;
        public TiDimension optionTop = null;
        public TiDimension optionCenterX = null;
        public TiDimension optionCenterY = null;
        public TiDimension optionRight = null;
        public TiDimension optionBottom = null;
        public TiDimension optionWidth = null;
        public TiDimension optionHeight = null;
        public Ti2DMatrix optionTransform = null;
        public boolean autoHeight = true;
        public boolean autoWidth = true;
        public boolean autoFillsWidth = false;
        public boolean autoFillsHeight = false;

        public LayoutParams() {
            super(-2, -2);
            this.index = Integer.MIN_VALUE;
        }
    }

    public static enum LayoutArrangement {
        DEFAULT,
        VERTICAL,
        HORIZONTAL;

    }
}

