/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.view;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PaintDrawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import java.io.IOException;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TiBackgroundDrawable
extends StateListDrawable {
    private Drawable background = new ColorDrawable(0);
    private Border border = null;
    private RectF outerRect = new RectF();
    private RectF innerRect = new RectF();
    private static final int NOT_SET = -1;
    private int alpha = -1;

    public void draw(Canvas canvas) {
        Paint paint = new Paint(1);
        if (this.border != null) {
            paint.setColor(this.border.color);
            if (this.border.radius > 0.0f) {
                canvas.drawRoundRect(this.outerRect, this.border.radius, this.border.radius, paint);
            } else {
                canvas.drawRect(this.outerRect, paint);
            }
        }
        if (this.background != null) {
            this.background.setBounds((int)this.innerRect.left, (int)this.innerRect.top, (int)this.innerRect.right, (int)this.innerRect.bottom);
        }
        canvas.save();
        if (this.border != null && this.border.radius > 0.0f) {
            Path path = new Path();
            float[] radii = new float[8];
            Arrays.fill(radii, this.border.radius);
            path.addRoundRect(this.innerRect, radii, Path.Direction.CW);
            path.setFillType(Path.FillType.EVEN_ODD);
            canvas.clipPath(path);
        } else {
            canvas.clipRect(this.innerRect);
        }
        if (this.background != null) {
            if (this.alpha > -1) {
                this.background.setAlpha(this.alpha);
            }
            this.background.draw(canvas);
        }
        canvas.restore();
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.outerRect.set(bounds);
        int padding = 0;
        if (this.border != null) {
            padding = (int)this.border.width;
        }
        this.innerRect.set((float)(bounds.left + padding), (float)(bounds.top + padding), (float)(bounds.right - padding), (float)(bounds.bottom - padding));
        if (this.background != null) {
            this.background.setBounds((int)this.innerRect.left, (int)this.innerRect.top, (int)this.innerRect.right, (int)this.innerRect.bottom);
        }
    }

    protected boolean onStateChange(int[] stateSet) {
        boolean changed = super.onStateChange(stateSet);
        changed = this.setState(stateSet);
        boolean drawableChanged = false;
        if (this.background != null && (drawableChanged = this.background.setState(stateSet))) {
            this.invalidateSelf();
        }
        return changed || drawableChanged;
    }

    public void addState(int[] stateSet, Drawable drawable) {
        if (this.background instanceof StateListDrawable) {
            ((StateListDrawable)this.background).addState(stateSet, drawable);
        }
    }

    protected boolean onLevelChange(int level) {
        boolean changed = super.onLevelChange(level);
        boolean backgroundChanged = false;
        if (this.background instanceof StateListDrawable) {
            backgroundChanged = ((StateListDrawable)this.background).setLevel(level);
        }
        return changed || backgroundChanged;
    }

    public void invalidateSelf() {
        super.invalidateSelf();
        if (this.background instanceof StateListDrawable) {
            ((StateListDrawable)this.background).invalidateSelf();
        }
    }

    public void invalidateDrawable(Drawable who) {
        super.invalidateDrawable(who);
        if (this.background instanceof StateListDrawable) {
            ((StateListDrawable)this.background).invalidateDrawable(who);
        }
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs);
        if (this.background != null) {
            this.background.inflate(r, parser, attrs);
        }
    }

    public void releaseDelegate() {
        if (this.background != null) {
            if (this.background instanceof BitmapDrawable) {
                ((BitmapDrawable)this.background).getBitmap().recycle();
            }
            this.background.setCallback(null);
            this.background = null;
        }
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.releaseDelegate();
        this.background = new PaintDrawable(backgroundColor);
    }

    public void setBackgroundImage(Bitmap backgroundImage) {
        this.releaseDelegate();
        this.background = new BitmapDrawable(backgroundImage);
    }

    public void setBackgroundDrawable(Drawable drawable) {
        this.releaseDelegate();
        this.background = drawable;
        this.onStateChange(this.getState());
    }

    public void setAlpha(int alpha) {
        super.setAlpha(alpha);
        this.alpha = alpha;
    }

    public static class Border {
        public static final int SOLID = 0;
        private int color = 0;
        private float radius = 0.0f;
        private float width = 0.0f;
        private int style = 0;

        public int getColor() {
            return this.color;
        }

        public void setColor(int color) {
            this.color = color;
        }

        public float getRadius() {
            return this.radius;
        }

        public void setRadius(float radius) {
            this.radius = radius;
        }

        public float getWidth() {
            return this.width;
        }

        public void setWidth(float width) {
            this.width = width;
        }

        public int getStyle() {
            return this.style;
        }

        public void setStyle(int style) {
            this.style = style;
        }
    }
}

