/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.view;

import android.graphics.Matrix;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.TiConvert;

public class Ti2DMatrix
extends KrollProxy {
    public static final float DEFAULT_ANCHOR_VALUE = -1.0f;
    protected Ti2DMatrix next;
    protected Ti2DMatrix prev;
    protected Operation op;

    public Ti2DMatrix(TiContext tiContext) {
        super(tiContext);
    }

    protected Ti2DMatrix(TiContext tiContext, Ti2DMatrix prev, int opType) {
        super(tiContext);
        if (prev != null) {
            this.prev = prev;
            prev.next = this;
        }
        this.op = new Operation(opType);
    }

    @Override
    public void handleCreationDict(KrollDict dict) {
        super.handleCreationDict(dict);
        if (dict.containsKey("rotate")) {
            this.op = new Operation(2);
            this.op.rotateFrom = 0.0f;
            this.op.rotateTo = TiConvert.toFloat(dict, "rotate");
            this.handleAnchorPoint(dict);
        }
        if (dict.containsKey("scale")) {
            this.op = new Operation(0);
            this.op.scaleFromY = 1.0f;
            this.op.scaleFromX = 1.0f;
            this.op.scaleToX = this.op.scaleToY = TiConvert.toFloat(dict, "scale");
            this.handleAnchorPoint(dict);
        }
    }

    protected void handleAnchorPoint(KrollDict dict) {
        KrollDict anchorPoint;
        if (dict.containsKey("anchorPoint") && (anchorPoint = dict.getKrollDict("anchorPoint")) != null) {
            this.op.anchorX = TiConvert.toFloat(anchorPoint, "x");
            this.op.anchorY = TiConvert.toFloat(anchorPoint, "y");
        }
    }

    public Ti2DMatrix translate(KrollInvocation invocation, double x, double y) {
        Ti2DMatrix newMatrix = new Ti2DMatrix(invocation.getTiContext(), this, 1);
        newMatrix.op.translateX = (float)x;
        newMatrix.op.translateY = (float)y;
        return newMatrix;
    }

    public Ti2DMatrix scale(KrollInvocation invocation, Object[] args) {
        Ti2DMatrix newMatrix = new Ti2DMatrix(invocation.getTiContext(), this, 0);
        newMatrix.op.scaleFromY = 1.0f;
        newMatrix.op.scaleFromX = 1.0f;
        newMatrix.op.scaleToY = 1.0f;
        newMatrix.op.scaleToX = 1.0f;
        if (args.length == 4) {
            newMatrix.op.scaleFromX = TiConvert.toFloat(args[0]);
            newMatrix.op.scaleFromY = TiConvert.toFloat(args[1]);
            newMatrix.op.scaleToX = TiConvert.toFloat(args[2]);
            newMatrix.op.scaleToY = TiConvert.toFloat(args[3]);
        }
        if (args.length == 2) {
            newMatrix.op.scaleToX = TiConvert.toFloat(args[0]);
            newMatrix.op.scaleToY = TiConvert.toFloat(args[1]);
        } else if (args.length == 1) {
            newMatrix.op.scaleToX = newMatrix.op.scaleToY = TiConvert.toFloat(args[0]);
        }
        newMatrix.handleAnchorPoint(newMatrix.getProperties());
        return newMatrix;
    }

    public Ti2DMatrix rotate(KrollInvocation invocation, Object[] args) {
        Ti2DMatrix newMatrix = new Ti2DMatrix(invocation.getTiContext(), this, 2);
        if (args.length == 1) {
            newMatrix.op.rotateFrom = 0.0f;
            newMatrix.op.rotateTo = TiConvert.toFloat(args[0]);
        } else if (args.length == 2) {
            newMatrix.op.rotateFrom = TiConvert.toFloat(args[0]);
            newMatrix.op.rotateTo = TiConvert.toFloat(args[1]);
        }
        newMatrix.handleAnchorPoint(newMatrix.getProperties());
        return newMatrix;
    }

    public Ti2DMatrix invert(KrollInvocation invocation) {
        return new Ti2DMatrix(invocation.getTiContext(), this, 4);
    }

    public Ti2DMatrix multiply(KrollInvocation invocation, Ti2DMatrix other) {
        return new Ti2DMatrix(invocation.getTiContext(), this, 3);
    }

    public Matrix interpolate(float interpolatedTime, int childWidth, int childHeight, float anchorX, float anchorY) {
        Ti2DMatrix first = this;
        while (first.prev != null) {
            first = first.prev;
        }
        Matrix matrix = new Matrix();
        Ti2DMatrix current = first;
        while (current != this) {
            if (current.op != null) {
                current.op.apply(interpolatedTime, matrix, childWidth, childHeight, anchorX, anchorY);
            }
            current = current.next;
        }
        if (this.op != null) {
            this.op.apply(interpolatedTime, matrix, childWidth, childHeight, anchorX, anchorY);
        }
        return matrix;
    }

    protected static class Operation {
        protected static final int TYPE_SCALE = 0;
        protected static final int TYPE_TRANSLATE = 1;
        protected static final int TYPE_ROTATE = 2;
        protected static final int TYPE_MULTIPLY = 3;
        protected static final int TYPE_INVERT = 4;
        protected float scaleFromX;
        protected float scaleFromY;
        protected float scaleToX;
        protected float scaleToY;
        protected float translateX;
        protected float translateY;
        protected float rotateFrom;
        protected float rotateTo;
        protected float anchorX = 0.5f;
        protected float anchorY = 0.5f;
        protected Ti2DMatrix multiplyWith;
        protected int type;

        public Operation(int type) {
            this.type = type;
        }

        public void apply(float interpolatedTime, Matrix matrix, int childWidth, int childHeight, float anchorX, float anchorY) {
            anchorX = anchorX == -1.0f ? this.anchorX : anchorX;
            anchorY = anchorY == -1.0f ? this.anchorY : anchorY;
            switch (this.type) {
                case 0: {
                    matrix.preScale(interpolatedTime * (this.scaleToX - this.scaleFromX) + this.scaleFromX, interpolatedTime * (this.scaleToX - this.scaleFromY) + this.scaleFromY);
                    break;
                }
                case 1: {
                    matrix.preTranslate(interpolatedTime * this.translateX, interpolatedTime * this.translateY);
                    break;
                }
                case 2: {
                    matrix.preRotate(interpolatedTime * (this.rotateTo - this.rotateFrom) + this.rotateFrom, anchorX * (float)childWidth, anchorY * (float)childHeight);
                    break;
                }
                case 3: {
                    matrix.preConcat(this.multiplyWith.interpolate(interpolatedTime, childWidth, childHeight, anchorX, anchorY));
                    break;
                }
                case 4: {
                    matrix.invert(matrix);
                }
            }
        }
    }
}

