/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class TiWeakList<T>
extends ArrayList<WeakReference<T>> {
    protected List<WeakReference<T>> synchronizedList;

    public TiWeakList() {
        this(false);
    }

    public TiWeakList(boolean isSynchronized) {
        if (isSynchronized) {
            this.synchronizedList();
        }
    }

    public List<WeakReference<T>> synchronizedList() {
        if (this.synchronizedList == null) {
            this.synchronizedList = Collections.synchronizedList(this);
        }
        return this.synchronizedList;
    }

    public boolean refEquals(WeakReference<T> ref, Object o) {
        if (ref == null) {
            return false;
        }
        if (ref.get() == o) {
            return true;
        }
        return ref.get() != null && ref.get().equals(o);
    }

    protected boolean findRef(Object o) {
        for (WeakReference ref : this) {
            if (!this.refEquals(ref, o)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        if (o instanceof WeakReference) {
            return super.contains(o);
        }
        if (this.synchronizedList != null) {
            List<WeakReference<T>> list = this.synchronizedList;
            synchronized (list) {
                return this.findRef(o);
            }
        }
        return this.findRef(o);
    }

    protected boolean removeRef(Object o) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            WeakReference ref = (WeakReference)iter.next();
            if (!this.refEquals(ref, o)) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        if (o instanceof WeakReference) {
            return super.remove(o);
        }
        if (this.synchronizedList != null) {
            List<WeakReference<T>> list = this.synchronizedList;
            synchronized (list) {
                return this.removeRef(o);
            }
        }
        return this.removeRef(o);
    }

    public Iterator<T> nonNullIterator() {
        return new NonNullIterator(0);
    }

    public Iterable<T> nonNull() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return TiWeakList.this.nonNullIterator();
            }
        };
    }

    protected class NonNullIterator
    implements Iterator<T> {
        protected int index;

        public NonNullIterator(int index) {
            this.index = index;
        }

        protected int getNextIndex() {
            int size = TiWeakList.this.size();
            for (int i = this.index; i < size; ++i) {
                WeakReference ref = (WeakReference)TiWeakList.this.get(i);
                if (ref == null || ref.get() == null) continue;
                return i;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (TiWeakList.this.synchronizedList != null) {
                List list = TiWeakList.this.synchronizedList;
                synchronized (list) {
                    return this.getNextIndex() >= 0;
                }
            }
            return this.getNextIndex() >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            if (TiWeakList.this.synchronizedList != null) {
                List list = TiWeakList.this.synchronizedList;
                synchronized (list) {
                    int nextIndex = this.getNextIndex();
                    if (nextIndex < 0) {
                        throw new NoSuchElementException();
                    }
                    this.index = nextIndex + 1;
                    return ((WeakReference)TiWeakList.this.get(nextIndex)).get();
                }
            }
            int nextIndex = this.getNextIndex();
            if (nextIndex < 0) {
                throw new NoSuchElementException();
            }
            this.index = nextIndex + 1;
            return ((WeakReference)TiWeakList.this.get(nextIndex)).get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (TiWeakList.this.synchronizedList != null) {
                List list = TiWeakList.this.synchronizedList;
                synchronized (list) {
                    TiWeakList.this.remove(this.index);
                }
            } else {
                TiWeakList.this.remove(this.index);
            }
        }
    }
}

