/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.net.Uri;
import java.net.URI;
import java.net.URISyntaxException;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.io.TiFileFactory;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiFileHelper2;

public class TiUrl {
    protected static final String TAG = "TiUrl";
    protected static final boolean DBG = TiConfig.LOGD;
    public static final String PATH_SEPARATOR = "/";
    public static final String SCHEME_SUFFIX = "://";
    public static final String PARENT_PATH = "..";
    public static final String CURRENT_PATH = ".";
    public static final String PARENT_PATH_WITH_SEPARATOR = "../";
    public static final String CURRENT_PATH_WITH_SEPARATOR = "./";
    public String baseUrl;
    public String url;

    public TiUrl(String url) {
        this("app://", url);
    }

    public TiUrl(String baseUrl, String url) {
        this.baseUrl = baseUrl;
        this.url = url;
    }

    protected static String parseRelativeBaseUrl(String path, String baseUrl, boolean checkAppPrefix) {
        int i;
        String[] right = path.split(PATH_SEPARATOR);
        String[] left = null;
        if (baseUrl.contains(SCHEME_SUFFIX)) {
            if (checkAppPrefix) {
                if (baseUrl.equals("app://")) {
                    left = new String[]{};
                } else {
                    int idx = baseUrl.indexOf(SCHEME_SUFFIX);
                    left = baseUrl.substring(idx + 3).split(PATH_SEPARATOR);
                }
            } else {
                String[] tmp = baseUrl.split(SCHEME_SUFFIX);
                left = tmp.length > 1 ? tmp[1].split(PATH_SEPARATOR) : new String[]{};
            }
        } else {
            left = baseUrl.split(PATH_SEPARATOR);
        }
        int rIndex = 0;
        int lIndex = left.length;
        while (right[rIndex].equals(PARENT_PATH)) {
            --lIndex;
            if (++rIndex <= right.length - 1) continue;
        }
        String sep = "";
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < lIndex; ++i) {
            sb.append(sep).append(left[i]);
            sep = PATH_SEPARATOR;
        }
        for (i = rIndex; i < right.length; ++i) {
            sb.append(sep).append(right[i]);
            sep = PATH_SEPARATOR;
        }
        String bUrl = sb.toString();
        if (!bUrl.endsWith(PATH_SEPARATOR)) {
            bUrl = bUrl + PATH_SEPARATOR;
        }
        return bUrl;
    }

    public static TiUrl normalizeWindowUrl(String url) {
        int lastSlash = url.lastIndexOf(PATH_SEPARATOR);
        String baseUrl = url.substring(0, lastSlash + 1);
        if (baseUrl.length() == 0) {
            baseUrl = "app://";
        }
        return TiUrl.normalizeWindowUrl(baseUrl, url);
    }

    public static TiUrl normalizeWindowUrl(String baseUrl, String url) {
        block15: {
            if (DBG) {
                Log.d(TAG, "Window Base URL: " + baseUrl);
                if (url != null) {
                    Log.d(TAG, "Window Relative URL: " + url);
                }
            }
            try {
                URI uri = new URI(url);
                String scheme = uri.getScheme();
                if (scheme == null) {
                    int lastIndex;
                    String path = uri.getPath();
                    String fname = null;
                    if (path != null && path.startsWith(CURRENT_PATH_WITH_SEPARATOR)) {
                        path = path.length() == 2 ? "" : path.substring(2);
                    }
                    if ((lastIndex = path.lastIndexOf(PATH_SEPARATOR)) > 0) {
                        fname = path.substring(lastIndex + 1);
                        path = path.substring(0, lastIndex);
                    } else {
                        fname = path;
                        path = null;
                    }
                    if (url.startsWith(PATH_SEPARATOR)) {
                        baseUrl = path == null ? "app://" : "app:/" + path;
                        url = TiFileHelper2.joinSegments(baseUrl, fname);
                    } else if (path == null && fname != null) {
                        url = TiFileHelper2.joinSegments(baseUrl, fname);
                    } else if (path.startsWith(PARENT_PATH_WITH_SEPARATOR)) {
                        baseUrl = TiUrl.parseRelativeBaseUrl(path, baseUrl, true);
                        baseUrl = "app://" + baseUrl;
                        url = TiFileHelper2.joinSegments(baseUrl, fname);
                    } else {
                        baseUrl = "app://" + path;
                        url = TiFileHelper2.joinSegments(baseUrl, fname);
                    }
                    break block15;
                }
                if ("app".equals(scheme)) {
                    baseUrl = url;
                    break block15;
                }
                throw new IllegalArgumentException("Scheme not implemented for " + url);
            }
            catch (URISyntaxException e) {
                Log.w(TAG, "Error parsing url: " + e.getMessage(), e);
            }
        }
        return new TiUrl(baseUrl, url);
    }

    public String resolve(TiContext context) {
        return this.resolve(context, this.baseUrl, this.url, null);
    }

    public String resolve(TiContext context, String path) {
        return this.resolve(context, this.baseUrl, path, null);
    }

    public String resolve(TiContext context, String baseUrl, String path) {
        return this.resolve(context, baseUrl, path, null);
    }

    public String resolve(TiContext context, String baseUrl, String path, String scheme) {
        Uri uri;
        if (!TiFileFactory.isLocalScheme(path)) {
            return path;
        }
        String result = null;
        if (scheme == null) {
            scheme = "app:";
        }
        if (path.startsWith(CURRENT_PATH_WITH_SEPARATOR)) {
            path = path.length() == 2 ? "" : path.substring(2);
        }
        if (path.contains(PARENT_PATH_WITH_SEPARATOR) || path.contains(CURRENT_PATH_WITH_SEPARATOR)) {
            path = this.absoluteUrl(scheme, path, baseUrl);
        }
        result = (uri = Uri.parse((String)path)).getScheme() == null ? (!path.startsWith(PATH_SEPARATOR) ? baseUrl + path : scheme + PATH_SEPARATOR + path) : path;
        if (!result.startsWith("file:")) {
            String[] p = new String[]{result};
            TiBaseFile tbf = TiFileFactory.createTitaniumFile(context, p, false);
            result = tbf.nativePath();
        }
        return result;
    }

    public String absoluteUrl(String defaultScheme, String url, String baseUrl) {
        try {
            URI uri;
            if (!(baseUrl != null && baseUrl.length() != 0 || url != null && url.length() != 0)) {
                return defaultScheme == null ? "" : defaultScheme + "//";
            }
            String combined = "";
            combined = baseUrl == null || baseUrl.length() == 0 ? url : (url == null || url.length() == 0 ? baseUrl : ((uri = new URI(url)).getScheme() != null ? url : (baseUrl.endsWith(PATH_SEPARATOR) && url.startsWith(PATH_SEPARATOR) && !baseUrl.equals("file://") ? (baseUrl.length() == 1 && url.length() == 1 ? PATH_SEPARATOR : (baseUrl.length() == 1 ? url : (url.length() == 1 ? baseUrl : baseUrl + url.substring(1)))) : (!baseUrl.endsWith(PATH_SEPARATOR) && !url.startsWith(PATH_SEPARATOR) ? baseUrl + PATH_SEPARATOR + url : baseUrl + url))));
            uri = new URI(combined);
            if (uri.getScheme() == null) {
                uri = uri.normalize();
            } else {
                String scheme = uri.getScheme() + SCHEME_SUFFIX;
                combined = combined.replace(scheme, "");
                uri = new URI(combined).normalize();
                uri = new URI(scheme + uri.toString());
            }
            if (uri.getScheme() == null) {
                return defaultScheme != null ? defaultScheme + "//" + uri.toString() : uri.toString();
            }
            return uri.toString();
        }
        catch (URISyntaxException e) {
            Log.w(TAG, "Error parsing url: " + e.getMessage(), e);
            return url;
        }
    }
}

