/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiDimension;
import org.appcelerator.titanium.TiFastDev;
import org.appcelerator.titanium.TiMessageQueue;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.io.TiFileFactory;
import org.appcelerator.titanium.proxy.TiWindowProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiFileHelper;
import org.appcelerator.titanium.util.TiPlatformHelper;
import org.appcelerator.titanium.util.TiRHelper;
import org.appcelerator.titanium.view.TiBackgroundDrawable;

public class TiUIHelper {
    private static final String LCAT = "TiUIHelper";
    private static final boolean DBG = TiConfig.LOGD;
    private static final String customFontPath = "Resources/fonts";
    public static final int PORTRAIT = 1;
    public static final int UPSIDE_PORTRAIT = 2;
    public static final int LANDSCAPE_LEFT = 3;
    public static final int LANDSCAPE_RIGHT = 4;
    public static final int FACE_UP = 5;
    public static final int FACE_DOWN = 6;
    public static final int UNKNOWN = 7;
    public static final Pattern SIZED_VALUE = Pattern.compile("([0-9]*\\.?[0-9]+)\\W*(px|dp|dip|sp|sip|mm|pt|in)?");
    private static Method overridePendingTransition;
    private static Map<String, String> resourceImageKeys;
    private static Map<String, Typeface> mCustomTypeFaces;

    public static DialogInterface.OnClickListener createDoNothingListener() {
        return new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        };
    }

    public static DialogInterface.OnClickListener createKillListener() {
        return new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Process.killProcess((int)Process.myPid());
            }
        };
    }

    public static DialogInterface.OnClickListener createFinishListener(final Activity me) {
        return new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                me.finish();
            }
        };
    }

    public static void doKillOrContinueDialog(Context context, String title, String message, DialogInterface.OnClickListener positiveListener, DialogInterface.OnClickListener negativeListener) {
        if (positiveListener == null) {
            positiveListener = TiUIHelper.createDoNothingListener();
        }
        if (negativeListener == null) {
            negativeListener = TiUIHelper.createKillListener();
        }
        new AlertDialog.Builder(context).setTitle((CharSequence)title).setMessage((CharSequence)message).setPositiveButton((CharSequence)"Continue", positiveListener).setNegativeButton((CharSequence)"Kill", negativeListener).setCancelable(false).create().show();
    }

    public static void waitForCurrentActivity(final CurrentActivityListener l) {
        TiWindowProxy waitingForOpen = TiWindowProxy.getWaitingForOpen();
        if (waitingForOpen != null) {
            waitingForOpen.setPostOpenListener(new TiWindowProxy.PostOpenListener(){

                @Override
                public void onPostOpen(TiWindowProxy window) {
                    TiApplication app = TiApplication.getInstance();
                    Activity activity = app.getCurrentActivity();
                    if (activity != null) {
                        l.onCurrentActivityReady(activity);
                    }
                }
            });
        } else {
            TiApplication app = TiApplication.getInstance();
            Activity activity = app.getCurrentActivity();
            if (activity != null) {
                l.onCurrentActivityReady(activity);
            }
        }
    }

    public static void doOkDialog(final String title, final String message, DialogInterface.OnClickListener listener) {
        if (listener == null) {
            listener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            };
        }
        final DialogInterface.OnClickListener fListener = listener;
        TiUIHelper.waitForCurrentActivity(new CurrentActivityListener(){

            @Override
            public void onCurrentActivityReady(Activity activity) {
                new AlertDialog.Builder((Context)activity).setTitle((CharSequence)title).setMessage((CharSequence)message).setPositiveButton(17039370, fListener).setCancelable(false).create().show();
            }
        });
    }

    public static int toTypefaceStyle(String fontWeight) {
        int style = 0;
        if (fontWeight != null && fontWeight.equals("bold")) {
            style = 1;
        }
        return style;
    }

    public static int getSizeUnits(String size) {
        Matcher m;
        int units = 0;
        if (size != null && (m = SIZED_VALUE.matcher(size.trim())).matches() && m.groupCount() == 2) {
            String unit = m.group(2);
            if ("px".equals(unit)) {
                units = 0;
            } else if ("pt".equals(unit)) {
                units = 3;
            } else if ("dp".equals(unit) || "dip".equals(unit)) {
                units = 1;
            } else if ("sp".equals(unit) || "sip".equals(unit)) {
                units = 2;
            } else if ("pt".equals(unit)) {
                units = 3;
            } else if ("mm".equals(unit)) {
                units = 5;
            } else if ("in".equals(unit)) {
                units = 4;
            } else if (DBG && unit != null) {
                Log.w(LCAT, "Unknown unit: " + unit);
            }
        }
        return units;
    }

    public static float getSize(String size) {
        Matcher m;
        float value = 15.0f;
        if (size != null && (m = SIZED_VALUE.matcher(size.trim())).matches()) {
            value = Float.parseFloat(m.group(1));
        }
        return value;
    }

    public static float getRawSize(int unit, float size, Context context) {
        Resources r = context != null ? context.getResources() : Resources.getSystem();
        return TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)r.getDisplayMetrics());
    }

    public static float getRawDIPSize(float size, Context context) {
        return TiUIHelper.getRawSize(1, size, context);
    }

    public static float getRawSize(String size, Context context) {
        return TiUIHelper.getRawSize(TiUIHelper.getSizeUnits(size), TiUIHelper.getSize(size), context);
    }

    public static void styleText(TextView tv, KrollDict d) {
        String fontSize = null;
        String fontWeight = null;
        String fontFamily = null;
        if (d.containsKey("fontSize")) {
            fontSize = TiConvert.toString(d, "fontSize");
        }
        if (d.containsKey("fontWeight")) {
            fontWeight = TiConvert.toString(d, "fontWeight");
        }
        if (d.containsKey("fontFamily")) {
            fontFamily = TiConvert.toString(d, "fontFamily");
        }
        TiUIHelper.styleText(tv, fontFamily, fontSize, fontWeight);
    }

    public static void styleText(TextView tv, String fontFamily, String fontSize, String fontWeight) {
        Typeface tf = tv.getTypeface();
        tf = TiUIHelper.toTypeface(tv.getContext(), fontFamily);
        tv.setTypeface(tf, TiUIHelper.toTypefaceStyle(fontWeight));
        tv.setTextSize(TiUIHelper.getSizeUnits(fontSize), TiUIHelper.getSize(fontSize));
    }

    public static Typeface toTypeface(Context context, String fontFamily) {
        Typeface tf = Typeface.SANS_SERIF;
        if (fontFamily != null) {
            if ("monospace".equals(fontFamily)) {
                tf = Typeface.MONOSPACE;
            } else if ("serif".equals(fontFamily)) {
                tf = Typeface.SERIF;
            } else if ("sans-serif".equals(fontFamily)) {
                tf = Typeface.SANS_SERIF;
            } else {
                Typeface loadedTf = null;
                if (context != null) {
                    loadedTf = TiUIHelper.loadTypeface(context, fontFamily);
                }
                if (loadedTf == null) {
                    if (DBG) {
                        Log.w(LCAT, "Unsupported font: '" + fontFamily + "' supported fonts are 'monospace', 'serif', 'sans-serif'.");
                    }
                } else {
                    tf = loadedTf;
                }
            }
        }
        return tf;
    }

    public static Typeface toTypeface(String fontFamily) {
        return TiUIHelper.toTypeface(null, fontFamily);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Typeface loadTypeface(Context context, String fontFamily) {
        block8: {
            if (context == null) {
                return null;
            }
            if (mCustomTypeFaces.containsKey(fontFamily)) {
                return mCustomTypeFaces.get(fontFamily);
            }
            AssetManager mgr = context.getAssets();
            try {
                String[] fontFiles;
                for (String f : fontFiles = mgr.list(customFontPath)) {
                    if (f.toLowerCase() != fontFamily.toLowerCase() && !f.toLowerCase().startsWith(fontFamily.toLowerCase() + ".")) continue;
                    Typeface tf = Typeface.createFromAsset((AssetManager)mgr, (String)("Resources/fonts/" + f));
                    Map<String, Typeface> map = mCustomTypeFaces;
                    synchronized (map) {
                        mCustomTypeFaces.put(fontFamily, tf);
                    }
                    return tf;
                }
            }
            catch (IOException e) {
                if (!DBG) break block8;
                Log.e(LCAT, "Unable to load 'fonts' assets. Perhaps doesn't exist? " + e.getMessage());
            }
        }
        mCustomTypeFaces.put(fontFamily, null);
        return null;
    }

    public static String getDefaultFontSize(Context context) {
        String size = "15.0px";
        TextView tv = new TextView(context);
        if (tv != null) {
            size = String.valueOf(tv.getTextSize()) + "px";
            tv = null;
        }
        return size;
    }

    public static String getDefaultFontWeight(Context context) {
        Typeface tf;
        String style = "normal";
        TextView tv = new TextView(context);
        if (tv != null && (tf = tv.getTypeface()) != null && tf.isBold()) {
            style = "bold";
        }
        return style;
    }

    public static void setAlignment(TextView tv, String textAlign, String verticalAlign) {
        int gravity = 0;
        if (textAlign != null) {
            if ("left".equals(textAlign)) {
                gravity |= 3;
            } else if ("center".equals(textAlign)) {
                gravity |= 1;
            } else if ("right".equals(textAlign)) {
                gravity |= 5;
            } else {
                Log.w(LCAT, "Unsupported horizontal alignment: " + textAlign);
            }
        } else {
            if (DBG) {
                Log.w(LCAT, "No alignment set - old horiz align was: " + (tv.getGravity() & 7));
            }
            if ((tv.getGravity() & 7) != 0) {
                gravity |= tv.getGravity() & 7;
            }
        }
        if (verticalAlign != null) {
            if ("top".equals(verticalAlign)) {
                gravity |= 0x30;
            } else if ("middle".equals(verticalAlign)) {
                gravity |= 0x10;
            } else if ("bottom".equals(verticalAlign)) {
                gravity |= 0x50;
            } else {
                Log.w(LCAT, "Unsupported vertical alignment: " + verticalAlign);
            }
        } else {
            if (DBG) {
                Log.w(LCAT, "No alignment set - old vert align was: " + (tv.getGravity() & 0x70));
            }
            if ((tv.getGravity() & 0x70) != 0) {
                gravity |= tv.getGravity() & 0x70;
            }
        }
        tv.setGravity(gravity);
    }

    public static void setTextViewDIPPadding(TextView textView, int horizontalPadding, int verticalPadding) {
        int rawHPadding = (int)TiUIHelper.getRawDIPSize(horizontalPadding, textView.getContext());
        int rawVPadding = (int)TiUIHelper.getRawDIPSize(verticalPadding, textView.getContext());
        textView.setPadding(rawHPadding, rawVPadding, rawHPadding, rawVPadding);
    }

    public static StateListDrawable buildBackgroundDrawable(TiContext tiContext, String image, String color, String selectedImage, String selectedColor, String disabledImage, String disabledColor, String focusedImage, String focusedColor) {
        StateListDrawable sld = null;
        Drawable bgDrawable = null;
        Drawable bgSelectedDrawable = null;
        Drawable bgFocusedDrawable = null;
        Drawable bgDisabledDrawable = null;
        Context appContext = tiContext.getActivity().getApplicationContext();
        TiFileHelper tfh = new TiFileHelper(appContext);
        if (image != null) {
            bgDrawable = tfh.loadDrawable(tiContext, image, false, true);
        } else if (color != null) {
            bgDrawable = new ColorDrawable(TiConvert.toColor(color));
        }
        if (selectedImage != null) {
            bgSelectedDrawable = tfh.loadDrawable(tiContext, selectedImage, false, true);
        } else if (selectedColor != null) {
            bgSelectedDrawable = new ColorDrawable(TiConvert.toColor(selectedColor));
        } else if (image != null) {
            bgSelectedDrawable = tfh.loadDrawable(tiContext, image, false, true);
        } else if (color != null) {
            bgSelectedDrawable = new ColorDrawable(TiConvert.toColor(color));
        }
        if (focusedImage != null) {
            bgFocusedDrawable = tfh.loadDrawable(tiContext, focusedImage, false, true);
        } else if (focusedColor != null) {
            bgFocusedDrawable = new ColorDrawable(TiConvert.toColor(focusedColor));
        } else if (image != null) {
            bgFocusedDrawable = tfh.loadDrawable(tiContext, image, false, true);
        } else if (color != null) {
            bgFocusedDrawable = new ColorDrawable(TiConvert.toColor(color));
        }
        if (disabledImage != null) {
            bgDisabledDrawable = tfh.loadDrawable(tiContext, disabledImage, false, true);
        } else if (disabledColor != null) {
            bgDisabledDrawable = new ColorDrawable(TiConvert.toColor(disabledColor));
        } else if (image != null) {
            bgDisabledDrawable = tfh.loadDrawable(tiContext, image, false, true);
        } else if (color != null) {
            bgDisabledDrawable = new ColorDrawable(TiConvert.toColor(color));
        }
        if (bgDrawable != null || bgSelectedDrawable != null || bgFocusedDrawable != null || bgDisabledDrawable != null) {
            int[] ss;
            sld = new StateListDrawable();
            if (bgDisabledDrawable != null) {
                int[] stateSet = new int[]{-16842910};
                sld.addState(stateSet, bgDisabledDrawable);
            }
            if (bgFocusedDrawable != null) {
                ss = new int[]{16842908, 16842909, 16842910};
                sld.addState(ss, bgFocusedDrawable);
            }
            if (bgSelectedDrawable != null) {
                ss = new int[]{16842909, 16842910, 16842919};
                sld.addState(ss, bgSelectedDrawable);
                int[] ss1 = new int[]{16842908, 16842909, 16842910, 16842919};
                sld.addState(ss1, bgSelectedDrawable);
            }
            if (bgDrawable != null) {
                int[] ss1 = new int[]{16842909, 16842910};
                sld.addState(ss1, bgDrawable);
                int[] ss2 = new int[]{16842910};
                sld.addState(ss2, bgDrawable);
            }
        }
        return sld;
    }

    public static KrollDict createDictForImage(TiContext context, int width, int height, byte[] data) {
        KrollDict d = new KrollDict();
        d.put("x", 0);
        d.put("y", 0);
        d.put("width", width);
        d.put("height", height);
        KrollDict cropRect = new KrollDict();
        cropRect.put("x", 0);
        cropRect.put("y", 0);
        cropRect.put("width", width);
        cropRect.put("height", height);
        d.put("cropRect", cropRect);
        d.put("media", TiBlob.blobFromData(context, data, "image/png"));
        return d;
    }

    public static TiBlob getImageFromDict(KrollDict dict) {
        Object media;
        if (dict != null && dict.containsKey("media") && (media = dict.get("media")) instanceof TiBlob) {
            return (TiBlob)media;
        }
        return null;
    }

    public static KrollDict viewToImage(TiContext context, KrollDict proxyDict, View view) {
        KrollDict image = new KrollDict();
        if (view != null) {
            int width = view.getWidth();
            int height = view.getHeight();
            if (view.getWidth() == 0 && proxyDict != null && proxyDict.containsKey("width")) {
                TiDimension widthDimension = new TiDimension(proxyDict.getString("width"), 6);
                width = widthDimension.getAsPixels(view);
            }
            if (view.getHeight() == 0 && proxyDict != null && proxyDict.containsKey("height")) {
                TiDimension heightDimension = new TiDimension(proxyDict.getString("height"), 7);
                height = heightDimension.getAsPixels(view);
            }
            view.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
            if (view.getParent() == null) {
                Log.i(LCAT, "view does not have parent, calling layout");
                view.layout(0, 0, width, height);
            }
            width = view.getMeasuredWidth();
            height = view.getMeasuredHeight();
            if (width == 0) {
                width = 100;
                Log.e(LCAT, "width property is 0 for view, display view before calling toImage()");
            }
            if (height == 0) {
                height = 100;
                Log.e(LCAT, "height property is 0 for view, display view before calling toImage()");
            }
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
            Canvas canvas = new Canvas(bitmap);
            view.draw(canvas);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bos)) {
                image = TiUIHelper.createDictForImage(context, width, height, bos.toByteArray());
            }
            canvas = null;
            bitmap.recycle();
        }
        return image;
    }

    public static Bitmap createBitmap(InputStream stream) {
        Rect pad = new Rect();
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inPurgeable = true;
        opts.inInputShareable = true;
        Bitmap b = null;
        try {
            b = BitmapFactory.decodeResourceStream(null, null, (InputStream)stream, (Rect)pad, (BitmapFactory.Options)opts);
        }
        catch (OutOfMemoryError e) {
            Log.e(LCAT, "Unable to load bitmap. Not enough memory: " + e.getMessage());
        }
        return b;
    }

    private static String getResourceKeyForImage(String url) {
        if (resourceImageKeys.containsKey(url)) {
            return resourceImageKeys.get(url);
        }
        Pattern pattern = Pattern.compile("^.*/Resources/images/(.*$)");
        Matcher matcher = pattern.matcher(url);
        if (!matcher.matches()) {
            return null;
        }
        String chopped = matcher.group(1);
        if (chopped == null) {
            return null;
        }
        String forHash = chopped = chopped.toLowerCase();
        if (forHash.endsWith(".9.png")) {
            forHash = forHash.replace(".9.png", ".png");
        }
        String withoutExtension = chopped;
        if (chopped.matches("^.*\\..*$")) {
            withoutExtension = chopped.endsWith(".9.png") ? chopped.substring(0, chopped.lastIndexOf(".9.png")) : chopped.substring(0, chopped.lastIndexOf(46));
        }
        String cleanedWithoutExtension = withoutExtension.replaceAll("[^a-z0-9_]", "_");
        StringBuilder result = new StringBuilder(100);
        result.append(cleanedWithoutExtension.substring(0, Math.min(cleanedWithoutExtension.length(), 80)));
        result.append("_");
        result.append(DigestUtils.md5Hex((String)forHash).substring(0, 10));
        String sResult = result.toString();
        resourceImageKeys.put(url, sResult);
        return sResult;
    }

    public static int getResourceId(String url) {
        if (!url.contains("Resources/images/")) {
            return 0;
        }
        String key = TiUIHelper.getResourceKeyForImage(url);
        if (key == null) {
            return 0;
        }
        try {
            return TiRHelper.getResource("drawable." + key, false);
        }
        catch (TiRHelper.ResourceNotFoundException e) {
            return 0;
        }
    }

    public static Bitmap getResourceBitmap(TiContext context, String url) {
        int id = TiUIHelper.getResourceId(url);
        if (id == 0) {
            return null;
        }
        return TiUIHelper.getResourceBitmap(context, id);
    }

    public static Bitmap getResourceBitmap(TiContext context, int res_id) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inPurgeable = true;
        opts.inInputShareable = true;
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeResource((Resources)context.getActivity().getResources(), (int)res_id, (BitmapFactory.Options)opts);
        }
        catch (OutOfMemoryError e) {
            Log.e(LCAT, "Unable to load bitmap. Not enough memory: " + e.getMessage());
        }
        return bitmap;
    }

    public static Drawable loadFastDevDrawable(TiContext context, String url) {
        try {
            TiBaseFile tbf = TiFileFactory.createTitaniumFile(context, new String[]{url}, false);
            InputStream stream = tbf.getInputStream();
            Drawable d = BitmapDrawable.createFromStream((InputStream)stream, (String)url);
            stream.close();
            return d;
        }
        catch (IOException e) {
            Log.w(LCAT, e.getMessage(), e);
            return null;
        }
    }

    public static Drawable getResourceDrawable(TiContext context, String url) {
        Drawable d;
        if (TiFastDev.isFastDevEnabled() && (d = TiUIHelper.loadFastDevDrawable(context, url)) != null) {
            return d;
        }
        int id = TiUIHelper.getResourceId(url);
        if (id == 0) {
            return null;
        }
        return TiUIHelper.getResourceDrawable(context, id);
    }

    public static Drawable getResourceDrawable(TiContext context, int res_id) {
        return context.getActivity().getResources().getDrawable(res_id);
    }

    public static void overridePendingTransition(Activity activity) {
        if (Build.VERSION.SDK_INT <= 4) {
            return;
        }
        if (overridePendingTransition == null) {
            try {
                overridePendingTransition = Activity.class.getMethod("overridePendingTransition", Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                Log.w(LCAT, "Activity.overridePendingTransition() not found");
            }
        }
        if (overridePendingTransition != null) {
            try {
                overridePendingTransition.invoke((Object)activity, 0, 0);
            }
            catch (InvocationTargetException e) {
                Log.e(LCAT, "Called incorrectly: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                Log.e(LCAT, "Illegal access: " + e.getMessage());
            }
        }
    }

    public static ColorFilter createColorFilterForOpacity(float opacity) {
        float[] matrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, opacity, 0.0f};
        return new ColorMatrixColorFilter(new ColorMatrix(matrix));
    }

    public static void setDrawableOpacity(Drawable drawable, float opacity) {
        if (drawable instanceof ColorDrawable || drawable instanceof TiBackgroundDrawable) {
            drawable.setAlpha(Math.round(opacity * 255.0f));
        } else if (drawable != null) {
            drawable.setColorFilter(TiUIHelper.createColorFilterForOpacity(opacity));
        }
    }

    public static void setPaintOpacity(Paint paint, float opacity) {
        paint.setColorFilter(TiUIHelper.createColorFilterForOpacity(opacity));
    }

    public static void requestSoftInputChange(KrollProxy proxy2, View view) {
        int focusState = 0;
        if (proxy2.hasProperty("softKeyboardOnFocus")) {
            focusState = TiConvert.toInt(proxy2.getProperty("softKeyboardOnFocus"));
        }
        if (focusState > 0) {
            if (focusState == 2) {
                TiUIHelper.showSoftKeyboard(view, true);
            } else if (focusState == 1) {
                TiUIHelper.showSoftKeyboard(view, false);
            } else {
                Log.w(LCAT, "Unknown onFocus state: " + focusState);
            }
        }
    }

    public static void showSoftKeyboard(View view, boolean show) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (imm != null) {
            boolean useForce = Build.VERSION.SDK_INT <= 4 || Build.VERSION.SDK_INT >= 8;
            String model = TiPlatformHelper.getModel();
            if (model != null && model.toLowerCase().startsWith("droid")) {
                useForce = true;
            }
            if (show) {
                imm.showSoftInput(view, useForce ? 2 : 1);
            } else {
                imm.hideSoftInputFromWindow(view.getWindowToken(), useForce ? 0 : 1);
            }
        }
    }

    public static void runUiDelayed(final Runnable runnable) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... arg0) {
                return null;
            }

            protected void onPostExecute(Void result) {
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(runnable);
            }
        }.execute((Object[])new Void[0]);
    }

    public static void runUiDelayedIfBlock(Runnable runnable) {
        if (TiMessageQueue.getMainMessageQueue().isBlocking()) {
            TiUIHelper.runUiDelayed(runnable);
        } else {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(runnable);
        }
    }

    static {
        resourceImageKeys = Collections.synchronizedMap(new HashMap());
        mCustomTypeFaces = Collections.synchronizedMap(new HashMap());
    }

    public static interface CurrentActivityListener {
        public void onCurrentActivityReady(Activity var1);
    }
}

