/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.os.Environment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;

public class TiTempFileHelper {
    private static final String TAG = "TiTempFileHelper";
    private static final boolean DBG = TiConfig.DEBUG;
    public static final String TEMPDIR = "_tmp";
    public static final int DEFAULT_CLEAN_TIMEOUT = 5;
    protected File tempDir;
    protected ArrayList<String> createdThisSession = new ArrayList();

    public TiTempFileHelper(TiApplication app) {
        File extStorage = Environment.getExternalStorageDirectory();
        File dataDir = new File(new File(extStorage, "Android"), "data");
        File externalCacheDir = new File(new File(dataDir, app.getPackageName()), "cache");
        this.tempDir = new File(externalCacheDir, TEMPDIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createTempFile(String prefix, String suffix) throws IOException {
        String extState = Environment.getExternalStorageState();
        if ("mounted".equals(extState)) {
            if (!this.tempDir.exists()) {
                this.tempDir.mkdirs();
            }
            File tempFile = File.createTempFile(prefix, suffix, this.tempDir);
            ArrayList<String> arrayList = this.createdThisSession;
            synchronized (arrayList) {
                this.createdThisSession.add(tempFile.getAbsolutePath());
            }
            return tempFile;
        }
        throw new IOException("External storage not mounted for writing");
    }

    public void scheduleCleanTempDir() {
        this.scheduleCleanTempDir(5L, TimeUnit.SECONDS);
    }

    public void scheduleCleanTempDir(long delay, TimeUnit timeUnit) {
        if (!this.tempDir.exists()) {
            Log.w(TAG, "The external temp directory doesn't exist, skipping cleanup");
            return;
        }
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        service.schedule(new AsyncCleanup(service), delay, timeUnit);
    }

    public void cleanTempDir() {
        String extState = Environment.getExternalStorageState();
        if ("mounted".equals(extState)) {
            this.doCleanTempDir();
        } else {
            Log.w(TAG, "External storage not mounted, skipping clean up.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCleanTempDir() {
        if (!this.tempDir.exists()) {
            Log.w(TAG, "The external temp directory doesn't exist, skipping cleanup");
            return;
        }
        for (File file : this.tempDir.listFiles()) {
            String absolutePath = file.getAbsolutePath();
            ArrayList<String> arrayList = this.createdThisSession;
            synchronized (arrayList) {
                if (this.createdThisSession.contains(absolutePath)) {
                    continue;
                }
            }
            if (DBG) {
                Log.d(TAG, "Deleting temporary file " + absolutePath);
            }
            try {
                file.delete();
            }
            catch (Exception e) {
                Log.w(TAG, "Exception trying to delete " + absolutePath + ", skipping", e);
            }
        }
    }

    protected class AsyncCleanup
    implements Runnable,
    ThreadFactory {
        protected ExecutorService service;

        public AsyncCleanup(ExecutorService service) {
            this.service = service;
        }

        @Override
        public void run() {
            TiTempFileHelper.this.cleanTempDir();
            this.service.shutdown();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setPriority(1);
            return thread;
        }
    }
}

