/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import ti.modules.titanium.BufferProxy;

public class TiStreamHelper {
    private static final String LCAT = "TiStreamHelper";
    private static final boolean DBG = TiConfig.LOGD;
    public static final int DEFAULT_BUFFER_SIZE = 1024;

    public static int read(InputStream inputStream, BufferProxy bufferProxy, int offset, int length) throws IOException {
        byte[] buffer = bufferProxy.getBuffer();
        if (offset + length > buffer.length) {
            length = buffer.length - offset;
        }
        return inputStream.read(buffer, offset, length);
    }

    public static int write(OutputStream outputStream, BufferProxy bufferProxy, int offset, int length) throws IOException {
        byte[] buffer = bufferProxy.getBuffer();
        if (offset + length > buffer.length) {
            length = buffer.length - offset;
        }
        outputStream.write(buffer, offset, length);
        outputStream.flush();
        return length;
    }

    public static void pump(InputStream in, OutputStream out) {
        TiStreamHelper.pump(in, out, 1024);
    }

    public static void pump(InputStream in, OutputStream out, int bufferSize) {
        byte[] buffer = new byte[bufferSize];
        int count = 0;
        try {
            while ((count = in.read(buffer)) != -1) {
                if (out == null) continue;
                out.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            Log.e(LCAT, "IOException pumping streams", e);
        }
    }

    public static void pumpCount(InputStream in, OutputStream out, int byteCount) {
        TiStreamHelper.pumpCount(in, out, byteCount, 1024);
    }

    public static void pumpCount(InputStream in, OutputStream out, int byteCount, int bufferSize) {
        byte[] buffer = new byte[bufferSize];
        try {
            int count;
            for (int totalCount = 0; totalCount < byteCount && (count = in.read(buffer)) != -1; totalCount += count) {
                if (out == null) continue;
                out.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            Log.e(LCAT, "IOException pumping streams", e);
        }
    }

    public static byte[] toByteArray(InputStream in) {
        return TiStreamHelper.toByteArray(in, 32);
    }

    public static byte[] toByteArray(InputStream in, int size) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(size);
        TiStreamHelper.pump(in, out);
        return out.toByteArray();
    }

    public static String toString(InputStream in) {
        return new String(TiStreamHelper.toByteArray(in));
    }
}

