/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import java.util.concurrent.atomic.AtomicInteger;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;

public class TiSensorHelper {
    private static final String LCAT = "TiSensorHelper";
    private static final boolean DBG = TiConfig.LOGD;
    private static AtomicInteger listenerCount = new AtomicInteger();
    private static SensorManager sensorManager;

    public static void registerListener(int[] types, SensorEventListener listener, int rate) {
        for (int type : types) {
            TiSensorHelper.registerListener(type, listener, rate);
        }
    }

    public static void registerListener(int type, SensorEventListener listener, int rate) {
        Sensor sensor;
        if (sensorManager == null) {
            sensorManager = (SensorManager)TiApplication.getInstance().getSystemService("sensor");
        }
        if ((sensor = sensorManager.getDefaultSensor(type)) != null) {
            if (DBG) {
                Log.d(LCAT, "Enabling Listener: " + sensor.getName());
            }
            sensorManager.registerListener(listener, sensor, rate);
            listenerCount.incrementAndGet();
        } else {
            Log.e(LCAT, "unable to register, sensor is null");
        }
    }

    public static void unregisterListener(int[] types, SensorEventListener listener) {
        for (int type : types) {
            TiSensorHelper.unregisterListener(type, listener);
        }
    }

    public static void unregisterListener(int type, SensorEventListener listener) {
        if (sensorManager != null) {
            Sensor sensor = sensorManager.getDefaultSensor(type);
            if (sensor != null) {
                if (DBG) {
                    Log.d(LCAT, "Disabling Listener: " + sensor.getName());
                }
                sensorManager.unregisterListener(listener, sensor);
                if (listenerCount.decrementAndGet() == 0) {
                    sensorManager = null;
                }
            } else {
                Log.e(LCAT, "unable to unregister, sensor is null");
            }
        } else {
            Log.e(LCAT, "unable to unregister, sensorManager is null");
        }
    }

    public static boolean hasDefaultSensor(Activity activity, int type) {
        boolean oneShot = false;
        boolean result = false;
        if (sensorManager == null) {
            oneShot = true;
            sensorManager = (SensorManager)activity.getSystemService("sensor");
        }
        if (sensorManager != null) {
            boolean bl = result = sensorManager.getDefaultSensor(type) != null;
            if (oneShot) {
                sensorManager = null;
            }
        }
        return result;
    }

    public static SensorManager getSensorManager() {
        return sensorManager;
    }
}

