/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.ResponseCache;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;

public class TiResponseCache
extends ResponseCache {
    private static final boolean DBG = TiConfig.LOGD;
    private static final String TAG = "TiResponseCache";
    private static final String HEADER_SUFFIX = ".hdr";
    private static final String BODY_SUFFIX = ".bdy";
    private static final String CACHE_SIZE_KEY = "ti.android.cache.size.max";
    private static final int DEFAULT_CACHE_SIZE = 0x1900000;
    private static final int INITIAL_DELAY = 10000;
    private static final int CLEANUP_DELAY = 60000;
    private static final String LCAT = "TiResponseCache";
    private static HashMap<String, ArrayList<CompleteListener>> completeListeners = new HashMap();
    private static long maxCacheSize = 0L;
    private static ScheduledExecutorService cleanupExecutor = null;
    private File cacheDir = null;

    public static boolean peek(URI uri) {
        TiResponseCache rc = (TiResponseCache)TiResponseCache.getDefault();
        if (rc == null) {
            return false;
        }
        if (rc.cacheDir == null) {
            return false;
        }
        String hash = DigestUtils.shaHex((String)uri.toString());
        File hFile = new File(rc.cacheDir, hash + HEADER_SUFFIX);
        File bFile = new File(rc.cacheDir, hash + BODY_SUFFIX);
        return bFile.exists() && hFile.exists();
    }

    public static InputStream openCachedStream(URI uri) {
        TiResponseCache rc = (TiResponseCache)TiResponseCache.getDefault();
        if (rc == null) {
            return null;
        }
        if (rc.cacheDir == null) {
            return null;
        }
        String hash = DigestUtils.shaHex((String)uri.toString());
        File hFile = new File(rc.cacheDir, hash + HEADER_SUFFIX);
        File bFile = new File(rc.cacheDir, hash + BODY_SUFFIX);
        if (!bFile.exists() || !hFile.exists()) {
            return null;
        }
        try {
            return new FileInputStream(bFile);
        }
        catch (FileNotFoundException e) {
            Log.e("TiResponseCache", "File not found", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCompleteListener(URI uri, CompleteListener listener) {
        HashMap<String, ArrayList<CompleteListener>> hashMap = completeListeners;
        synchronized (hashMap) {
            String hash = DigestUtils.shaHex((String)uri.toString());
            if (!completeListeners.containsKey(hash)) {
                completeListeners.put(hash, new ArrayList());
            }
            completeListeners.get(hash).add(listener);
        }
    }

    public TiResponseCache(File cachedir, TiApplication tiApp) {
        assert (cachedir.isDirectory()) : "cachedir MUST be a directory";
        this.cacheDir = cachedir;
        maxCacheSize = tiApp.getSystemProperties().getInt(CACHE_SIZE_KEY, 0x1900000) * 1024;
        if (DBG) {
            Log.d("TiResponseCache", "max cache size is:" + maxCacheSize);
        }
        cleanupExecutor = Executors.newSingleThreadScheduledExecutor();
        TiCacheCleanup command = new TiCacheCleanup(this.cacheDir, maxCacheSize);
        cleanupExecutor.scheduleWithFixedDelay(command, 10000L, 60000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public CacheResponse get(URI uri, String rqstMethod, Map<String, List<String>> rqstHeaders) throws IOException {
        if (uri == null || this.cacheDir == null) {
            return null;
        }
        String hash = DigestUtils.shaHex((String)uri.toString());
        File hFile = new File(this.cacheDir, hash + HEADER_SUFFIX);
        File bFile = new File(this.cacheDir, hash + BODY_SUFFIX);
        if (!bFile.exists() || !hFile.exists()) {
            return null;
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        BufferedReader rdr = new BufferedReader(new FileReader(hFile), 1024);
        String line = rdr.readLine();
        while (line != null) {
            String[] keyval = line.split("=", 2);
            if (!headers.containsKey(keyval[0])) {
                headers.put(keyval[0], new ArrayList());
            }
            ((List)headers.get(keyval[0])).add(keyval[1]);
            line = rdr.readLine();
        }
        rdr.close();
        hFile.setLastModified(System.currentTimeMillis());
        return new TiCacheResponse(headers, new FileInputStream(bFile));
    }

    protected String getHeader(Map<String, List<String>> headers, String header) {
        List<String> values = headers.get(header);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(values.size() - 1);
    }

    protected int getHeaderInt(Map<String, List<String>> headers, String header, int defaultValue) {
        String value = this.getHeader(headers, header);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private Map<String, List<String>> makeLowerCaseHeaders(Map<String, List<String>> origHeaders) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(origHeaders.size());
        for (String key : origHeaders.keySet()) {
            if (key == null) continue;
            headers.put(key.toLowerCase(), origHeaders.get(key));
        }
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheRequest put(URI uri, URLConnection conn) throws IOException {
        if (this.cacheDir == null) {
            return null;
        }
        Map<String, List<String>> headers = this.makeLowerCaseHeaders(conn.getHeaderFields());
        String cacheControl = this.getHeader(headers, "cache-control");
        if (cacheControl != null && cacheControl.matches("^.*(no-cache|no-store|must-revalidate).*")) {
            return null;
        }
        boolean skipTransferEncodingHeader = false;
        String tEncoding = this.getHeader(headers, "transfer-encoding");
        if (tEncoding != null && tEncoding.toLowerCase().equals("chunked")) {
            skipTransferEncodingHeader = true;
        }
        String newl = System.getProperty("line.separator");
        long contentLength = this.getHeaderInt(headers, "content-length", 0);
        StringBuilder sb = new StringBuilder();
        for (String hdr : headers.keySet()) {
            if (skipTransferEncodingHeader && hdr.equals("transfer-encoding")) continue;
            for (String val : headers.get(hdr)) {
                sb.append(hdr);
                sb.append("=");
                sb.append(val);
                sb.append(newl);
            }
        }
        if (contentLength + (long)sb.length() > maxCacheSize) {
            return null;
        }
        try {
            uri = conn.getURL().toURI();
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        String hash = DigestUtils.shaHex((String)uri.toString());
        File hFile = new File(this.cacheDir, hash + HEADER_SUFFIX);
        File bFile = new File(this.cacheDir, hash + BODY_SUFFIX);
        FileWriter hWriter = new FileWriter(hFile);
        try {
            hWriter.write(sb.toString());
        }
        finally {
            hWriter.close();
        }
        TiResponseCache tiResponseCache = this;
        synchronized (tiResponseCache) {
            if (!bFile.createNewFile()) {
                return null;
            }
            return new TiCacheRequest(uri, bFile, hFile, contentLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void fireCacheCompleted(URI uri) {
        HashMap<String, ArrayList<CompleteListener>> hashMap = completeListeners;
        synchronized (hashMap) {
            String hash = DigestUtils.shaHex((String)uri.toString());
            if (completeListeners.containsKey(hash)) {
                for (CompleteListener listener : completeListeners.get(hash)) {
                    listener.cacheCompleted(uri);
                }
                completeListeners.remove(hash);
            }
        }
    }

    private static class TiCacheRequest
    extends CacheRequest {
        private URI uri;
        private File bFile;
        private File hFile;
        private long contentLength;

        public TiCacheRequest(URI uri, File bFile, File hFile, long contentLength) {
            this.uri = uri;
            this.bFile = bFile;
            this.hFile = hFile;
            this.contentLength = contentLength;
        }

        @Override
        public OutputStream getBody() throws IOException {
            return new TiCacheOutputStream(this.uri, this.bFile);
        }

        @Override
        public void abort() {
            if (this.bFile.length() != this.contentLength) {
                Log.e("TiResponseCache", "Failed to add item to the cache!");
                if (this.bFile.exists()) {
                    this.bFile.delete();
                }
                if (this.hFile.exists()) {
                    this.hFile.delete();
                }
            }
        }
    }

    private static class TiCacheOutputStream
    extends FileOutputStream {
        private URI uri;

        public TiCacheOutputStream(URI uri, File file) throws FileNotFoundException {
            super(file);
            this.uri = uri;
        }

        @Override
        public void close() throws IOException {
            super.close();
            TiResponseCache.fireCacheCompleted(this.uri);
        }
    }

    private static class TiCacheResponse
    extends CacheResponse {
        private Map<String, List<String>> headers;
        private InputStream istream;

        public TiCacheResponse(Map<String, List<String>> hdrs, InputStream istr) {
            this.headers = hdrs;
            this.istream = istr;
        }

        @Override
        public Map<String, List<String>> getHeaders() throws IOException {
            return this.headers;
        }

        @Override
        public InputStream getBody() throws IOException {
            return this.istream;
        }
    }

    private static class TiCacheCleanup
    implements Runnable {
        private File cacheDir;
        private long maxSize;

        public TiCacheCleanup(File cacheDir, long maxSize) {
            this.cacheDir = cacheDir;
            this.maxSize = maxSize;
        }

        @Override
        public void run() {
            HashMap<Long, File> lastTime = new HashMap<Long, File>();
            for (File hdrFile : this.cacheDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(TiResponseCache.HEADER_SUFFIX);
                }
            })) {
                lastTime.put(hdrFile.lastModified(), hdrFile);
            }
            ArrayList sz = new ArrayList(lastTime.keySet());
            Collections.sort(sz);
            Collections.reverse(sz);
            long cacheSize = 0L;
            for (Long last : sz) {
                File hdrFile = (File)lastTime.get(last);
                String h = hdrFile.getName().substring(0, hdrFile.getName().lastIndexOf(46));
                File bdyFile = new File(this.cacheDir, h + TiResponseCache.BODY_SUFFIX);
                cacheSize += hdrFile.length();
                if ((cacheSize += bdyFile.length()) <= this.maxSize) continue;
                hdrFile.delete();
                bdyFile.delete();
            }
        }
    }

    public static interface CompleteListener {
        public void cacheCompleted(URI var1);
    }
}

