/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;

public class TiRHelper {
    private static final String LCAT = "TiRHelper";
    private static final boolean DBG = TiConfig.LOGD;
    private static Map<String, Class<?>> clsCache = Collections.synchronizedMap(new HashMap());
    private static Map<String, Integer> valCache = Collections.synchronizedMap(new HashMap());
    private static String clsPrefixAndroid = "android.R$";
    private static String clsPrefixApplication = null;

    private static Class<?> getClass(String classname) throws ClassNotFoundException {
        Class<?> cls = clsCache.get(classname);
        if (cls != null) {
            return cls;
        }
        cls = Class.forName(classname);
        clsCache.put(classname, cls);
        return cls;
    }

    protected static String[] getClassAndFieldNames(String path) {
        int lastDot = path.lastIndexOf(46);
        String className = lastDot < 0 ? "" : path.substring(0, lastDot < 0 ? 1 : lastDot).replace('.', '$');
        String fieldName = lastDot < 0 ? path : path.substring(lastDot + 1);
        return new String[]{className, fieldName};
    }

    protected static int getResource(String prefix, String path) throws ResourceNotFoundException {
        Integer i = valCache.get(path);
        if (i != null) {
            return i;
        }
        return TiRHelper.lookupResource(prefix, path, TiRHelper.getClassAndFieldNames(path));
    }

    protected static int lookupResource(String prefix, String path, String[] classAndFieldNames) throws ResourceNotFoundException {
        if (clsPrefixApplication == null) {
            clsPrefixApplication = TiApplication.getInstance().getApplicationInfo().packageName + ".R$";
        }
        if (prefix == null) {
            prefix = clsPrefixApplication;
        }
        Integer i = null;
        try {
            i = TiRHelper.getClass(prefix + classAndFieldNames[0]).getDeclaredField(classAndFieldNames[1]).getInt(null);
        }
        catch (Exception e) {
            if (DBG) {
                Log.e(LCAT, "Error looking up resource: " + e.getMessage(), e);
            }
            valCache.put(path, 0);
            throw new ResourceNotFoundException(path);
        }
        valCache.put(path, i);
        return i;
    }

    public static int getResource(String path, boolean includeSystemResources) throws ResourceNotFoundException {
        Integer i = valCache.get(path);
        if (i != null) {
            return i;
        }
        String[] classAndFieldNames = TiRHelper.getClassAndFieldNames(path);
        try {
            int resid = TiRHelper.lookupResource(clsPrefixApplication, path, classAndFieldNames);
            return resid;
        }
        catch (ResourceNotFoundException e) {
            if (!includeSystemResources) {
                throw e;
            }
            return TiRHelper.lookupResource(clsPrefixAndroid, path, classAndFieldNames);
        }
    }

    public static int getResource(String path) throws ResourceNotFoundException {
        return TiRHelper.getResource(path, true);
    }

    public static int getApplicationResource(String path) throws ResourceNotFoundException {
        return TiRHelper.getResource(clsPrefixApplication, path);
    }

    public static int getAndroidResource(String path) throws ResourceNotFoundException {
        return TiRHelper.getResource(clsPrefixAndroid, path);
    }

    public static void clearCache() {
        valCache.clear();
        clsCache.clear();
    }

    public static final class ResourceNotFoundException
    extends ClassNotFoundException {
        private static final long serialVersionUID = 119234857198273641L;

        public ResourceNotFoundException(String resource) {
            super("Resource not found: " + resource);
        }
    }
}

