/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.text.format.Formatter;
import android.util.DisplayMetrics;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import org.appcelerator.titanium.ITiAppInfo;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiDatabaseHelper;

public class TiPlatformHelper {
    public static final String LCAT = "TiPlatformHelper";
    public static final boolean DBG = TiConfig.LOGD;
    private static final Map<String, Locale> locales = Collections.synchronizedMap(new HashMap());
    private static final Map<Locale, String> currencyCodes = Collections.synchronizedMap(new HashMap());
    private static final Map<Locale, String> currencySymbols = Collections.synchronizedMap(new HashMap());
    private static final Map<String, String> currencySymbolsByCode = Collections.synchronizedMap(new HashMap());
    public static String platformId;
    public static String sessionId;
    public static StringBuilder sb;
    public static float applicationScaleFactor;
    public static int applicationLogicalDensity;
    private static boolean applicationDisplayInfoInitialized;

    public static void initialize() {
        TiApplication app = TiApplication.getInstance();
        platformId = Settings.Secure.getString((ContentResolver)app.getContentResolver(), (String)"android_id");
        if (platformId == null) {
            Log.e(LCAT, "platformId is null, setting to empty string");
            platformId = "";
        }
        TiDatabaseHelper db = new TiDatabaseHelper((Context)app);
        String storedMachineId = db.getPlatformParam("unique_machine_id", "");
        String hardwareMachineId = db.getPlatformParam("hardware_machine_id", "");
        String currentMachineId = !platformId.equals(hardwareMachineId) ? platformId : storedMachineId;
        String[] badIds = new String[]{"9774d56d682e549c", "1234567890ABCDEF"};
        for (int i = 0; i < badIds.length; ++i) {
            if (!currentMachineId.equals(badIds[i])) continue;
            Log.e(LCAT, "renaming ID");
            currentMachineId = TiPlatformHelper.createUUID();
            break;
        }
        if (currentMachineId != storedMachineId) {
            db.updatePlatformParam("unique_machine_id", currentMachineId);
            db.updatePlatformParam("hardware_machine_id", platformId);
            db.updatePlatformParam("previous_machine_id", storedMachineId);
        }
        platformId = currentMachineId;
        sessionId = TiPlatformHelper.createUUID();
    }

    public static synchronized void intializeDisplayMetrics(Activity activity) {
        if (!applicationDisplayInfoInitialized) {
            DisplayMetrics dm = new DisplayMetrics();
            activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
            try {
                Method gciMethod = Resources.class.getMethod("getCompatibilityInfo", new Class[0]);
                Object compatInfo = gciMethod.invoke((Object)activity.getResources(), new Object[0]);
                applicationScaleFactor = ((Float)compatInfo.getClass().getField("applicationScale").get(compatInfo)).floatValue();
            }
            catch (Exception e) {
                Log.w(LCAT, "Unable to get application scale factor, using reported density and it's factor");
            }
            applicationLogicalDensity = applicationScaleFactor == 1.0f ? dm.densityDpi : (applicationScaleFactor > 1.0f ? 160 : 120);
            applicationDisplayInfoInitialized = true;
        }
    }

    public static ITiAppInfo getAppInfo() {
        return TiApplication.getInstance().getAppInfo();
    }

    public static String getName() {
        return "android";
    }

    public static int getProcessorCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static String getUsername() {
        return Build.USER;
    }

    public static String getVersion() {
        return Build.VERSION.RELEASE;
    }

    public static double getAvailableMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static String getModel() {
        return Build.MODEL;
    }

    public static String getOstype() {
        return "32bit";
    }

    public static String getMobileId() {
        return platformId;
    }

    public static String createUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getSessionId() {
        return sessionId;
    }

    public static String getLocale() {
        return Locale.getDefault().toString().replace("_", "-");
    }

    public static Locale getLocale(String localeCode) {
        StringTokenizer tokens;
        if (localeCode == null) {
            return null;
        }
        String code = localeCode.replace('-', '_');
        if (locales.containsKey(code)) {
            return locales.get(code);
        }
        String language = "";
        String country = "";
        String variant = "";
        if (code.startsWith("__")) {
            tokens = new StringTokenizer(code, "__");
            if (tokens.hasMoreElements()) {
                variant = tokens.nextToken();
            }
        } else if (code.startsWith("_")) {
            tokens = new StringTokenizer(code, "_");
            if (tokens.hasMoreElements()) {
                country = tokens.nextToken();
            }
            if (tokens.hasMoreElements()) {
                variant = tokens.nextToken();
            }
        } else if (code.contains("__")) {
            tokens = new StringTokenizer(code, "__");
            if (tokens.hasMoreElements()) {
                language = tokens.nextToken();
            }
            if (tokens.hasMoreElements()) {
                variant = tokens.nextToken();
            }
        } else {
            tokens = new StringTokenizer(code, "__");
            if (tokens.hasMoreElements()) {
                language = tokens.nextToken();
            }
            if (tokens.hasMoreElements()) {
                country = tokens.nextToken();
            }
            if (tokens.hasMoreElements()) {
                variant = tokens.nextToken();
            }
        }
        Locale l = new Locale(language, country, variant);
        locales.put(code, l);
        return l;
    }

    public static String getCurrencyCode(Locale locale) {
        String code;
        if (currencyCodes.containsKey(locale)) {
            code = currencyCodes.get(locale);
        } else {
            code = Currency.getInstance(locale).getCurrencyCode();
            currencyCodes.put(locale, code);
        }
        return code;
    }

    public static String getCurrencySymbol(Locale locale) {
        String symbol;
        if (currencySymbols.containsKey(locale)) {
            symbol = currencySymbols.get(locale);
        } else {
            symbol = Currency.getInstance(locale).getSymbol(locale);
            currencySymbols.put(locale, symbol);
        }
        return symbol;
    }

    public static String getCurrencySymbol(String currencyCode) {
        String symbol;
        if (currencySymbolsByCode.containsKey(currencyCode)) {
            symbol = currencySymbolsByCode.get(currencyCode);
        } else {
            symbol = Currency.getInstance(currencyCode).getSymbol();
            currencySymbolsByCode.put(currencyCode, symbol);
        }
        return symbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createEventId() {
        String s = null;
        StringBuilder stringBuilder = sb;
        synchronized (stringBuilder) {
            sb.append(TiPlatformHelper.createUUID()).append(":").append(TiPlatformHelper.getMobileId());
            s = sb.toString();
            sb.setLength(0);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getArchitecture() {
        String arch = "Unknown";
        try {
            BufferedReader reader = new BufferedReader(new FileReader("/proc/cpuinfo"), 8096);
            try {
                String l = null;
                while ((l = reader.readLine()) != null) {
                    if (!l.startsWith("Processor")) continue;
                    String[] values = l.split(":");
                    arch = values[1].trim();
                    break;
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            Log.e(LCAT, "Error while trying to access processor info in /proc/cpuinfo", e);
        }
        return arch;
    }

    public static String getMacaddress() {
        String macaddr = null;
        TiApplication tiApp = TiApplication.getInstance();
        if (tiApp.getRootActivity().checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE") == 0) {
            WifiManager wm = (WifiManager)tiApp.getRootActivity().getSystemService("wifi");
            if (wm != null) {
                WifiInfo wi = wm.getConnectionInfo();
                if (wi != null) {
                    macaddr = wi.getMacAddress();
                    if (DBG) {
                        Log.d(LCAT, "Found mac address " + macaddr);
                    }
                } else {
                    if (DBG) {
                        Log.d(LCAT, "no WifiInfo, enabling Wifi to get macaddr");
                    }
                    if (!wm.isWifiEnabled()) {
                        if (wm.setWifiEnabled(true)) {
                            wi = wm.getConnectionInfo();
                            if (wi != null) {
                                macaddr = wi.getMacAddress();
                            } else if (DBG) {
                                Log.d(LCAT, "still no WifiInfo, assuming no macaddr");
                            }
                            if (DBG) {
                                Log.d(LCAT, "disabling wifi because we enabled it.");
                            }
                            wm.setWifiEnabled(false);
                        } else if (DBG) {
                            Log.d(LCAT, "enabling wifi failed, assuming no macaddr");
                        }
                    } else if (DBG) {
                        Log.d(LCAT, "wifi already enabled, assuming no macaddr");
                    }
                }
            }
        } else {
            Log.i(LCAT, "Must have android.permission.ACCESS_WIFI_STATE");
        }
        if (macaddr == null) {
            macaddr = TiPlatformHelper.getMobileId();
        }
        return macaddr;
    }

    public static String getIpAddress() {
        String ipAddress = null;
        TiApplication tiApp = TiApplication.getInstance();
        if (tiApp.getRootActivity().checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE") == 0) {
            WifiManager wifiManager = (WifiManager)tiApp.getRootActivity().getSystemService("wifi");
            if (wifiManager != null) {
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                if (wifiInfo != null) {
                    ipAddress = Formatter.formatIpAddress((int)wifiInfo.getIpAddress());
                    if (DBG) {
                        Log.d(LCAT, "Found IP address: " + ipAddress);
                    }
                } else {
                    Log.e(LCAT, "Unable to access WifiInfo, failed to get IP address");
                }
            } else {
                Log.e(LCAT, "Unable to access the WifiManager, failed to get IP address");
            }
        } else {
            Log.e(LCAT, "Must have android.permission.ACCESS_WIFI_STATE, failed to get IP address");
        }
        return ipAddress;
    }

    public static String getNetmask() {
        String netmask = null;
        TiApplication tiApp = TiApplication.getInstance();
        if (tiApp.getRootActivity().checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE") == 0) {
            WifiManager wifiManager = (WifiManager)tiApp.getRootActivity().getSystemService("wifi");
            if (wifiManager != null) {
                DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
                if (dhcpInfo != null) {
                    netmask = Formatter.formatIpAddress((int)dhcpInfo.netmask);
                    if (DBG) {
                        Log.d(LCAT, "Found netmask: " + netmask);
                    }
                } else {
                    Log.e(LCAT, "Unable to access DhcpInfo, failed to get netmask");
                }
            } else {
                Log.e(LCAT, "Unable to access the WifiManager, failed to get netmask");
            }
        } else {
            Log.e(LCAT, "Must have android.permission.ACCESS_WIFI_STATE, failed to get netmask");
        }
        return netmask;
    }

    public static String getNetworkTypeName() {
        return TiPlatformHelper.networkTypeToTypeName(TiPlatformHelper.getNetworkType());
    }

    private static int getNetworkType() {
        int type = -1;
        ConnectivityManager connectivityManager = (ConnectivityManager)TiApplication.getInstance().getSystemService("connectivity");
        if (connectivityManager != null) {
            try {
                NetworkInfo ni = connectivityManager.getActiveNetworkInfo();
                type = ni != null && ni.isAvailable() && ni.isConnected() ? ni.getType() : -2;
            }
            catch (SecurityException e) {
                Log.w(LCAT, "Permission has been removed. Cannot determine network type: " + e.getMessage());
            }
        }
        return type;
    }

    private static String networkTypeToTypeName(int type) {
        switch (type) {
            case -2: {
                return "NONE";
            }
            case 1: {
                return "WIFI";
            }
            case 0: {
                return "MOBILE";
            }
            case 3: {
                return "LAN";
            }
        }
        return "UNKNOWN";
    }

    static {
        sb = new StringBuilder(256);
        applicationScaleFactor = 1.0f;
        applicationLogicalDensity = 160;
        applicationDisplayInfoInitialized = false;
    }
}

