/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import java.util.ArrayList;
import org.appcelerator.titanium.util.TiConfig;

public class TiNinePatchHelper {
    private static final String LCAT = "TiNinePatch";
    private static final boolean DBG = TiConfig.LOGD;

    public Drawable process(Drawable d) {
        Bitmap b;
        Drawable nd = d;
        if (d instanceof BitmapDrawable && (b = ((BitmapDrawable)d).getBitmap()) != null && this.isNinePatch(b)) {
            byte[] newChunk = this.createChunk(b);
            nd = new NinePatchDrawable(this.cropNinePatch(b), newChunk, new Rect(1, 1, 1, 1), "");
        }
        return nd;
    }

    public Drawable process(Bitmap b) {
        BitmapDrawable nd = null;
        if (b != null) {
            if (this.isNinePatch(b)) {
                byte[] newChunk = this.createChunk(b);
                nd = new NinePatchDrawable(this.cropNinePatch(b), newChunk, new Rect(1, 1, 1, 1), "");
            } else {
                nd = new BitmapDrawable(b);
            }
        }
        return nd;
    }

    private boolean isNinePatch(Bitmap b) {
        boolean result = true;
        int width = b.getWidth();
        int height = b.getHeight();
        int topSum = 0;
        int leftSum = 0;
        int rightSum = 0;
        int bottomSum = 0;
        if (width >= 3 && height >= 3) {
            int c;
            int i;
            for (i = 0; i < width; ++i) {
                c = b.getPixel(i, 0);
                topSum += c == 0 ? 0 : 1;
                if (!this.isValidColor(c)) {
                    result = false;
                    break;
                }
                c = b.getPixel(i, height - 1);
                bottomSum += c == 0 ? 0 : 1;
                if (this.isValidColor(c)) continue;
                result = false;
                break;
            }
            if (result) {
                for (i = 0; i < height; ++i) {
                    c = b.getPixel(0, i);
                    leftSum += c == 0 ? 0 : 1;
                    if (!this.isValidColor(c)) {
                        result = false;
                    } else {
                        c = b.getPixel(width - 1, i);
                        rightSum += c == 0 ? 0 : 1;
                        if (this.isValidColor(c)) continue;
                        result = false;
                    }
                    break;
                }
            }
        } else {
            result = false;
        }
        if (leftSum + topSum + rightSum + bottomSum == 0) {
            result = false;
        }
        return result;
    }

    private boolean isValidColor(int c) {
        return c == 0 || c == -16777216;
    }

    private Bitmap cropNinePatch(Bitmap b) {
        Bitmap cb = null;
        cb = Bitmap.createBitmap((int)(b.getWidth() - 2), (int)(b.getHeight() - 2), (Bitmap.Config)b.getConfig());
        int[] pixels = new int[cb.getWidth() * cb.getHeight()];
        b.getPixels(pixels, 0, cb.getWidth(), 1, 1, cb.getWidth(), cb.getHeight());
        cb.setPixels(pixels, 0, cb.getWidth(), 0, 0, cb.getWidth(), cb.getHeight());
        return cb;
    }

    byte[] createChunk(Bitmap b) {
        byte[] chunk = null;
        int numXDivs = 0;
        int numYDivs = 0;
        int numColors = 1;
        int last = b.getPixel(0, 0);
        ArrayList<SegmentColor> xdivs = new ArrayList<SegmentColor>();
        for (int x = 1; x < b.getWidth(); ++x) {
            int p = b.getPixel(x, 0);
            if (p == last) continue;
            SegmentColor sc = new SegmentColor();
            sc.index = x;
            sc.color = last;
            xdivs.add(sc);
            ++numXDivs;
            last = p;
        }
        last = b.getPixel(0, 0);
        ArrayList<SegmentColor> ydivs = new ArrayList<SegmentColor>();
        for (int y = 1; y < b.getHeight(); ++y) {
            int p = b.getPixel(0, y);
            if (p == last) continue;
            SegmentColor sc = new SegmentColor();
            sc.index = y;
            sc.color = last;
            ydivs.add(sc);
            ++numYDivs;
            last = p;
        }
        ArrayList<Integer> colors = new ArrayList<Integer>();
        for (int y = 0; y < ydivs.size(); ++y) {
            int yc = ((SegmentColor)ydivs.get((int)y)).color;
            for (int x = 0; x < xdivs.size(); ++x) {
                if (yc == 0) {
                    colors.add(((SegmentColor)xdivs.get((int)x)).color == 0 ? 0 : 1);
                    continue;
                }
                colors.add(((SegmentColor)ydivs.get((int)y)).color == 0 ? 0 : 1);
            }
            if (yc == 0) {
                colors.add((Integer)colors.get(colors.size() - 1) == 1 ? 0 : 1);
                continue;
            }
            colors.add(1);
        }
        for (int i = 0; i < xdivs.size() + 1; ++i) {
            colors.add((Integer)colors.get(i));
        }
        numColors = colors.size();
        int size = 32 + numXDivs * 32 + numYDivs * 32 + numColors * 32;
        chunk = new byte[size];
        chunk[0] = 0;
        chunk[1] = (byte)(0xFF & numXDivs);
        chunk[2] = (byte)(0xFF & numYDivs);
        chunk[3] = (byte)(0xFF & numColors);
        int startOfXData = 32;
        for (int i = 0; i < xdivs.size(); ++i) {
            this.toBytes(chunk, startOfXData + i * 4, ((SegmentColor)xdivs.get((int)i)).index - 1);
        }
        int startOfYData = startOfXData + numXDivs * 4;
        for (int i = 0; i < ydivs.size(); ++i) {
            this.toBytes(chunk, startOfYData + i * 4, ((SegmentColor)ydivs.get((int)i)).index - 1);
        }
        int startOfColors = startOfYData + numYDivs * 4;
        for (int i = 0; i < colors.size(); ++i) {
            this.toBytes(chunk, startOfColors + i * 4, 1);
        }
        return chunk;
    }

    private int toInt(byte[] a, int offset) {
        int i = 0;
        i |= a[offset];
        i |= a[offset + 1] << 8;
        i |= a[offset + 2] << 16;
        return i |= a[offset + 3] << 24;
    }

    private void toBytes(byte[] a, int offset, int v) {
        a[offset] = (byte)(0xFF & v);
        a[offset + 1] = (byte)((0xFF00 & v) >> 8);
        a[offset + 2] = (byte)((0xFF0000 & v) >> 16);
        a[offset + 3] = (byte)((0xFF000000 & v) >> 24);
    }

    class SegmentColor {
        int index;
        int color;

        SegmentColor() {
        }
    }
}

