/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.view.Menu;
import android.view.MenuItem;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.proxy.ActivityProxy;
import org.appcelerator.titanium.proxy.MenuItemProxy;
import org.appcelerator.titanium.proxy.MenuProxy;

public class TiMenuSupport {
    protected MenuProxy menuProxy;
    protected ActivityProxy activityProxy;

    public TiMenuSupport(ActivityProxy activityProxy) {
        this.activityProxy = activityProxy;
    }

    public boolean onCreateOptionsMenu(boolean created, Menu menu) {
        KrollCallback onCreate = (KrollCallback)this.activityProxy.getProperty("onCreateOptionsMenu");
        KrollCallback onPrepare = (KrollCallback)this.activityProxy.getProperty("onPrepareOptionsMenu");
        if (onCreate != null) {
            KrollDict event = new KrollDict();
            if (this.menuProxy != null) {
                if (!this.menuProxy.getMenu().equals(menu)) {
                    this.menuProxy.setMenu(menu);
                }
            } else {
                this.menuProxy = new MenuProxy(this.activityProxy.getTiContext(), menu);
            }
            event.put("menu", this.menuProxy);
            onCreate.callSync(this.activityProxy.getTiContext(), new Object[]{event});
        }
        if (onCreate != null || onPrepare != null) {
            created = true;
        }
        return created;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        MenuItemProxy mip = this.menuProxy.findItem(item);
        if (mip != null) {
            mip.fireEvent("click", null);
            return true;
        }
        return false;
    }

    public boolean onPrepareOptionsMenu(boolean prepared, Menu menu) {
        KrollCallback onPrepare = (KrollCallback)this.activityProxy.getProperty("onPrepareOptionsMenu");
        if (onPrepare != null) {
            KrollDict event = new KrollDict();
            if (this.menuProxy != null) {
                if (!this.menuProxy.getMenu().equals(menu)) {
                    this.menuProxy.setMenu(menu);
                }
            } else {
                this.menuProxy = new MenuProxy(this.activityProxy.getTiContext(), menu);
            }
            event.put("menu", this.menuProxy);
            onPrepare.callSync(this.activityProxy.getTiContext(), new Object[]{event});
        }
        prepared = true;
        return prepared;
    }

    public void destroy() {
        if (this.menuProxy != null) {
            this.menuProxy.release();
            this.menuProxy = null;
        }
        this.activityProxy = null;
    }
}

