/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.location.Criteria;
import android.location.LocationListener;
import android.location.LocationManager;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;

public class TiLocationHelper {
    public static final int ERR_UNKNOWN_ERROR = 0;
    public static final int ERR_PERMISSION_DENIED = 1;
    public static final int ERR_POSITION_UNAVAILABLE = 2;
    public static final int ERR_TIMEOUT = 3;
    public static final int ACCURACY_BEST = 0;
    public static final int ACCURACY_NEAREST_TEN_METERS = 1;
    public static final int ACCURACY_HUNDRED_METERS = 2;
    public static final int ACCURACY_KILOMETER = 3;
    public static final int ACCURACY_THREE_KILOMETERS = 4;
    public static final int DEFAULT_UPDATE_FREQUENCY = 5000;
    public static final float DEFAULT_UPDATE_DISTANCE = 10.0f;
    private static final String LCAT = "TiLocationHelper";
    private static final Boolean DBG = TiConfig.LOGD;
    private static AtomicInteger listenerCount = new AtomicInteger();
    private static LocationManager locationManager;

    public static LocationManager getLocationManager() {
        if (locationManager == null) {
            locationManager = (LocationManager)TiApplication.getInstance().getSystemService("location");
        }
        return locationManager;
    }

    private static int buildUpdateFrequency(Integer frequency) {
        if (frequency != null) {
            return frequency * 1000;
        }
        return 5000;
    }

    private static float buildUpdateDistance(Integer accuracy) {
        float updateDistance = 10.0f;
        if (accuracy != null) {
            switch (accuracy) {
                case 0: {
                    updateDistance = 1.0f;
                    break;
                }
                case 1: {
                    updateDistance = 10.0f;
                    break;
                }
                case 2: {
                    updateDistance = 100.0f;
                    break;
                }
                case 3: {
                    updateDistance = 1000.0f;
                    break;
                }
                case 4: {
                    updateDistance = 3000.0f;
                    break;
                }
                default: {
                    Log.w(LCAT, "Ignoring unknown accuracy value [" + accuracy + "]");
                }
            }
        }
        return updateDistance;
    }

    public static void registerListener(String preferredProvider, Integer accuracy, Integer frequency, LocationListener listener) {
        TiLocationHelper.getLocationManager();
        String provider = TiLocationHelper.fetchProvider(preferredProvider, accuracy);
        if (provider != null) {
            int updateFrequency = TiLocationHelper.buildUpdateFrequency(frequency);
            float updateDistance = TiLocationHelper.buildUpdateDistance(accuracy);
            Log.i(LCAT, "registering listener with provider [" + provider + "], frequency [" + updateFrequency + "], distance [" + updateDistance + "]");
            locationManager.requestLocationUpdates(provider, (long)updateFrequency, updateDistance, listener);
            listenerCount.incrementAndGet();
        } else {
            Log.e(LCAT, "unable to register, provider is null");
        }
    }

    public static void unregisterListener(LocationListener listener) {
        if (locationManager != null) {
            locationManager.removeUpdates(listener);
            if (listenerCount.decrementAndGet() == 0) {
                locationManager = null;
            }
        } else {
            Log.e(LCAT, "unable to unregister, locationManager is null");
        }
    }

    public static void updateProvider(String preferredProvider, Integer accuracy, String provider, Integer frequency, LocationListener listener) {
        if (locationManager != null) {
            String currentProvider = TiLocationHelper.fetchProvider(preferredProvider, accuracy);
            if (!provider.equals(currentProvider)) {
                int updateFrequency = TiLocationHelper.buildUpdateFrequency(frequency);
                float updateDistance = TiLocationHelper.buildUpdateDistance(accuracy);
                Log.i(LCAT, "updating listener with provider [" + currentProvider + "], frequency [" + updateFrequency + "], distance [" + updateDistance + "]");
                locationManager.removeUpdates(listener);
                locationManager.requestLocationUpdates(currentProvider, (long)updateFrequency, updateDistance, listener);
            }
        } else {
            Log.e(LCAT, "unable to update provider, locationManager is null");
        }
    }

    protected static boolean isLocationProviderEnabled(String name) {
        try {
            return TiLocationHelper.getLocationManager().isProviderEnabled(name);
        }
        catch (Exception e) {
            Object var1_2 = null;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isValidProvider(String name) {
        boolean enabled;
        boolean bl = enabled = name.equals("gps") || name.equals("network");
        if (enabled) {
            enabled = false;
            try {
                enabled = TiLocationHelper.isLocationProviderEnabled(name);
            }
            catch (Exception ex) {
                Object var2_3 = null;
            }
            finally {
                if (!enabled) {
                    Log.w(LCAT, "Preferred provider [" + name + "] isn't enabled on this device.  Will default to auto-select of GPS provider.");
                }
            }
        }
        return enabled;
    }

    public static String fetchProvider(String preferredProvider, Integer accuracy) {
        String provider;
        if (preferredProvider != null && TiLocationHelper.isValidProvider(preferredProvider)) {
            provider = preferredProvider;
        } else {
            Criteria criteria = TiLocationHelper.createCriteria(accuracy);
            provider = TiLocationHelper.getLocationManager().getBestProvider(criteria, true);
        }
        return provider;
    }

    protected static Criteria createCriteria(Integer accuracy) {
        Criteria criteria = new Criteria();
        criteria.setAccuracy(0);
        if (accuracy != null) {
            int value = accuracy;
            switch (value) {
                case 0: 
                case 1: 
                case 2: {
                    criteria.setAccuracy(1);
                    criteria.setAltitudeRequired(true);
                    criteria.setBearingRequired(true);
                    criteria.setSpeedRequired(true);
                    break;
                }
                case 3: 
                case 4: {
                    criteria.setAccuracy(2);
                    criteria.setAltitudeRequired(false);
                    criteria.setBearingRequired(false);
                    criteria.setSpeedRequired(false);
                    break;
                }
                default: {
                    Log.w(LCAT, "Ignoring unknown accuracy value [" + value + "]");
                }
            }
        }
        return criteria;
    }

    public static boolean isLocationEnabled() {
        boolean enabled = false;
        List providers = TiLocationHelper.getLocationManager().getProviders(true);
        if (providers != null && providers.size() > 0) {
            if (DBG.booleanValue()) {
                Log.i(LCAT, "Enabled location provider count: " + providers.size());
                for (String name : providers) {
                    Log.i(LCAT, "Location [" + name + "] service available");
                }
            }
            enabled = true;
        } else {
            Log.i(LCAT, "No available providers");
        }
        return enabled;
    }
}

