/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.os.Process;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiFastDev;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiUIHelper;

public class TiJSErrorDialog {
    private static final String TAG = "TiJSError";
    private static LinkedList<ErrorMessage> errorMessages = new LinkedList();
    private static boolean dialogShowing = false;

    public static void printError(String title, String message, String sourceName, int line, String lineSource, int lineOffset) {
        Log.e(TAG, "----- Titanium Javascript " + title + " -----");
        Log.e(TAG, "- In " + sourceName + ":" + line + "," + lineOffset);
        Log.e(TAG, "- Message: " + message);
        Log.e(TAG, "- Source: " + lineSource);
    }

    public static void openErrorDialog(TiContext tiContext, Activity activity, String title, String message, String sourceName, int line, String lineSource, int lineOffset) {
        TiJSErrorDialog.printError(title, message, sourceName, line, lineSource, lineOffset);
        if (activity == null || activity.isFinishing()) {
            Log.w(TAG, "Activity is null or already finishing, skipping dialog.");
            return;
        }
        ErrorMessage error = new ErrorMessage();
        error.tiContext = new WeakReference<TiContext>(tiContext);
        error.title = title;
        error.message = message;
        error.sourceName = sourceName;
        error.line = line;
        error.lineSource = lineSource;
        error.lineOffset = lineOffset;
        if (!dialogShowing) {
            dialogShowing = true;
            final ErrorMessage fError = error;
            TiUIHelper.waitForCurrentActivity(new TiUIHelper.CurrentActivityListener(){

                @Override
                public void onCurrentActivityReady(Activity activity) {
                    TiJSErrorDialog.createDialog(fError);
                }
            });
        } else {
            errorMessages.add(error);
        }
    }

    protected static void createDialog(final ErrorMessage error) {
        Activity context = TiApplication.getInstance().getCurrentActivity();
        FrameLayout layout = new FrameLayout((Context)context);
        layout.setBackgroundColor(Color.rgb((int)128, (int)0, (int)0));
        LinearLayout vlayout = new LinearLayout((Context)context);
        vlayout.setOrientation(1);
        vlayout.setPadding(10, 10, 10, 10);
        layout.addView((View)vlayout);
        TextView sourceInfoView = new TextView((Context)context);
        sourceInfoView.setBackgroundColor(-1);
        sourceInfoView.setTextColor(-16777216);
        sourceInfoView.setPadding(4, 5, 4, 0);
        sourceInfoView.setText((CharSequence)("[" + error.line + "," + error.lineOffset + "] " + error.sourceName));
        TextView messageView = new TextView((Context)context);
        messageView.setBackgroundColor(-1);
        messageView.setTextColor(-16777216);
        messageView.setPadding(4, 5, 4, 0);
        messageView.setText((CharSequence)error.message);
        TextView sourceView = new TextView((Context)context);
        sourceView.setBackgroundColor(-1);
        sourceView.setTextColor(-16777216);
        sourceView.setPadding(4, 5, 4, 0);
        sourceView.setText((CharSequence)error.lineSource);
        TextView infoLabel = new TextView((Context)context);
        infoLabel.setText((CharSequence)"Location: ");
        infoLabel.setTextColor(-1);
        infoLabel.setTextScaleX(1.5f);
        TextView messageLabel = new TextView((Context)context);
        messageLabel.setText((CharSequence)"Message: ");
        messageLabel.setTextColor(-1);
        messageLabel.setTextScaleX(1.5f);
        TextView sourceLabel = new TextView((Context)context);
        sourceLabel.setText((CharSequence)"Source: ");
        sourceLabel.setTextColor(-1);
        sourceLabel.setTextScaleX(1.5f);
        vlayout.addView((View)infoLabel);
        vlayout.addView((View)sourceInfoView);
        vlayout.addView((View)messageLabel);
        vlayout.addView((View)messageView);
        vlayout.addView((View)sourceLabel);
        vlayout.addView((View)sourceView);
        DialogInterface.OnClickListener clickListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (which == -1) {
                    Process.killProcess((int)Process.myPid());
                } else if (which != -3 && which == -2 && error.tiContext != null && error.tiContext.get() != null) {
                    TiJSErrorDialog.reload((TiContext)error.tiContext.get(), error.sourceName);
                }
                if (!errorMessages.isEmpty()) {
                    TiJSErrorDialog.createDialog((ErrorMessage)errorMessages.removeFirst());
                } else {
                    dialogShowing = false;
                }
            }
        };
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)context).setTitle((CharSequence)error.title).setView((View)layout).setPositiveButton((CharSequence)"Kill", clickListener).setNeutralButton((CharSequence)"Continue", clickListener).setCancelable(false);
        if (TiFastDev.isFastDevEnabled()) {
            builder.setNegativeButton((CharSequence)"Reload", clickListener);
        }
        builder.create().show();
    }

    protected static void reload(TiContext tiContext, String sourceName) {
        try {
            tiContext.evalFile(sourceName);
        }
        catch (IOException e) {
            Log.e(TAG, e.getMessage(), e);
        }
    }

    private static class ErrorMessage {
        WeakReference<TiContext> tiContext;
        String title;
        String message;
        String sourceName;
        String lineSource;
        int line;
        int lineOffset;

        private ErrorMessage() {
        }
    }
}

