/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Environment;
import android.webkit.URLUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiNinePatchHelper;
import org.appcelerator.titanium.util.TiResponseCache;
import org.appcelerator.titanium.util.TiUIHelper;

public class TiFileHelper {
    private static final String LCAT = "TiFileHlpr";
    private static final boolean DBG = TiConfig.LOGD;
    public static final String TI_DIR = "tiapp";
    public static final String TI_DIR_JS = "tijs";
    private static final String MACOSX_PREFIX = "__MACOSX";
    private static final String TI_RESOURCE_PREFIX = "ti:";
    public static final String RESOURCE_ROOT_ASSETS = "file:///android_asset/Resources";
    public static final String SD_CARD_PREFIX = "/sdcard/Ti.debug";
    static HashMap<String, Integer> systemIcons;
    private SoftReference<Context> softContext;
    private TiNinePatchHelper nph;
    private static HashSet<String> resourcePathCache;
    private static HashSet<String> foundResourcePathCache;
    private static HashSet<String> notFoundResourcePathCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TiFileHelper(Context context) {
        this.softContext = new SoftReference<Context>(context);
        this.nph = new TiNinePatchHelper();
        if (resourcePathCache == null) {
            resourcePathCache = new HashSet();
            foundResourcePathCache = new HashSet();
            notFoundResourcePathCache = new HashSet();
        }
        if (resourcePathCache == null) {
            resourcePathCache = new HashSet();
            foundResourcePathCache = new HashSet();
            notFoundResourcePathCache = new HashSet();
        }
        String string = TI_DIR;
        synchronized (TI_DIR) {
            if (systemIcons == null) {
                systemIcons = new HashMap();
                systemIcons.put("ic_menu_camera", 17301559);
                systemIcons.put("ic_menu_search", 17301583);
                systemIcons.put("ic_menu_add", 17301555);
                systemIcons.put("ic_menu_delete", 17301564);
                systemIcons.put("ic_media_play", 17301540);
                systemIcons.put("ic_media_ff", 17301537);
                systemIcons.put("ic_media_pause", 17301539);
                systemIcons.put("ic_media_rew", 17301542);
                systemIcons.put("ic_menu_edit", 17301566);
                systemIcons.put("ic_menu_close_clear_cancel", 17301560);
                systemIcons.put("ic_menu_save", 17301582);
                systemIcons.put("ic_menu_help", 17301568);
                systemIcons.put("ic_media_next", 17301538);
                systemIcons.put("ic_menu_preferences", 17301577);
                systemIcons.put("ic_media_previous", 17301541);
                systemIcons.put("ic_menu_revert", 17301580);
                systemIcons.put("ic_menu_send", 17301584);
                systemIcons.put("ic_menu_share", 17301586);
                systemIcons.put("ic_menu_view", 17301591);
                systemIcons.put("ic_menu_zoom", 17301593);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openInputStream(String path, boolean report) throws IOException {
        InputStream is = null;
        Context context = this.softContext.get();
        if (context != null) {
            if (this.isTitaniumResource(path)) {
                String[] parts = path.split(":");
                if (parts.length != 3) {
                    Log.w(LCAT, "malformed titanium resource url, resource not loaded: " + path);
                    return null;
                }
                String titanium = parts[0];
                String section = parts[1];
                String resid = parts[2];
                if (TI_RESOURCE_PREFIX.equals(section)) {
                    is = TiFileHelper.class.getResourceAsStream("/org/appcelerator/titanium/res/drawable/" + resid + ".png");
                } else if ("Sys".equals(section)) {
                    Integer id = systemIcons.get(resid);
                    if (id != null) {
                        is = Resources.getSystem().openRawResource(id.intValue());
                    } else {
                        Log.w(LCAT, "Drawable not found for system id: " + path);
                    }
                } else {
                    Log.e(LCAT, "Unknown section identifier: " + section);
                }
            } else {
                if (URLUtil.isNetworkUrl((String)path)) {
                    try {
                        URI uri = new URI(path);
                        if (TiResponseCache.peek(uri)) {
                            return TiResponseCache.openCachedStream(uri);
                        }
                    }
                    catch (URISyntaxException uriException) {
                        // empty catch block
                    }
                    URL u = new URL(path);
                    InputStream lis = u.openStream();
                    ByteArrayOutputStream bos = null;
                    try {
                        bos = new ByteArrayOutputStream(8192);
                        int count = 0;
                        byte[] buf = new byte[8192];
                        while ((count = lis.read(buf)) != -1) {
                            bos.write(buf, 0, count);
                        }
                        is = new ByteArrayInputStream(bos.toByteArray());
                    }
                    catch (IOException e) {
                        Log.e(LCAT, "Problem pulling image data from " + path, e);
                        throw e;
                    }
                    finally {
                        if (lis != null) {
                            try {
                                lis.close();
                                lis = null;
                            }
                            catch (Exception e) {}
                        }
                        if (bos != null) {
                            try {
                                bos.close();
                                bos = null;
                            }
                            catch (Exception e) {}
                        }
                    }
                }
                if (path.startsWith(RESOURCE_ROOT_ASSETS)) {
                    int len = "file:///android_asset/".length();
                    path = path.substring(len);
                    boolean found = false;
                    if (foundResourcePathCache.contains(path)) {
                        found = true;
                    } else if (!notFoundResourcePathCache.contains(path)) {
                        String base = path.substring(0, path.lastIndexOf("/"));
                        HashSet<String> hashSet = resourcePathCache;
                        synchronized (hashSet) {
                            if (!resourcePathCache.contains(base)) {
                                String[] paths = context.getAssets().list(base);
                                for (int i = 0; i < paths.length; ++i) {
                                    foundResourcePathCache.add(base + '/' + paths[i]);
                                }
                                resourcePathCache.add(base);
                                if (foundResourcePathCache.contains(path)) {
                                    found = true;
                                }
                            }
                            if (!found) {
                                notFoundResourcePathCache.add(path);
                            }
                        }
                    }
                    if (found) {
                        is = context.getAssets().open(path);
                    }
                } else if (path.startsWith(SD_CARD_PREFIX)) {
                    is = new FileInputStream(new File(path));
                } else if (URLUtil.isFileUrl((String)path)) {
                    URL u = new URL(path);
                    is = u.openStream();
                } else {
                    path = this.joinPaths("Resources", path);
                    is = context.getAssets().open(path);
                }
            }
        }
        return is;
    }

    private Drawable loadDrawable(String path, boolean report) {
        return this.loadDrawable(path, report, false);
    }

    public Drawable loadDrawable(TiContext tiContext, String path, boolean report) {
        return this.loadDrawable(tiContext, path, report, false);
    }

    public Drawable loadDrawable(TiContext context, String path, boolean report, boolean checkForNinePatch) {
        Drawable d;
        if (context == null) {
            return this.loadDrawable(path, report, checkForNinePatch);
        }
        String url = path;
        if (!url.startsWith("file:")) {
            url = context.resolveUrl(path);
        }
        if ((d = TiUIHelper.getResourceDrawable(context, url)) != null) {
            return d;
        }
        return this.loadDrawable(url, report, checkForNinePatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Drawable loadDrawable(String path, boolean report, boolean checkForNinePatch) {
        BitmapDrawable d;
        block21: {
            d = null;
            InputStream is = null;
            try {
                if (checkForNinePatch && path != null && !URLUtil.isNetworkUrl((String)path)) {
                    block20: {
                        if (path.endsWith(".png") && !path.endsWith(".9.png")) {
                            String apath = null;
                            apath = path.substring(0, path.lastIndexOf(".")) + ".9.png";
                            try {
                                is = this.openInputStream(apath, false);
                                if (is != null) {
                                    path = apath;
                                }
                            }
                            catch (IOException e) {
                                if (!DBG) break block20;
                                Log.d(LCAT, "path not found: " + apath);
                            }
                        }
                    }
                    if (is == null) {
                        is = this.openInputStream(path, report);
                    }
                    Bitmap b = TiUIHelper.createBitmap(is);
                    d = this.nph.process(b);
                    break block21;
                }
                is = this.openInputStream(path, report);
                Bitmap b = TiUIHelper.createBitmap(is);
                if (b != null) {
                    d = new BitmapDrawable(b);
                }
            }
            catch (IOException e) {
                Context context;
                Log.i(LCAT, path + " not found.");
                if (report && (context = this.softContext.get().getApplicationContext()) != null) {
                    // empty if block
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return d;
    }

    public boolean isTitaniumResource(String s) {
        boolean result = false;
        if (s != null && s.startsWith(TI_RESOURCE_PREFIX)) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getTitaniumResource(Context context, String s) {
        Drawable d = null;
        if (this.isTitaniumResource(s)) {
            String[] parts = s.split(":");
            if (parts.length != 2) {
                Log.w(LCAT, "malformed titanium resource url, resource not loaded: " + s);
                return null;
            }
            String section = parts[0];
            String resid = parts[1];
            if (TI_RESOURCE_PREFIX.equals(section)) {
                InputStream is = null;
                try {
                    is = TiFileHelper.class.getResourceAsStream("/org/appcelerator/titanium/res/drawable/" + resid + ".png");
                    d = new BitmapDrawable(is);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            if ("Sys".equals(section)) {
                Integer id = systemIcons.get(resid);
                if (id != null) {
                    d = Resources.getSystem().getDrawable(id.intValue());
                } else {
                    Log.w(LCAT, "Drawable not found for system id: " + s);
                }
            } else {
                Log.e(LCAT, "Unknown section identifier: " + section);
            }
        } else {
            Log.w(LCAT, "Ignoring non titanium resource string id: " + s);
        }
        return d;
    }

    public String getResourceUrl(String path) {
        return this.joinPaths(RESOURCE_ROOT_ASSETS, path);
    }

    public String joinPaths(String pre, String post) {
        StringBuilder sb = new StringBuilder();
        sb.append(pre);
        if (pre.endsWith("/") && !post.startsWith("/")) {
            sb.append(post);
        } else if (!pre.endsWith("/") && post.startsWith("/")) {
            sb.append(post);
        } else if (!pre.endsWith("/") && !post.startsWith("/")) {
            sb.append("/").append(post);
        } else {
            sb.append(post.substring(1));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployFromAssets(File dest) throws IOException {
        Context ctx = this.softContext.get();
        if (ctx != null) {
            ArrayList<String> paths = new ArrayList<String>();
            AssetManager am = ctx.getAssets();
            this.walkAssets(am, "", paths);
            this.wipeDirectoryTree(dest);
            BufferedInputStream bis = null;
            FileOutputStream fos = null;
            byte[] buf = new byte[8096];
            try {
                int len = paths.size();
                for (int i = 0; i < len; ++i) {
                    String path = paths.get(i);
                    File f = new File(path);
                    if (f.getName().indexOf(".") > -1) {
                        bis = new BufferedInputStream(am.open(path), 8096);
                        File df = new File(dest, path);
                        if (DBG) {
                            Log.d(LCAT, "Copying to: " + df.getAbsolutePath());
                        }
                        fos = new FileOutputStream(df);
                        int read = 0;
                        while ((read = bis.read(buf)) != -1) {
                            fos.write(buf, 0, read);
                        }
                        bis.close();
                        bis = null;
                        fos.close();
                        fos = null;
                        continue;
                    }
                    File d = new File(dest, path);
                    Log.d(LCAT, "Creating directory: " + d.getAbsolutePath());
                    d.mkdirs();
                }
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {}
                    bis = null;
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                    fos = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployFromZip(File fname, File dest) throws IOException {
        this.wipeDirectoryTree(dest);
        ZipInputStream zis = null;
        ZipEntry ze = null;
        byte[] buf = new byte[8096];
        try {
            zis = this.getZipInputStream(new FileInputStream(fname));
            String root = this.getRootDir(zis);
            int rootLen = root.length();
            zis.close();
            if (DBG) {
                Log.d(LCAT, "Zip file root: " + root);
            }
            zis = this.getZipInputStream(new FileInputStream(fname));
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                if (name.startsWith(MACOSX_PREFIX)) {
                    zis.closeEntry();
                    continue;
                }
                if ((name = name.substring(rootLen)).length() > 0) {
                    if (DBG) {
                        Log.d(LCAT, "Extracting " + name);
                    }
                    if (ze.isDirectory()) {
                        File d = new File(dest, name);
                        d.mkdirs();
                        if (DBG) {
                            Log.d(LCAT, "Created directory " + d.toString());
                        }
                        d = null;
                    } else {
                        FileOutputStream fos = null;
                        try {
                            fos = new FileOutputStream(new File(dest, name));
                            int read = 0;
                            while ((read = zis.read(buf)) != -1) {
                                fos.write(buf, 0, read);
                            }
                        }
                        finally {
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable t) {}
                            }
                        }
                    }
                }
                zis.closeEntry();
            }
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public void wipeDirectoryTree(File path) {
        TreeSet<String> dirs = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2) * -1;
            }
        });
        this.wipeDirectoryTree(path, dirs);
        for (String fn : dirs) {
            File f = new File(fn);
            if (DBG) {
                Log.d(LCAT, "Deleting Dir: " + f.getAbsolutePath());
            }
            f.delete();
        }
    }

    public File getTempFile(String suffix) throws IOException {
        File result = null;
        Context context = this.softContext.get();
        if (context != null) {
            result = this.getTempFile(context.getCacheDir(), suffix);
        }
        return result;
    }

    public File getTempFile(File dir, String suffix) throws IOException {
        File result = null;
        Context context = this.softContext.get();
        if (context != null) {
            if (!dir.exists()) {
                Log.w(LCAT, "getTempFile: Directory '" + dir.getAbsolutePath() + "' does not exist. Call to File.createTempFile() will fail.");
            }
            result = File.createTempFile("tia", suffix, dir);
        }
        return result;
    }

    public File getDataDirectory(boolean privateStorage) {
        File f = null;
        Context context = this.softContext.get();
        if (context != null) {
            if (privateStorage) {
                f = context.getDir("appdata", 0);
            } else {
                File storageDir = Environment.getExternalStorageDirectory();
                f = new File(storageDir, context.getPackageName());
                if (!f.exists()) {
                    f.mkdirs();
                }
            }
        }
        return f;
    }

    private void wipeDirectoryTree(File path, SortedSet<String> dirs) {
        File[] files = path.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    dirs.add(f.getAbsolutePath());
                    this.wipeDirectoryTree(f, dirs);
                    continue;
                }
                if (DBG) {
                    Log.d(LCAT, "Deleting File: " + f.getAbsolutePath());
                }
                f.delete();
            }
        }
    }

    private void walkAssets(AssetManager am, String path, ArrayList<String> paths) throws IOException {
        String[] files;
        if (this.titaniumPath(path) && (files = am.list(path)).length > 0) {
            for (int i = 0; i < files.length; ++i) {
                String newPath = files[i];
                String todo = path;
                todo = path.length() > 0 ? todo + "/" + newPath : newPath;
                if (!this.titaniumPath(todo)) continue;
                paths.add(todo);
                this.walkAssets(am, todo, paths);
            }
        }
    }

    private boolean titaniumPath(String path) {
        return path == "" || path.equals("tiapp.xml") || path.startsWith("Resources");
    }

    private ZipInputStream getZipInputStream(InputStream is) throws FileNotFoundException, IOException {
        return new ZipInputStream(is);
    }

    private String getRootDir(ZipInputStream zis) throws FileNotFoundException, IOException {
        String root = "";
        ZipEntry ze = null;
        while ((ze = zis.getNextEntry()) != null) {
            String name = ze.getName();
            zis.closeEntry();
            if (name.startsWith(MACOSX_PREFIX) || name.indexOf("tiapp.xml") <= -1) continue;
            String[] segments = name.split("\\/");
            if (segments.length == 2) {
                root = segments[0] + "/";
                break;
            }
            if (segments.length != 1) continue;
            break;
        }
        return root;
    }
}

