/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.os.Handler;
import android.os.Message;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.codec.digest.DigestUtils;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiDownloadListener;
import org.appcelerator.titanium.util.TiResponseCache;
import org.appcelerator.titanium.util.TiStreamHelper;

public class TiDownloadManager
implements Handler.Callback {
    private static final String TAG = "TiDownloadManager";
    private static final int MSG_FIRE_DOWNLOAD_FINISHED = 1000;
    protected static TiDownloadManager _instance;
    public static final int THREAD_POOL_SIZE = 2;
    protected HashMap<String, ArrayList<SoftReference<TiDownloadListener>>> listeners = new HashMap();
    protected ArrayList<String> downloadingURIs = new ArrayList();
    protected ExecutorService threadPool;
    protected Handler handler = new Handler((Handler.Callback)this);

    public static TiDownloadManager getInstance() {
        if (_instance == null) {
            _instance = new TiDownloadManager();
        }
        return _instance;
    }

    protected TiDownloadManager() {
        this.threadPool = Executors.newFixedThreadPool(2);
    }

    public void download(URI uri, TiDownloadListener listener) {
        if (TiResponseCache.peek(uri)) {
            this.fireDownloadFinished(uri);
        } else {
            this.startDownload(uri, listener);
        }
    }

    protected void fireDownloadFinished(URI uri) {
        Message msg = this.handler.obtainMessage(1000);
        msg.obj = uri;
        msg.sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startDownload(URI uri, TiDownloadListener listener) {
        String hash = DigestUtils.shaHex((String)uri.toString());
        ArrayList<Object> listenerList = null;
        Cloneable cloneable = this.listeners;
        synchronized (cloneable) {
            if (!this.listeners.containsKey(hash)) {
                listenerList = new ArrayList();
                this.listeners.put(hash, listenerList);
            } else {
                listenerList = this.listeners.get(hash);
            }
            for (SoftReference softReference : listenerList) {
                if (softReference.get() != listener) continue;
                return;
            }
            listenerList.add(new SoftReference<TiDownloadListener>(listener));
        }
        cloneable = this.downloadingURIs;
        synchronized (cloneable) {
            if (!this.downloadingURIs.contains(hash)) {
                this.downloadingURIs.add(hash);
                this.threadPool.execute(new DownloadJob(uri));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFireDownloadFinished(URI uri) {
        ArrayList<SoftReference<TiDownloadListener>> toRemove = new ArrayList<SoftReference<TiDownloadListener>>();
        HashMap<String, ArrayList<SoftReference<TiDownloadListener>>> hashMap = this.listeners;
        synchronized (hashMap) {
            String hash = DigestUtils.shaHex((String)uri.toString());
            for (SoftReference<TiDownloadListener> listener : this.listeners.get(hash)) {
                if (listener.get() == null) continue;
                this.fireDownloadFinished(uri, listener.get());
                toRemove.add(listener);
            }
            for (SoftReference<TiDownloadListener> listener : toRemove) {
                this.listeners.get(hash).remove(listener);
            }
        }
    }

    protected void fireDownloadFinished(URI uri, TiDownloadListener listener) {
        if (listener != null) {
            listener.downloadFinished(uri);
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1000: {
                this.handleFireDownloadFinished((URI)msg.obj);
                return true;
            }
        }
        return false;
    }

    protected class DownloadJob
    implements Runnable {
        protected URI uri;

        public DownloadJob(URI uri) {
            this.uri = uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                InputStream stream = this.uri.toURL().openStream();
                TiStreamHelper.pump(stream, null);
                stream.close();
                ArrayList<String> arrayList = TiDownloadManager.this.downloadingURIs;
                synchronized (arrayList) {
                    TiDownloadManager.this.downloadingURIs.remove(DigestUtils.shaHex((String)this.uri.toString()));
                }
                TiDownloadManager.this.fireDownloadFinished(this.uri);
            }
            catch (Exception e) {
                Log.e(TiDownloadManager.TAG, "Exception downloading " + this.uri, e);
            }
        }
    }
}

