/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;

public class TiDatabaseHelper
extends SQLiteOpenHelper {
    private static final String LCAT = "TiDbHelper";
    private static final boolean DBG = TiConfig.LOGD;
    private static final String name = "Titanium";
    private static final int version = 1;

    public TiDatabaseHelper(Context context) {
        super(context, name, null, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlatformParam(String key, String value) {
        String platformSQL = "insert into platform values (?,?)";
        SQLiteDatabase db = this.getWritableDatabase();
        try {
            SQLiteStatement platformInsertStatement = db.compileStatement(platformSQL);
            platformInsertStatement.bindString(1, key);
            platformInsertStatement.bindString(2, value);
            platformInsertStatement.executeInsert();
            platformInsertStatement.close();
        }
        finally {
            db.close();
        }
    }

    public void updatePlatformParam(String key, String value) {
        this.deletePlatformParam(key);
        this.setPlatformParam(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePlatformParam(String key) {
        String platformSQL = "delete from platform where name = ?";
        SQLiteDatabase db = this.getWritableDatabase();
        try {
            SQLiteStatement platformInsertStatement = db.compileStatement(platformSQL);
            platformInsertStatement.bindString(1, key);
            platformInsertStatement.executeInsert();
            platformInsertStatement.close();
        }
        finally {
            db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlatformParam(String key, String def) {
        String platformSQL = "select value from platform where name = ?";
        SQLiteDatabase db = this.getReadableDatabase();
        try {
            SQLiteStatement platformSelectStatement = db.compileStatement(platformSQL);
            platformSelectStatement.bindString(1, key);
            String result = platformSelectStatement.simpleQueryForString();
            platformSelectStatement.close();
            if (result == null) {
                String string = def;
                return string;
            }
            String string = result;
            return string;
        }
        catch (SQLiteDoneException e) {
            Log.i(LCAT, "No value in database for platform key: '" + key + "' returning supplied default '" + def + "'");
        }
        catch (Exception e) {
            Log.e(LCAT, "Problem retrieving data from platform: ", e);
        }
        finally {
            db.close();
        }
        return def;
    }

    public void onCreate(SQLiteDatabase db) {
        String platformSQL = "create table platform(name TEXT,value TEXT)";
        db.execSQL(platformSQL);
    }

    public void onOpen(SQLiteDatabase db) {
    }

    public void onUpgrade(SQLiteDatabase db, int from, int to) {
    }
}

