/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollObject;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiDimension;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiColorHelper;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.view.Ti2DMatrix;
import org.appcelerator.titanium.view.TiCompositeLayout;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.javascript.Function;

public class TiConvert {
    private static final String LCAT = "TiConvert";
    private static final boolean DBG = TiConfig.LOGD;
    public static final String ASSET_URL = "file:///android_asset/";
    public static final String JSON_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public static Object putInKrollDict(KrollDict d, String key, Object value) {
        if (value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Date) {
            d.put(key, value);
        } else if (value instanceof KrollDict) {
            KrollDict nd = new KrollDict();
            KrollDict dict = (KrollDict)value;
            for (String k : dict.keySet()) {
                TiConvert.putInKrollDict(nd, k, dict.get(k));
            }
            d.put(key, nd);
            value = nd;
        } else if (value instanceof Object[]) {
            Object[] a = (Object[])value;
            int len = a.length;
            if (len > 0) {
                Object v = a[0];
                if (DBG) {
                    if (v != null) {
                        Log.w(LCAT, "Array member is type: " + v.getClass().getSimpleName());
                    } else {
                        Log.w(LCAT, "First member of array is null");
                    }
                }
                if (v != null && v instanceof String) {
                    String[] sa = new String[len];
                    for (int i = 0; i < len; ++i) {
                        sa[i] = (String)a[i];
                    }
                    d.put(key, sa);
                } else if (v != null && v instanceof Double) {
                    double[] da = new double[len];
                    for (int i = 0; i < len; ++i) {
                        da[i] = (Double)a[i];
                    }
                    d.put(key, da);
                } else if (v != null && v instanceof KrollObject) {
                    KrollProxy[] pa = new KrollProxy[len];
                    for (int i = 0; i < len; ++i) {
                        KrollObject ko = (KrollObject)((Object)a[i]);
                        pa[i] = ko.getProxy();
                    }
                    d.put(key, pa);
                } else {
                    Object[] oa = new Object[len];
                    for (int i = 0; i < len; ++i) {
                        oa[i] = a[i];
                    }
                    d.put(key, oa);
                }
            } else {
                d.put(key, (Object[])value);
            }
        } else if (value == null) {
            d.put(key, null);
        } else if (value instanceof KrollProxy) {
            d.put(key, value);
        } else if (value instanceof KrollCallback || value instanceof Function) {
            d.put(key, value);
        } else if (value instanceof Map) {
            KrollDict dict = new KrollDict();
            Map map = (Map)value;
            for (String k : map.keySet()) {
                TiConvert.putInKrollDict(dict, k, map.get(k));
            }
            d.put(key, dict);
        } else {
            throw new IllegalArgumentException("Unsupported property type " + value.getClass().getName());
        }
        return value;
    }

    public static int toColor(String value) {
        return TiColorHelper.parseColor(value);
    }

    public static int toColor(KrollDict d, String key) {
        return TiConvert.toColor(d.getString(key));
    }

    public static ColorDrawable toColorDrawable(String value) {
        return new ColorDrawable(TiConvert.toColor(value));
    }

    public static ColorDrawable toColorDrawable(KrollDict d, String key) {
        return TiConvert.toColorDrawable(d.getString(key));
    }

    public static boolean fillLayout(KrollDict d, TiCompositeLayout.LayoutParams layoutParams) {
        boolean dirty = false;
        Object width = null;
        Object height = null;
        if (d.containsKey("size")) {
            KrollDict size = (KrollDict)d.get("size");
            width = size.get("width");
            height = size.get("height");
        }
        if (d.containsKey("left")) {
            layoutParams.optionLeft = TiConvert.toTiDimension(d, "left", 0);
            dirty = true;
        }
        if (d.containsKey("top")) {
            layoutParams.optionTop = TiConvert.toTiDimension(d, "top", 3);
            dirty = true;
        }
        if (d.containsKey("center")) {
            TiConvert.updateLayoutCenter(d.get("center"), layoutParams);
            dirty = true;
        }
        if (d.containsKey("right")) {
            layoutParams.optionRight = TiConvert.toTiDimension(d, "right", 2);
            dirty = true;
        }
        if (d.containsKey("bottom")) {
            layoutParams.optionBottom = TiConvert.toTiDimension(d, "bottom", 5);
            dirty = true;
        }
        if (width != null || d.containsKey("width")) {
            if (width == null) {
                width = d.get("width");
            }
            if (width == null || width.equals("auto")) {
                layoutParams.optionWidth = null;
                layoutParams.autoWidth = true;
            } else {
                layoutParams.optionWidth = TiConvert.toTiDimension(width, 6);
                layoutParams.autoWidth = false;
            }
            dirty = true;
        }
        if (height != null || d.containsKey("height")) {
            if (height == null) {
                height = d.get("height");
            }
            if (height == null || height.equals("auto")) {
                layoutParams.optionHeight = null;
                layoutParams.autoHeight = true;
            } else {
                layoutParams.optionHeight = TiConvert.toTiDimension(height, 7);
                layoutParams.autoHeight = false;
            }
            dirty = true;
        }
        if (d.containsKey("zIndex")) {
            Object zIndex = d.get("zIndex");
            layoutParams.optionZIndex = zIndex != null ? TiConvert.toInt(zIndex) : 0;
            dirty = true;
        }
        if (d.containsKey("transform")) {
            layoutParams.optionTransform = (Ti2DMatrix)d.get("transform");
        }
        return dirty;
    }

    public static void updateLayoutCenter(Object value, TiCompositeLayout.LayoutParams layoutParams) {
        if (value instanceof KrollDict) {
            KrollDict center = (KrollDict)value;
            layoutParams.optionCenterX = center.containsKeyAndNotNull("x") ? TiConvert.toTiDimension(center, "x", 1) : null;
            layoutParams.optionCenterY = center.containsKeyAndNotNull("y") ? TiConvert.toTiDimension(center, "y", 4) : null;
        } else if (value != null) {
            layoutParams.optionCenterX = TiConvert.toTiDimension(value, 1);
            layoutParams.optionCenterY = null;
        } else {
            layoutParams.optionCenterX = null;
            layoutParams.optionCenterY = null;
        }
    }

    public static boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new IllegalArgumentException("Unable to convert " + (value == null ? "null" : value.getClass().getName()) + " to boolean.");
    }

    public static boolean toBoolean(KrollDict d, String key) {
        return TiConvert.toBoolean(d.get(key));
    }

    public static int toInt(Object value) {
        if (value instanceof Double) {
            return ((Double)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new NumberFormatException("Unable to convert " + value.getClass().getName());
    }

    public static int toInt(KrollDict d, String key) {
        return TiConvert.toInt(d.get(key));
    }

    public static float toFloat(Object value) {
        if (value instanceof Double) {
            return ((Double)value).floatValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).floatValue();
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        throw new NumberFormatException("Unable to convert " + value.getClass().getName());
    }

    public static float toFloat(KrollDict d, String key) {
        return TiConvert.toFloat(d.get(key));
    }

    public static double toDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new NumberFormatException("Unable to convert " + value.getClass().getName());
    }

    public static double toDouble(KrollDict d, String key) {
        return TiConvert.toDouble(d.get(key));
    }

    public static String toString(Object value) {
        return value == null ? null : value.toString();
    }

    public static String toString(KrollDict d, String key) {
        return TiConvert.toString(d.get(key));
    }

    public static String[] toStringArray(Object[] parts) {
        String[] sparts;
        String[] stringArray = sparts = parts != null ? new String[parts.length] : new String[]{};
        if (parts != null) {
            for (int i = 0; i < parts.length; ++i) {
                sparts[i] = parts[i] == null ? null : parts[i].toString();
            }
        }
        return sparts;
    }

    public static TiDimension toTiDimension(String value, int valueType) {
        return new TiDimension(value, valueType);
    }

    public static TiDimension toTiDimension(Object value, int valueType) {
        if (value instanceof Number) {
            value = value.toString() + "px";
        }
        return TiConvert.toTiDimension((String)value, valueType);
    }

    public static TiDimension toTiDimension(KrollDict d, String key, int valueType) {
        return TiConvert.toTiDimension(d.get(key), valueType);
    }

    public static String toURL(Uri uri) {
        String url = null;
        url = uri.isRelative() ? ((url = uri.toString()).startsWith("/") ? "file:///android_asset/Resources" + url.substring(1) : "file:///android_asset/Resources/" + url) : uri.toString();
        return url;
    }

    public static KrollDict toErrorObject(int code, String msg) {
        KrollDict d = new KrollDict(1);
        KrollDict e = new KrollDict();
        e.put("code", code);
        e.put("message", msg);
        d.put("error", e);
        return d;
    }

    public static TiBlob toBlob(Object value) {
        return (TiBlob)value;
    }

    public static TiBlob toBlob(KrollDict object, String property2) {
        return TiConvert.toBlob(object.get(property2));
    }

    public static JSONObject toJSON(KrollDict data) {
        if (data == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        for (String key : data.keySet()) {
            try {
                Object o = data.get(key);
                if (o == null) {
                    json.put(key, JSONObject.NULL);
                    continue;
                }
                if (o instanceof Number) {
                    json.put(key, (Object)((Number)o));
                    continue;
                }
                if (o instanceof String) {
                    json.put(key, (Object)((String)o));
                    continue;
                }
                if (o instanceof Boolean) {
                    json.put(key, (Object)((Boolean)o));
                    continue;
                }
                if (o instanceof Date) {
                    json.put(key, (Object)TiConvert.toJSONString((Date)o));
                    continue;
                }
                if (o instanceof KrollDict) {
                    json.put(key, (Object)TiConvert.toJSON((KrollDict)o));
                    continue;
                }
                if (o.getClass().isArray()) {
                    json.put(key, (Object)TiConvert.toJSONArray((Object[])o));
                    continue;
                }
                Log.w(LCAT, "Unsupported type " + o.getClass());
            }
            catch (JSONException e) {
                Log.w(LCAT, "Unable to JSON encode key: " + key);
            }
        }
        return json;
    }

    public static JSONArray toJSONArray(Object[] a) {
        JSONArray ja = new JSONArray();
        for (Object o : a) {
            if (o == null) {
                if (!DBG) continue;
                Log.w(LCAT, "Skipping null value in array");
                continue;
            }
            if (o == null) {
                ja.put(JSONObject.NULL);
                continue;
            }
            if (o instanceof Number) {
                ja.put((Object)((Number)o));
                continue;
            }
            if (o instanceof String) {
                ja.put((Object)((String)o));
                continue;
            }
            if (o instanceof Boolean) {
                ja.put((Object)((Boolean)o));
                continue;
            }
            if (o instanceof Date) {
                ja.put((Object)TiConvert.toJSONString((Date)o));
                continue;
            }
            if (o instanceof KrollDict) {
                ja.put((Object)TiConvert.toJSON((KrollDict)o));
                continue;
            }
            if (o.getClass().isArray()) {
                ja.put((Object)TiConvert.toJSONArray((Object[])o));
                continue;
            }
            Log.w(LCAT, "Unsupported type " + o.getClass());
        }
        return ja;
    }

    public static String toJSONString(Object value) {
        if (value instanceof Date) {
            SimpleDateFormat df = new SimpleDateFormat(JSON_DATE_FORMAT);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            return df.format((Date)value);
        }
        return TiConvert.toString(value);
    }

    public static Date toDate(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            long millis = ((Number)value).longValue();
            return new Date(millis);
        }
        return null;
    }

    public static Date toDate(KrollDict d, String key) {
        return TiConvert.toDate(d.get(key));
    }
}

