/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.graphics.Color;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appcelerator.titanium.util.Log;

public class TiColorHelper {
    static Pattern shortHexPattern = Pattern.compile("#([0-9a-f])([0-9a-f])([0-9a-f])([0-9a-f]?)");
    static Pattern rgbPattern = Pattern.compile("rgb\\(([0-9]{1,3}),([0-9]{1,3}),([0-9]{1,3})\\)");
    static Pattern argbPattern = Pattern.compile("rgba\\(([0-9]{1,3}),([0-9]{1,3}),([0-9]{1,3}),([0-9]{1,3})\\)");
    private static HashMap<String, Integer> colorTable;

    public static int parseColor(String value) {
        int color = -256;
        if (value != null) {
            String lowval = value.trim().toLowerCase();
            Matcher m = null;
            m = shortHexPattern.matcher(lowval);
            if (m.matches()) {
                StringBuilder sb = new StringBuilder();
                sb.append("#");
                for (int i = 1; i <= m.groupCount(); ++i) {
                    String s = m.group(i);
                    sb.append(s).append(s);
                }
                String newColor = sb.toString();
                color = Color.parseColor((String)newColor);
            } else {
                m = rgbPattern.matcher(lowval);
                if (m.matches()) {
                    color = Color.rgb((int)Integer.valueOf(m.group(1)), (int)Integer.valueOf(m.group(2)), (int)Integer.valueOf(m.group(3)));
                } else {
                    m = argbPattern.matcher(lowval);
                    if (m.matches()) {
                        color = Color.argb((int)Integer.valueOf(m.group(4)), (int)Integer.valueOf(m.group(1)), (int)Integer.valueOf(m.group(2)), (int)Integer.valueOf(m.group(3)));
                    } else {
                        try {
                            color = Color.parseColor((String)lowval);
                        }
                        catch (IllegalArgumentException e) {
                            if (colorTable == null) {
                                TiColorHelper.buildColorTable();
                            }
                            if (colorTable.containsKey(lowval)) {
                                color = colorTable.get(lowval);
                            }
                            Log.w("TiColorHelper", "Unknown color: " + value);
                        }
                    }
                }
            }
        }
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildColorTable() {
        Class<TiColorHelper> clazz = TiColorHelper.class;
        synchronized (TiColorHelper.class) {
            colorTable = new HashMap(16);
            colorTable.put("black", -16777216);
            colorTable.put("red", -65536);
            colorTable.put("purple", Color.rgb((int)128, (int)0, (int)128));
            colorTable.put("orange", Color.rgb((int)255, (int)128, (int)0));
            colorTable.put("gray", -7829368);
            colorTable.put("darkgray", -12303292);
            colorTable.put("lightgray", -3355444);
            colorTable.put("cyan", -16711681);
            colorTable.put("magenta", -65281);
            colorTable.put("transparent", 0);
            colorTable.put("aqua", Color.rgb((int)0, (int)255, (int)255));
            colorTable.put("fuchsia", Color.rgb((int)255, (int)0, (int)255));
            colorTable.put("lime", Color.rgb((int)0, (int)255, (int)0));
            colorTable.put("maroon", Color.rgb((int)136, (int)0, (int)136));
            colorTable.put("pink", Color.rgb((int)255, (int)192, (int)203));
            colorTable.put("navy", Color.rgb((int)0, (int)0, (int)128));
            colorTable.put("silver", Color.rgb((int)192, (int)192, (int)192));
            colorTable.put("olive", Color.rgb((int)128, (int)128, (int)0));
            colorTable.put("teal", Color.rgb((int)0, (int)128, (int)128));
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

