/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.view.View;
import java.lang.ref.SoftReference;
import java.util.concurrent.RejectedExecutionException;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiDimension;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.view.TiDrawableReference;

public abstract class TiBackgroundImageLoadTask
extends AsyncTask<String, Long, Drawable> {
    private static final String LCAT = "TiBackgroundImageLoadTask";
    private static final boolean DBG = TiConfig.LOGD;
    protected SoftReference<TiContext> softTiContext;
    protected SoftReference<View> parent;
    protected TiDimension imageHeight;
    protected TiDimension imageWidth;

    public TiBackgroundImageLoadTask(TiContext tiContext, View parent, TiDimension imageWidth, TiDimension imageHeight) {
        this.softTiContext = new SoftReference<TiContext>(tiContext);
        this.parent = new SoftReference<View>(parent);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
    }

    protected Drawable doInBackground(String ... arg) {
        if (arg.length == 0) {
            Log.w(LCAT, "url argument is missing.  Returning null drawable");
            return null;
        }
        String url = arg[0];
        BitmapDrawable d = null;
        TiContext context = this.softTiContext.get();
        if (context == null || this.parent.get() == null) {
            if (DBG) {
                Log.d(LCAT, "doInBackground exiting early because context already gc'd");
            }
            return null;
        }
        TiDrawableReference ref = TiDrawableReference.fromUrl(context, url);
        boolean retry = true;
        int retryCount = 3;
        while (retry) {
            retry = false;
            Bitmap b = ref.getBitmap(this.parent.get(), this.imageWidth, this.imageHeight);
            if (b != null) {
                d = new BitmapDrawable(b);
                continue;
            }
            if (ref.outOfMemoryOccurred()) {
                Log.e(LCAT, "Not enough memory left to load image: " + url);
                if (--retryCount <= 0) continue;
                retry = true;
                Log.i(LCAT, "Signalling a GC, will retry load.");
                System.gc();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                Log.i(LCAT, "Retry #" + (3 - retryCount) + " for " + url);
                continue;
            }
            if (DBG) {
                Log.d(LCAT, "TiDrawableReference.getBitmap() (url '" + url + "') returned null");
            }
            return null;
        }
        return d;
    }

    public void load(String url) {
        try {
            this.execute(new String[]{url});
        }
        catch (RejectedExecutionException e) {
            Log.w(LCAT, "Thread pool rejected attempt to load image: " + url);
            Log.w(LCAT, "ADD Handler for retry");
        }
    }
}

