/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import org.appcelerator.titanium.util.TiAnimationPair;

public class TiAnimationFactory {
    public static TiAnimationPair getAnimationFor(String style, int duration) {
        TiAnimationPair a = new TiAnimationPair();
        boolean needsDuration = true;
        if (style.equals("fade-in")) {
            a.in = new AlphaAnimation(0.0f, 1.0f);
            a.out = new AlphaAnimation(1.0f, 0.0f);
        } else if (style.equals("fade-out")) {
            a.in = new AlphaAnimation(1.0f, 0.0f);
            a.out = new AlphaAnimation(0.0f, 1.0f);
        } else if (style.equals("slide-from-left")) {
            a.in = new TranslateAnimation(1, -1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
            a.out = new TranslateAnimation(1, 0.0f, 1, 1.0f, 1, 0.0f, 1, 0.0f);
        } else if (style.equals("slide-from-top")) {
            a.in = new TranslateAnimation(1, 0.0f, 1, 0.0f, 2, -1.0f, 2, 0.0f);
            a.out = new TranslateAnimation(1, 0.0f, 1, 0.0f, 2, 0.0f, 2, 1.0f);
        } else if (style.equals("slide-from-right")) {
            a.in = new TranslateAnimation(1, 1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
            a.out = new TranslateAnimation(1, 0.0f, 1, -1.0f, 1, 0.0f, 1, 0.0f);
        } else if (style.equals("slide-from-bottom")) {
            a.in = new TranslateAnimation(1, 0.0f, 1, 0.0f, 2, 1.0f, 2, 0.0f);
            a.out = new TranslateAnimation(1, 0.0f, 1, 0.0f, 2, 0.0f, 2, -1.0f);
        } else if (style.equals("scale-in")) {
            a.in = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 2, 0.5f, 2, 0.5f);
            a.out = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, 2, 0.5f, 2, 0.5f);
        } else if (style.equals("wink-in")) {
            needsDuration = false;
            int half = duration / 2;
            a.in = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 2, 0.5f, 2, 0.5f);
            a.in.setStartOffset((long)(half + half / 5));
            a.in.setDuration((long)half);
            a.out = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, 2, 0.5f, 2, 0.5f);
            a.out.setDuration((long)half);
        } else if (style.equals("headlines")) {
            needsDuration = false;
            int half = duration / 2;
            int pause = half / 5;
            AnimationSet as = new AnimationSet(true);
            AlphaAnimation t = new AlphaAnimation(0.0f, 1.0f);
            t.setDuration((long)half);
            as.addAnimation((Animation)t);
            t = new RotateAnimation(0.0f, -720.0f, 1, 0.5f, 1, 0.5f);
            t.setDuration((long)half);
            as.addAnimation((Animation)t);
            t = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 2, 0.5f, 2, 0.5f);
            t.setDuration((long)half);
            as.addAnimation((Animation)t);
            a.in = as;
            a.in.setStartOffset((long)(half + pause));
            as = new AnimationSet(true);
            t = new AlphaAnimation(1.0f, 0.0f);
            t.setDuration((long)half);
            as.addAnimation((Animation)t);
            t = new RotateAnimation(0.0f, 720.0f, 1, 0.5f, 1, 0.5f);
            t.setDuration((long)half);
            as.addAnimation((Animation)t);
            t = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, 2, 0.5f, 2, 0.5f);
            t.setDuration((long)half);
            as.addAnimation((Animation)t);
            a.out = as;
        }
        if (a != null) {
            if (a.in != null) {
                if (needsDuration) {
                    a.in.setDuration((long)duration);
                }
                a.in.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
            }
            if (a.out != null) {
                if (needsDuration) {
                    a.out.setDuration((long)duration);
                }
                a.out.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
            }
        }
        return a;
    }
}

