/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import android.view.animation.TranslateAnimation;
import org.appcelerator.kroll.KrollConverter;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.titanium.TiDimension;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.view.Ti2DMatrix;
import org.appcelerator.titanium.view.TiAnimation;
import org.appcelerator.titanium.view.TiCompositeLayout;
import org.appcelerator.titanium.view.TiUIView;

public class TiAnimationBuilder {
    private static final String LCAT = "TiAnimationBuilder";
    private static final boolean DBG = TiConfig.LOGD;
    protected float anchorX = -1.0f;
    protected float anchorY = -1.0f;
    protected Ti2DMatrix tdm = null;
    protected Double delay = null;
    protected Double duration = null;
    protected Double toOpacity = null;
    protected Double fromOpacity = null;
    protected Double repeat = null;
    protected Boolean autoreverse = null;
    protected Integer top = null;
    protected Integer bottom = null;
    protected Integer left = null;
    protected Integer right = null;
    protected Integer centerX = null;
    protected Integer centerY = null;
    protected Integer width = null;
    protected Integer height = null;
    protected TiAnimation animationProxy;
    protected KrollCallback callback;
    protected boolean relayoutChild = false;
    protected boolean applyOpacity = false;
    protected KrollDict options;
    protected View view;
    protected TiViewProxy viewProxy;

    public void applyOptions(KrollDict options) {
        KrollDict center;
        if (options == null) {
            return;
        }
        if (options.containsKey("anchorPoint")) {
            KrollDict point = (KrollDict)options.get("anchorPoint");
            this.anchorX = KrollConverter.toFloat(point, "x");
            this.anchorY = KrollConverter.toFloat(point, "y");
        }
        if (options.containsKey("transform")) {
            this.tdm = (Ti2DMatrix)options.get("transform");
        }
        if (options.containsKey("delay")) {
            this.delay = KrollConverter.toDouble(options, "delay");
        }
        if (options.containsKey("duration")) {
            this.duration = KrollConverter.toDouble(options, "duration");
        }
        if (options.containsKey("opacity")) {
            this.toOpacity = KrollConverter.toDouble(options, "opacity");
        }
        if (options.containsKey("repeat")) {
            this.repeat = KrollConverter.toDouble(options, "repeat");
        }
        if (options.containsKey("autoreverse")) {
            this.autoreverse = KrollConverter.toBoolean(options, "autoreverse");
        }
        if (options.containsKey("top")) {
            this.top = KrollConverter.toInt(options, "top");
        }
        if (options.containsKey("bottom")) {
            this.bottom = KrollConverter.toInt(options, "bottom");
        }
        if (options.containsKey("left")) {
            this.left = KrollConverter.toInt(options, "left");
        }
        if (options.containsKey("right")) {
            this.right = KrollConverter.toInt(options, "right");
        }
        if (options.containsKey("center") && (center = options.getKrollDict("center")) != null) {
            this.centerX = KrollConverter.toInt(center, "x");
            this.centerY = KrollConverter.toInt(center, "y");
        }
        if (options.containsKey("width")) {
            this.width = TiConvert.toInt(options, "width");
        }
        if (options.containsKey("height")) {
            this.height = TiConvert.toInt(options, "height");
        }
        this.options = options;
    }

    public void applyAnimation(TiAnimation anim) {
        this.animationProxy = anim;
        this.applyOptions(anim.getProperties());
    }

    public void setCallback(KrollCallback callback) {
        this.callback = callback;
    }

    public AnimationSet render(TiViewProxy viewProxy, View view) {
        ViewParent parent = view.getParent();
        int parentWidth = 0;
        int parentHeight = 0;
        if (parent instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)parent;
            parentHeight = group.getMeasuredHeight();
            parentWidth = group.getMeasuredWidth();
        }
        return this.render(viewProxy, view, view.getLeft(), view.getTop(), view.getMeasuredWidth(), view.getMeasuredHeight(), parentWidth, parentHeight);
    }

    private void addAnimation(AnimationSet as, Animation a) {
        if (this.repeat != null) {
            a.setRepeatCount(this.repeat.intValue());
        }
        if (this.autoreverse != null) {
            if (this.autoreverse.booleanValue()) {
                a.setRepeatMode(2);
            } else {
                a.setRepeatMode(1);
            }
        }
        as.addAnimation(a);
    }

    public TiMatrixAnimation createMatrixAnimation(Ti2DMatrix matrix) {
        return new TiMatrixAnimation(matrix, this.anchorX, this.anchorY);
    }

    public AnimationSet render(TiViewProxy viewProxy, View view, int x, int y, int w, int h, int parentWidth, int parentHeight) {
        this.view = view;
        this.viewProxy = viewProxy;
        AnimationSet as = new AnimationSet(false);
        AnimationListener listener = new AnimationListener();
        if (this.toOpacity != null) {
            this.fromOpacity = viewProxy.hasProperty("opacity") ? Double.valueOf(TiConvert.toDouble(viewProxy.getProperty("opacity"))) : Double.valueOf(1.0 - this.toOpacity);
            AlphaAnimation a = new AlphaAnimation(this.fromOpacity.floatValue(), this.toOpacity.floatValue());
            this.applyOpacity = true;
            this.addAnimation(as, (Animation)a);
            a.setAnimationListener((Animation.AnimationListener)listener);
            if (viewProxy.hasProperty("opacity") && this.fromOpacity != null && this.toOpacity != null && this.fromOpacity > 0.0 && this.fromOpacity < 1.0) {
                TiUIView uiView = viewProxy.getView(null);
                uiView.setOpacity(1.0f);
            }
        }
        if (this.tdm != null) {
            as.setFillAfter(true);
            as.setFillEnabled(true);
            TiMatrixAnimation matrixAnimation = new TiMatrixAnimation(this.tdm, this.anchorX, this.anchorY);
            if (this.duration != null) {
                matrixAnimation.setDuration(this.duration.longValue());
            }
            this.addAnimation(as, matrixAnimation);
        }
        if (this.duration != null) {
            as.setDuration(this.duration.longValue());
        }
        if (this.delay != null) {
            as.setStartOffset(this.delay.longValue());
        }
        if (this.top != null || this.bottom != null || this.left != null || this.right != null || this.centerX != null || this.centerY != null) {
            TiDimension optionTop = null;
            TiDimension optionBottom = null;
            TiDimension optionLeft = null;
            TiDimension optionRight = null;
            TiDimension optionCenterX = null;
            TiDimension optionCenterY = null;
            if (this.top != null) {
                optionTop = new TiDimension(this.top.intValue(), 3);
            }
            if (this.bottom != null) {
                optionBottom = new TiDimension(this.bottom.intValue(), 5);
            }
            if (this.left != null) {
                optionLeft = new TiDimension(this.left.intValue(), 0);
            }
            if (this.right != null) {
                optionRight = new TiDimension(this.right.intValue(), 2);
            }
            if (this.centerX != null) {
                optionCenterX = new TiDimension(this.centerX.intValue(), 1);
            }
            if (this.centerY != null) {
                optionCenterY = new TiDimension(this.centerY.intValue(), 4);
            }
            int[] horizontal = new int[2];
            int[] vertical = new int[2];
            ViewParent parent = view.getParent();
            View parentView = null;
            if (parent instanceof View) {
                parentView = (View)parent;
            }
            TiCompositeLayout.computePosition(parentView, optionLeft, optionCenterX, optionRight, w, 0, parentWidth, horizontal);
            TiCompositeLayout.computePosition(parentView, optionTop, optionCenterY, optionBottom, h, 0, parentHeight, vertical);
            TranslateAnimation a = new TranslateAnimation(1, 0.0f, 0, (float)(horizontal[0] - x), 1, 0.0f, 0, (float)(vertical[0] - y));
            a.setFillEnabled(true);
            a.setFillAfter(true);
            if (this.duration != null) {
                a.setDuration(this.duration.longValue());
            }
            as.setFillEnabled(true);
            as.setFillAfter(true);
            a.setAnimationListener((Animation.AnimationListener)listener);
            as.addAnimation((Animation)a);
            if (DBG) {
                Log.d(LCAT, "animate " + viewProxy + " relative to self: " + (horizontal[0] - x) + ", " + (vertical[0] - y));
            }
            this.relayoutChild = true;
        }
        if (this.tdm == null && (this.width != null || this.height != null)) {
            int toWidth = this.width == null ? w : this.width;
            int toHeight = this.height == null ? h : this.height;
            SizeAnimation sa = new SizeAnimation(view, w, h, toWidth, toHeight);
            if (this.duration != null) {
                sa.setDuration(this.duration.longValue());
            }
            sa.setInterpolator((Interpolator)new LinearInterpolator());
            sa.setAnimationListener(listener);
            as.addAnimation((Animation)sa);
            this.relayoutChild = true;
        }
        if (this.callback != null || this.animationProxy != null) {
            as.setAnimationListener((Animation.AnimationListener)listener);
        }
        return as;
    }

    protected class AnimationListener
    implements Animation.AnimationListener {
        protected AnimationListener() {
        }

        public void onAnimationEnd(Animation a) {
            if (TiAnimationBuilder.this.relayoutChild) {
                TiCompositeLayout.LayoutParams params = (TiCompositeLayout.LayoutParams)TiAnimationBuilder.this.view.getLayoutParams();
                TiConvert.fillLayout(TiAnimationBuilder.this.options, params);
                TiAnimationBuilder.this.view.setLayoutParams((ViewGroup.LayoutParams)params);
                TiAnimationBuilder.this.view.clearAnimation();
                TiAnimationBuilder.this.relayoutChild = false;
            }
            if (TiAnimationBuilder.this.applyOpacity) {
                if (TiAnimationBuilder.this.toOpacity.floatValue() == 0.0f) {
                    TiAnimationBuilder.this.view.setVisibility(4);
                } else if (TiAnimationBuilder.this.toOpacity.floatValue() == 1.0f) {
                    TiAnimationBuilder.this.view.setVisibility(0);
                } else {
                    AlphaAnimation aa = new AlphaAnimation(TiAnimationBuilder.this.toOpacity.floatValue(), TiAnimationBuilder.this.toOpacity.floatValue());
                    aa.setDuration(1L);
                    aa.setFillAfter(true);
                    aa.setFillEnabled(true);
                    TiAnimationBuilder.this.view.startAnimation((Animation)aa);
                }
                TiAnimationBuilder.this.applyOpacity = false;
            }
            if (a instanceof AnimationSet) {
                if (TiAnimationBuilder.this.callback != null) {
                    TiAnimationBuilder.this.callback.callAsync();
                }
                if (TiAnimationBuilder.this.animationProxy != null) {
                    TiAnimationBuilder.this.animationProxy.fireEvent("complete", null);
                }
            }
        }

        public void onAnimationRepeat(Animation a) {
        }

        public void onAnimationStart(Animation a) {
            if (TiAnimationBuilder.this.animationProxy != null) {
                TiAnimationBuilder.this.animationProxy.fireEvent("start", null);
            }
        }
    }

    public static class TiMatrixAnimation
    extends Animation {
        protected Ti2DMatrix matrix;
        protected int childWidth;
        protected int childHeight;
        protected float anchorX = -1.0f;
        protected float anchorY = -1.0f;
        public boolean interpolate = true;

        public TiMatrixAnimation(Ti2DMatrix matrix, float anchorX, float anchorY) {
            this.matrix = matrix;
            this.anchorX = anchorX;
            this.anchorY = anchorY;
        }

        public void initialize(int width, int height, int parentWidth, int parentHeight) {
            super.initialize(width, height, parentWidth, parentHeight);
            this.childWidth = width;
            this.childHeight = height;
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            super.applyTransformation(interpolatedTime, t);
            if (this.interpolate) {
                Matrix m = this.matrix.interpolate(interpolatedTime, this.childWidth, this.childHeight, this.anchorX, this.anchorY);
                t.getMatrix().set(m);
            } else {
                t.getMatrix().set(this.getFinalMatrix(this.childWidth, this.childHeight));
            }
        }

        public Matrix getFinalMatrix(int childWidth, int childHeight) {
            return this.matrix.interpolate(1.0f, childWidth, childHeight, this.anchorX, this.anchorY);
        }

        public void invalidateWithMatrix(View view) {
            int width = view.getWidth();
            int height = view.getHeight();
            Matrix m = this.getFinalMatrix(width, height);
            RectF rectF = new RectF(0.0f, 0.0f, (float)width, (float)height);
            m.mapRect(rectF);
            rectF.inset(-1.0f, -1.0f);
            Rect rect = new Rect();
            rectF.round(rect);
            if (view.getParent() instanceof ViewGroup) {
                int left = view.getLeft();
                int top = view.getTop();
                ((ViewGroup)view.getParent()).invalidate(left + rect.left, top + rect.top, left + rect.width(), top + rect.height());
            }
        }
    }

    protected class SizeAnimation
    extends Animation {
        protected View view;
        protected float fromWidth;
        protected float fromHeight;
        protected float toWidth;
        protected float toHeight;
        protected static final String LCAT = "TiSizeAnimation";

        public SizeAnimation(View view, float fromWidth, float fromHeight, float toWidth, float toHeight) {
            this.view = view;
            this.fromWidth = fromWidth;
            this.fromHeight = fromHeight;
            this.toWidth = toWidth;
            this.toHeight = toHeight;
            if (DBG) {
                Log.d(LCAT, "animate view from (" + fromWidth + "x" + fromHeight + ") to (" + toWidth + "x" + toHeight + ")");
            }
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            super.applyTransformation(interpolatedTime, t);
            int width = 0;
            width = this.fromWidth == this.toWidth ? (int)this.fromWidth : (int)Math.floor(this.fromWidth + (this.toWidth - this.fromWidth) * interpolatedTime);
            int height = 0;
            height = this.fromHeight == this.toHeight ? (int)this.fromHeight : (int)Math.floor(this.fromHeight + (this.toHeight - this.fromHeight) * interpolatedTime);
            ViewGroup.LayoutParams params = this.view.getLayoutParams();
            params.width = width;
            params.height = height;
            if (params instanceof TiCompositeLayout.LayoutParams) {
                TiCompositeLayout.LayoutParams tiParams = (TiCompositeLayout.LayoutParams)params;
                tiParams.optionHeight = new TiDimension(height, 7);
                tiParams.optionWidth = new TiDimension(width, 6);
            }
            this.view.setLayoutParams(params);
        }
    }
}

