/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiActivityResultHandler;
import org.appcelerator.titanium.util.TiActivitySupport;
import org.appcelerator.titanium.util.TiConfig;

public class TiActivitySupportHelper
implements TiActivitySupport {
    private static final String LCAT = "TiActivitySupportHelper";
    private static final boolean DBG = TiConfig.LOGD;
    protected Activity activity;
    protected HashMap<Integer, TiActivityResultHandler> resultHandlers;
    protected AtomicInteger uniqueResultCodeAllocator;

    public TiActivitySupportHelper(Activity activity) {
        this.activity = activity;
        this.resultHandlers = new HashMap();
        this.uniqueResultCodeAllocator = new AtomicInteger(1);
    }

    @Override
    public int getUniqueResultCode() {
        return this.uniqueResultCodeAllocator.getAndIncrement();
    }

    @Override
    public void launchActivityForResult(Intent intent, final int code, final TiActivityResultHandler resultHandler) {
        TiActivityResultHandler wrapper = new TiActivityResultHandler(){

            @Override
            public void onError(Activity activity, int requestCode, Exception e) {
                resultHandler.onError(activity, requestCode, e);
                TiActivitySupportHelper.this.removeResultHandler(code);
            }

            @Override
            public void onResult(Activity activity, int requestCode, int resultCode, Intent data) {
                resultHandler.onResult(activity, requestCode, resultCode, data);
                TiActivitySupportHelper.this.removeResultHandler(code);
            }
        };
        this.registerResultHandler(code, wrapper);
        try {
            this.activity.startActivityForResult(intent, code);
        }
        catch (ActivityNotFoundException e) {
            wrapper.onError(this.activity, code, (Exception)((Object)e));
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        TiActivityResultHandler handler = this.resultHandlers.get(requestCode);
        if (handler != null) {
            handler.onResult(this.activity, requestCode, resultCode, data);
        }
    }

    public void removeResultHandler(int code) {
        this.resultHandlers.remove(code);
    }

    public void registerResultHandler(int code, TiActivityResultHandler resultHandler) {
        if (resultHandler == null) {
            Log.w(LCAT, "Received a null result handler");
        }
        this.resultHandlers.put(code, resultHandler);
    }
}

