/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.util;

import org.appcelerator.titanium.util.TiConfig;

public class Log {
    private static long lastLog;
    private static long firstLog;
    protected String tag;
    protected boolean debug;

    public static synchronized void checkpoint(String tag, String msg) {
        firstLog = lastLog = System.currentTimeMillis();
        Log.i(tag, msg);
    }

    public Log(String tag, boolean debug) {
        this.tag = tag;
        this.debug = debug;
    }

    public static int debug(String tag, String msg) {
        return Log.debug(tag, msg, TiConfig.DEBUG);
    }

    public static int debug(String tag, String msg, boolean debug) {
        if (debug) {
            return Log.d(tag, msg);
        }
        return 0;
    }

    public int debug(String msg) {
        return Log.debug(this.tag, msg, this.debug);
    }

    public int debugFormat(String format, Object ... args) {
        return this.debug(String.format(format, args));
    }

    public static int v(String tag, String msg) {
        msg = Log.onThread(msg);
        return android.util.Log.v((String)tag, (String)msg);
    }

    public int v(String msg) {
        return Log.v(this.tag, msg);
    }

    public static int v(String tag, String msg, Throwable t) {
        msg = Log.onThread(msg);
        return android.util.Log.v((String)tag, (String)msg, (Throwable)t);
    }

    public int v(String msg, Throwable t) {
        return Log.v(this.tag, msg, t);
    }

    public static int d(String tag, String msg) {
        msg = Log.onThread(msg);
        return android.util.Log.d((String)tag, (String)msg);
    }

    public int d(String msg) {
        return Log.d(this.tag, msg);
    }

    public static int d(String tag, String msg, Throwable t) {
        msg = Log.onThread(msg);
        return android.util.Log.d((String)tag, (String)msg, (Throwable)t);
    }

    public int d(String msg, Throwable t) {
        return Log.d(this.tag, msg, t);
    }

    public static int i(String tag, String msg) {
        msg = Log.onThread(msg);
        return android.util.Log.i((String)tag, (String)msg);
    }

    public int i(String msg) {
        return Log.i(this.tag, msg);
    }

    public static int i(String tag, String msg, Throwable t) {
        msg = Log.onThread(msg);
        return android.util.Log.i((String)tag, (String)msg, (Throwable)t);
    }

    public int i(String msg, Throwable t) {
        return Log.i(this.tag, msg, t);
    }

    public static int w(String tag, String msg) {
        msg = Log.onThread(msg);
        return android.util.Log.w((String)tag, (String)msg);
    }

    public int w(String msg) {
        return Log.w(this.tag, msg);
    }

    public static int w(String tag, String msg, Throwable t) {
        msg = Log.onThread(msg);
        return android.util.Log.w((String)tag, (String)msg, (Throwable)t);
    }

    public int w(String msg, Throwable t) {
        return Log.w(this.tag, msg, t);
    }

    public static int e(String tag, String msg) {
        msg = Log.onThread(msg);
        return android.util.Log.e((String)tag, (String)msg);
    }

    public int e(String msg) {
        return Log.e(this.tag, msg);
    }

    public static int e(String tag, String msg, Throwable t) {
        msg = Log.onThread(msg);
        return android.util.Log.e((String)tag, (String)msg, (Throwable)t);
    }

    public int e(String msg, Throwable t) {
        return Log.e(this.tag, msg, t);
    }

    private static synchronized String onThread(String msg) {
        long currentMillis = System.currentTimeMillis();
        long elapsed = currentMillis - lastLog;
        long total = currentMillis - firstLog;
        lastLog = currentMillis;
        StringBuilder sb = new StringBuilder(256);
        sb.append("(").append(Thread.currentThread().getName()).append(") [").append(elapsed).append(",").append(total).append("] ").append(msg);
        String s = sb.toString();
        sb.setLength(0);
        return s;
    }

    static {
        firstLog = lastLog = System.currentTimeMillis();
    }
}

