/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.proxy;

import android.app.Activity;
import android.os.Build;
import android.os.Message;
import java.lang.ref.WeakReference;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.annotations.Kroll;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.proxy.ActivityProxy;
import org.appcelerator.titanium.proxy.TiViewProxy;
import org.appcelerator.titanium.util.AsyncResult;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiPropertyResolver;
import org.appcelerator.titanium.util.TiUIHelper;
import org.appcelerator.titanium.view.TiAnimation;
import org.appcelerator.titanium.view.TiUIView;

public abstract class TiWindowProxy
extends TiViewProxy {
    private static final String LCAT = "TiWindowProxy";
    private static final boolean DBG = TiConfig.LOGD;
    private static final int MSG_FIRST_ID = 1000;
    private static final int MSG_OPEN = 1100;
    private static final int MSG_CLOSE = 1101;
    protected static final int MSG_LAST_ID = 1999;
    private static final String[] NEW_ACTIVITY_REQUIRED_KEYS = new String[]{"fullscreen", "navBarHidden", "modal", "windowSoftInputMode"};
    private static WeakReference<TiWindowProxy> waitingForOpen;
    protected boolean opened;
    protected boolean opening;
    protected boolean focused;
    protected boolean fullscreen;
    protected boolean modal;
    protected boolean restoreFullscreen;
    protected int[] orientationModes = new int[0];
    protected TiViewProxy tabGroup;
    protected TiViewProxy tab;
    protected boolean inTab = false;
    protected PostOpenListener postOpenListener;

    public static TiWindowProxy getWaitingForOpen() {
        if (waitingForOpen == null) {
            return null;
        }
        return (TiWindowProxy)waitingForOpen.get();
    }

    public TiWindowProxy(TiContext tiContext) {
        super(tiContext);
    }

    @Override
    public TiUIView createView(Activity activity) {
        throw new IllegalStateException("Windows are created during open");
    }

    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1100: {
                AsyncResult result = (AsyncResult)msg.obj;
                this.handleOpen((KrollDict)result.getArg());
                result.setResult(null);
                return true;
            }
            case 1101: {
                AsyncResult result = (AsyncResult)msg.obj;
                this.handleClose((KrollDict)result.getArg());
                result.setResult(null);
                return true;
            }
        }
        return super.handleMessage(msg);
    }

    public boolean requiresNewActivity(KrollDict extraOptions) {
        TiPropertyResolver resolver = new TiPropertyResolver(this.getProperties(), extraOptions);
        return resolver.hasAnyOf(NEW_ACTIVITY_REQUIRED_KEYS);
    }

    public void open(@Kroll.argument(optional=true) Object arg) {
        if (this.opened || this.opening) {
            return;
        }
        waitingForOpen = new WeakReference<TiWindowProxy>(this);
        this.opening = true;
        KrollDict options = null;
        Object animation = null;
        if (arg != null) {
            if (arg instanceof KrollDict) {
                options = (KrollDict)arg;
            } else if (arg instanceof TiAnimation) {
                options = new KrollDict();
                options.put("_anim", animation);
            }
        }
        if (this.getTiContext().isUIThread()) {
            this.handleOpen(options);
            return;
        }
        this.sendBlockingUiMessage(1100, options);
        this.opening = false;
    }

    public void close(@Kroll.argument(optional=true) Object arg) {
        if (!this.opened) {
            return;
        }
        KrollDict options = null;
        Object animation = null;
        if (arg != null) {
            if (arg instanceof KrollDict) {
                options = (KrollDict)arg;
            } else if (arg instanceof TiAnimation) {
                options = new KrollDict();
                options.put("_anim", animation);
            }
        }
        if (this.getTiContext().isUIThread()) {
            this.handleClose(options);
            return;
        }
        this.sendBlockingUiMessage(1101, options);
    }

    public void closeFromActivity() {
        if (!this.opened) {
            return;
        }
        this.releaseViews();
        this.opened = false;
        TiContext context = this.getTiContext();
        if (this.creatingContext != null && context != null && !this.creatingContext.equals(context)) {
            this.switchToCreatingContext();
        }
    }

    public void setTabProxy(TiViewProxy tabProxy) {
        this.tab = tabProxy;
    }

    public TiViewProxy getTabProxy() {
        return this.tab;
    }

    public void setTabGroupProxy(TiViewProxy tabGroupProxy) {
        this.tabGroup = tabGroupProxy;
    }

    public TiViewProxy getTabGroupProxy() {
        return this.tabGroup;
    }

    public void setPostOpenListener(PostOpenListener listener) {
        this.postOpenListener = listener;
    }

    public void hideTabBar() {
    }

    @Override
    public KrollDict handleToImage() {
        return TiUIHelper.viewToImage(this.getTiContext(), this.properties, this.getTiContext().getActivity().getWindow().getDecorView());
    }

    public void updateOrientation() {
        this.setOrientationModes(this.orientationModes);
    }

    public void setOrientationModes(int[] modes) {
        Activity activity;
        int activityOrientationMode = -1;
        boolean hasPortrait = false;
        boolean hasPortraitReverse = false;
        boolean hasLandscape = false;
        boolean hasLandscapeReverse = false;
        this.orientationModes = modes;
        for (int i = 0; i < modes.length; ++i) {
            if (this.orientationModes[i] == 1) {
                hasPortrait = true;
                continue;
            }
            if (this.orientationModes[i] == 3) {
                hasPortraitReverse = true;
                continue;
            }
            if (this.orientationModes[i] == 2) {
                hasLandscape = true;
                continue;
            }
            if (this.orientationModes[i] != 4) continue;
            hasLandscapeReverse = true;
        }
        if (this.orientationModes.length == 0) {
            activityOrientationMode = 4;
        } else if ((hasPortrait || hasPortraitReverse) && (hasLandscape || hasLandscapeReverse)) {
            activityOrientationMode = 4;
        } else if (hasPortrait && hasPortraitReverse) {
            activityOrientationMode = Build.VERSION.SDK_INT >= 9 ? 7 : 1;
        } else if (hasLandscape && hasLandscapeReverse) {
            activityOrientationMode = Build.VERSION.SDK_INT >= 9 ? 6 : 0;
        } else if (hasPortrait) {
            activityOrientationMode = 1;
        } else if (hasLandscape) {
            activityOrientationMode = 0;
        }
        if (activityOrientationMode != -1 && (activity = this.getTiContext().getActivity()) != null) {
            activity.setRequestedOrientation(activityOrientationMode);
        }
    }

    public int[] getOrientationModes() {
        return this.orientationModes;
    }

    public ActivityProxy getActivity(KrollInvocation invocation) {
        return this.getActivity(invocation.getTiContext());
    }

    public ActivityProxy getActivity(TiContext tiContext) {
        Object activityObject = this.getProperty("activity");
        ActivityProxy activityProxy = null;
        if (activityObject == null) {
            activityProxy = new ActivityProxy(tiContext);
            this.setProperty("activity", activityProxy);
        } else if (activityObject instanceof KrollDict) {
            KrollDict options = (KrollDict)activityObject;
            activityProxy = new ActivityProxy(tiContext);
            activityProxy.handleCreationDict(options);
            this.setProperty("activity", activityProxy);
        } else if (activityObject instanceof ActivityProxy) {
            activityProxy = (ActivityProxy)activityObject;
        }
        return activityProxy;
    }

    protected abstract void handleOpen(KrollDict var1);

    protected abstract void handleClose(KrollDict var1);

    protected abstract Activity handleGetActivity();

    protected void handlePostOpen() {
        if (this.postOpenListener != null) {
            this.getUIHandler().post(new Runnable(){

                @Override
                public void run() {
                    TiWindowProxy.this.postOpenListener.onPostOpen(TiWindowProxy.this);
                }
            });
        }
        if (waitingForOpen != null && waitingForOpen.get() == this) {
            waitingForOpen = null;
        }
    }

    public static interface PostOpenListener {
        public void onPostOpen(TiWindowProxy var1);
    }
}

