/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.proxy;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.TreeSet;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.kroll.annotations.Kroll;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.proxy.TiWindowProxy;
import org.appcelerator.titanium.util.AsyncResult;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiAnimationBuilder;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;
import org.appcelerator.titanium.util.TiRHelper;
import org.appcelerator.titanium.view.TiAnimation;
import org.appcelerator.titanium.view.TiUIView;

public abstract class TiViewProxy
extends KrollProxy
implements Handler.Callback {
    private static final String LCAT = "TiViewProxy";
    private static final boolean DBG = TiConfig.LOGD;
    private static final int MSG_FIRST_ID = 1000;
    private static final int MSG_GETVIEW = 1100;
    private static final int MSG_ADD_CHILD = 1102;
    private static final int MSG_REMOVE_CHILD = 1103;
    private static final int MSG_BLUR = 1104;
    private static final int MSG_FOCUS = 1105;
    private static final int MSG_SHOW = 1106;
    private static final int MSG_HIDE = 1107;
    private static final int MSG_ANIMATE = 1108;
    private static final int MSG_TOIMAGE = 1109;
    private static final int MSG_GETSIZE = 1110;
    private static final int MSG_GETCENTER = 1111;
    protected static final int MSG_LAST_ID = 1999;
    protected ArrayList<TiViewProxy> children;
    protected WeakReference<TiViewProxy> parent;
    protected TiUIView view;
    protected TiAnimationBuilder pendingAnimation;

    public TiViewProxy(TiContext tiContext) {
        super(tiContext);
    }

    @Override
    public void handleCreationDict(KrollDict options) {
        options = this.handleStyleOptions(options);
        KrollDict langTable = this.getLangConversionTable();
        if (langTable != null) {
            Activity activity = this.context.getActivity();
            for (String key : langTable.keySet()) {
                String convertKey;
                String langKey;
                if (options.containsKey(key) || (langKey = (String)options.get(convertKey = (String)langTable.get(key))) == null) continue;
                try {
                    int resid = TiRHelper.getResource("string." + langKey);
                    if (resid == 0) continue;
                    options.put(key, activity.getString(resid));
                }
                catch (TiRHelper.ResourceNotFoundException e) {}
            }
        }
        options = this.handleStyleOptions(options);
        super.handleCreationDict(options);
        this.eventManager.addOnEventChangeListener(this);
    }

    protected String getBaseUrlForStylesheet() {
        int idx;
        String baseUrl = this.getTiContext().getCurrentUrl();
        if (baseUrl == null) {
            baseUrl = "app://app.js";
        }
        if ((idx = baseUrl.lastIndexOf("/")) != -1) {
            baseUrl = baseUrl.substring(idx + 1).replace(".js", "");
        }
        return baseUrl;
    }

    protected KrollDict handleStyleOptions(KrollDict options) {
        Object c;
        String viewId = this.getProxyId();
        TreeSet<String> styleClasses = new TreeSet<String>();
        styleClasses.add(this.getShortAPIName().toLowerCase());
        if (options.containsKey("id")) {
            viewId = TiConvert.toString(options, "id");
        }
        if (options.containsKey("className")) {
            String className = TiConvert.toString(options, "className");
            for (String clazz : className.split(" ")) {
                styleClasses.add(clazz);
            }
        }
        if (options.containsKey("classNames") && (c = options.get("classNames")).getClass().isArray()) {
            int length = Array.getLength(c);
            for (int i = 0; i < length; ++i) {
                Object clazz = Array.get(c, i);
                if (clazz == null) continue;
                styleClasses.add(clazz.toString());
            }
        }
        String baseUrl = this.getBaseUrlForStylesheet();
        KrollDict dict = this.context.getTiApp().getStylesheet(baseUrl, styleClasses, viewId);
        if (DBG) {
            Log.d(LCAT, "trying to get stylesheet for base:" + baseUrl + ",classes:" + styleClasses + ",id:" + viewId + ",dict:" + dict);
        }
        if (dict != null) {
            dict.putAll(options);
            return dict;
        }
        return options;
    }

    protected KrollDict getLangConversionTable() {
        return null;
    }

    public TiAnimationBuilder getPendingAnimation() {
        return this.pendingAnimation;
    }

    public void clearAnimation() {
        if (this.pendingAnimation != null) {
            this.pendingAnimation = null;
        }
    }

    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1100: {
                AsyncResult result = (AsyncResult)msg.obj;
                result.setResult(this.handleGetView((Activity)result.getArg()));
                return true;
            }
            case 1102: {
                AsyncResult result = (AsyncResult)msg.obj;
                this.handleAdd((TiViewProxy)result.getArg());
                result.setResult(null);
                return true;
            }
            case 1103: {
                AsyncResult result = (AsyncResult)msg.obj;
                this.handleRemove((TiViewProxy)result.getArg());
                result.setResult(null);
                return true;
            }
            case 1104: {
                this.handleBlur();
                return true;
            }
            case 1105: {
                this.handleFocus();
                return true;
            }
            case 1106: {
                this.handleShow((KrollDict)msg.obj);
                return true;
            }
            case 1107: {
                this.handleHide((KrollDict)msg.obj);
                return true;
            }
            case 1108: {
                this.handleAnimate();
                return true;
            }
            case 1109: {
                AsyncResult result = (AsyncResult)msg.obj;
                result.setResult(this.handleToImage());
                return true;
            }
            case 1110: {
                View v;
                AsyncResult result = (AsyncResult)msg.obj;
                KrollDict d = null;
                if (this.view != null && (v = this.view.getNativeView()) != null) {
                    d = new KrollDict();
                    d.put("width", v.getWidth());
                    d.put("height", v.getHeight());
                }
                if (d == null) {
                    d = new KrollDict();
                    d.put("width", 0);
                    d.put("height", 0);
                }
                result.setResult(d);
                return true;
            }
            case 1111: {
                View v;
                AsyncResult result = (AsyncResult)msg.obj;
                KrollDict d = null;
                if (this.view != null && (v = this.view.getNativeView()) != null) {
                    d = new KrollDict();
                    d.put("x", (double)v.getLeft() + (double)v.getWidth() / 2.0);
                    d.put("y", (double)v.getTop() + (double)v.getHeight() / 2.0);
                }
                if (d == null) {
                    d = new KrollDict();
                    d.put("x", 0);
                    d.put("y", 0);
                }
                result.setResult(d);
                return true;
            }
        }
        return super.handleMessage(msg);
    }

    public Context getContext() {
        return this.getTiContext().getActivity();
    }

    public KrollDict getSize() {
        return (KrollDict)this.sendBlockingUiMessage(1110, this.getTiContext().getActivity());
    }

    public Object getWidth() {
        if (this.hasProperty("width")) {
            return this.getProperty("width");
        }
        KrollDict size = this.getSize();
        return size.getInt("width");
    }

    public void setWidth(Object width) {
        this.setProperty("width", width, true);
    }

    public Object getHeight() {
        if (this.hasProperty("height")) {
            return this.getProperty("height");
        }
        KrollDict size = this.getSize();
        return size.getInt("height");
    }

    public void setHeight(Object height) {
        this.setProperty("height", height, true);
    }

    public KrollDict getCenter() {
        return (KrollDict)this.sendBlockingUiMessage(1111, this.getTiContext().getActivity());
    }

    public void clearView() {
        if (this.view != null) {
            this.view.release();
        }
        this.view = null;
    }

    public TiUIView peekView() {
        return this.view;
    }

    public void setView(TiUIView view) {
        this.view = view;
    }

    public TiUIView forceCreateView(Activity activity) {
        this.view = null;
        return this.getView(activity);
    }

    public TiUIView getView(Activity activity) {
        if (activity == null) {
            activity = this.getTiContext().getActivity();
        }
        if (this.getTiContext().isUIThread()) {
            return this.handleGetView(activity);
        }
        return (TiUIView)this.sendBlockingUiMessage(1100, activity);
    }

    protected TiUIView handleGetView(Activity activity) {
        if (this.view == null) {
            if (DBG) {
                Log.d(LCAT, "getView: " + this.getClass().getSimpleName());
            }
            this.view = this.createView(activity);
            this.realizeViews(activity, this.view);
            this.view.registerForTouch();
        }
        return this.view;
    }

    public void realizeViews(Activity activity, TiUIView view) {
        this.setModelListener(view);
        if (this.children != null) {
            for (TiViewProxy p : this.children) {
                TiUIView cv = p.getView(activity);
                view.add(cv);
            }
        }
        if (this.pendingAnimation != null) {
            this.handlePendingAnimation(true);
        }
    }

    public void releaseViews() {
        if (this.view != null) {
            if (this.children != null) {
                for (TiViewProxy p : this.children) {
                    p.releaseViews();
                }
            }
            this.view.release();
            this.view = null;
        }
        this.setModelListener(null);
    }

    public abstract TiUIView createView(Activity var1);

    public void add(TiViewProxy child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if (this.peekView() != null) {
            if (this.getTiContext().isUIThread()) {
                this.handleAdd(child);
                return;
            }
            this.sendBlockingUiMessage(1102, child);
        } else {
            this.children.add(child);
            child.parent = new WeakReference<TiViewProxy>(this);
        }
    }

    public void handleAdd(TiViewProxy child) {
        this.children.add(child);
        child.parent = new WeakReference<TiViewProxy>(this);
        if (this.view != null) {
            TiUIView cv = child.getView(this.getTiContext().getActivity());
            this.view.add(cv);
        }
    }

    public void remove(TiViewProxy child) {
        if (this.peekView() != null) {
            if (this.getTiContext().isUIThread()) {
                this.handleRemove(child);
                return;
            }
            this.sendBlockingUiMessage(1103, child);
        } else if (this.children != null) {
            this.children.remove(child);
            if (child.parent != null && child.parent.get() == this) {
                child.parent = null;
            }
        }
    }

    public void handleRemove(TiViewProxy child) {
        if (this.children != null) {
            this.children.remove(child);
            if (this.view != null) {
                this.view.remove(child.peekView());
            }
        }
    }

    public void show(@Kroll.argument(optional=true) KrollDict options) {
        if (this.getTiContext().isUIThread()) {
            this.handleShow(options);
        } else {
            this.getUIHandler().obtainMessage(1106, (Object)options).sendToTarget();
        }
    }

    protected void handleShow(KrollDict options) {
        if (this.view != null) {
            this.view.show();
        }
    }

    public void hide(@Kroll.argument(optional=true) KrollDict options) {
        if (this.getTiContext().isUIThread()) {
            this.handleHide(options);
        } else {
            this.getUIHandler().obtainMessage(1107, (Object)options).sendToTarget();
        }
    }

    protected void handleHide(KrollDict options) {
        if (this.view != null) {
            if (this.pendingAnimation != null) {
                this.handlePendingAnimation(false);
            }
            this.view.hide();
        }
    }

    public void animate(Object arg, @Kroll.argument(optional=true) KrollCallback callback) {
        if (arg instanceof KrollDict) {
            KrollDict options = (KrollDict)arg;
            this.pendingAnimation = new TiAnimationBuilder();
            this.pendingAnimation.applyOptions(options);
            if (callback != null) {
                this.pendingAnimation.setCallback(callback);
            }
        } else if (arg instanceof TiAnimation) {
            TiAnimation anim = (TiAnimation)arg;
            this.pendingAnimation = new TiAnimationBuilder();
            this.pendingAnimation.applyAnimation(anim);
        } else {
            throw new IllegalArgumentException("Unhandled argument to animate: " + arg.getClass().getSimpleName());
        }
        this.handlePendingAnimation(false);
    }

    public void handlePendingAnimation(boolean forceQueue) {
        if (this.pendingAnimation != null && this.peekView() != null) {
            if (forceQueue || !this.getTiContext().isUIThread()) {
                this.getUIHandler().obtainMessage(1108).sendToTarget();
            } else {
                this.handleAnimate();
            }
        }
    }

    protected void handleAnimate() {
        TiUIView tiv = this.peekView();
        if (tiv != null) {
            tiv.animate();
        }
    }

    public void blur() {
        if (this.getTiContext().isUIThread()) {
            this.handleBlur();
        } else {
            this.getUIHandler().sendEmptyMessage(1104);
        }
    }

    protected void handleBlur() {
        if (this.view != null) {
            this.view.blur();
        }
    }

    public void focus() {
        if (this.getTiContext().isUIThread()) {
            this.handleFocus();
        } else {
            this.getUIHandler().sendEmptyMessage(1105);
        }
    }

    protected void handleFocus() {
        if (this.view != null) {
            this.view.focus();
        }
    }

    public KrollDict toImage() {
        if (this.getTiContext().isUIThread()) {
            return this.handleToImage();
        }
        return (KrollDict)this.sendBlockingUiMessage(1109, this.getTiContext().getActivity());
    }

    protected KrollDict handleToImage() {
        return this.getView(this.getTiContext().getActivity()).toImage();
    }

    @Override
    public boolean fireEvent(String eventName, KrollDict data) {
        if (data == null) {
            data = new KrollDict();
        }
        boolean handled = super.fireEvent(eventName, data);
        if (this.parent != null && this.parent.get() != null) {
            boolean parentHandled = ((TiViewProxy)this.parent.get()).fireEvent(eventName, data);
            handled = handled || parentHandled;
        }
        return handled;
    }

    public TiViewProxy getParent() {
        if (this.parent == null) {
            return null;
        }
        return (TiViewProxy)this.parent.get();
    }

    public void setParent(TiViewProxy parent) {
        this.parent = new WeakReference<TiViewProxy>(parent);
    }

    @Override
    public TiContext switchContext(TiContext tiContext) {
        TiContext oldContext = super.switchContext(tiContext);
        if (this.children != null) {
            for (TiViewProxy child : this.children) {
                child.switchContext(tiContext);
            }
        }
        return oldContext;
    }

    public TiViewProxy[] getChildren() {
        if (this.children == null) {
            return new TiViewProxy[0];
        }
        return this.children.toArray(new TiViewProxy[this.children.size()]);
    }

    @Override
    public void eventListenerAdded(String eventName, int count, KrollProxy proxy2) {
        super.eventListenerAdded(eventName, count, proxy2);
        if (eventName.equals("click") && proxy2.equals(this) && count == 1 && !(proxy2 instanceof TiWindowProxy) && (!proxy2.hasProperty("touchEnabled") || TiConvert.toBoolean(proxy2.getProperty("touchEnabled")))) {
            this.setClickable(true);
        }
    }

    @Override
    public void eventListenerRemoved(String eventName, int count, KrollProxy proxy2) {
        super.eventListenerRemoved(eventName, count, proxy2);
        if (eventName.equals("click") && count == 0 && proxy2.equals(this) && !(proxy2 instanceof TiWindowProxy) && proxy2.hasProperty("touchEnabled") && !TiConvert.toBoolean(proxy2.getProperty("touchEnabled"))) {
            this.setClickable(false);
        }
    }

    public void setClickable(boolean clickable) {
        View nv;
        TiUIView v;
        if (this.peekView() != null && (v = this.getView(this.getTiContext().getActivity())) != null && (nv = v.getNativeView()) != null) {
            nv.setClickable(clickable);
        }
    }

    public void addClass(Object[] classNames) {
        String baseUrl = this.getBaseUrlForStylesheet();
        ArrayList<String> classes = new ArrayList<String>();
        for (Object c : classNames) {
            classes.add(TiConvert.toString(c));
        }
        KrollDict options = this.getTiContext().getTiApp().getStylesheet(baseUrl, classes, null);
        this.extend(options);
    }
}

