/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.proxy;

import android.app.Service;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiBaseService;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.proxy.IntentProxy;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;

public class ServiceProxy
extends KrollProxy {
    private Service service;
    private boolean forBoundServices;
    private int serviceInstanceId;
    private int serviceIntentId;
    private IntentProxy intentProxy;
    private ServiceConnection serviceConnection = null;
    private static final boolean DBG = TiConfig.LOGD;
    private static final String LCAT = "TiServiceProxy";

    public ServiceProxy(TiContext context) {
        super(context);
    }

    public ServiceProxy(TiContext context, Service service, Intent intent, int serviceInstanceId) {
        super(context);
        this.service = service;
        this.setIntent(intent);
        this.serviceInstanceId = serviceInstanceId;
    }

    public ServiceProxy(TiContext context, IntentProxy intentProxy) {
        super(context);
        this.setIntent(intentProxy);
        this.serviceIntentId = TiBaseService.nextServiceBindingIntentId();
        intentProxy.putExtra("$__TITANIUM_SERVICE_INTENT_ID__$", this.serviceIntentId);
        this.forBoundServices = true;
    }

    public int getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    protected int getServiceIntentId() {
        return this.serviceIntentId;
    }

    public IntentProxy getIntent() {
        return this.intentProxy;
    }

    public void setIntent(Intent intent) {
        this.setIntent(new IntentProxy(this.context, intent));
    }

    public void setIntent(IntentProxy intentProxy) {
        this.intentProxy = intentProxy;
    }

    public void start() {
        if (!this.forBoundServices) {
            Log.w(LCAT, "Only services created via Ti.Android.createService can be started via the start() command. Ignoring start() request.");
            return;
        }
        this.bindAndInvokeService();
    }

    public void stop() {
        if (DBG) {
            Log.d(LCAT, "stop");
        }
        if (!this.forBoundServices) {
            if (DBG) {
                Log.d(LCAT, "stop via stopService");
            }
            this.service.stopSelf();
        } else {
            this.unbindService();
        }
    }

    private void bindAndInvokeService() {
        this.serviceConnection = new ServiceConnection(){

            public void onServiceDisconnected(ComponentName name) {
            }

            public void onServiceConnected(ComponentName name, IBinder service) {
                if (service instanceof TiBaseService.TiServiceBinder) {
                    TiBaseService.TiServiceBinder binder = (TiBaseService.TiServiceBinder)service;
                    ServiceProxy proxy2 = ServiceProxy.this;
                    TiBaseService tiService = (TiBaseService)binder.getService();
                    if (DBG) {
                        Log.d(ServiceProxy.LCAT, ((Object)((Object)tiService)).getClass().getSimpleName() + " service successfully bound");
                    }
                    proxy2.serviceInstanceId = tiService.registerBoundTiContext(proxy2.getServiceIntentId(), proxy2.getTiContext());
                    proxy2.invokeBoundService(tiService);
                }
            }
        };
        this.getTiContext().getTiApp().bindService(this.getIntent().getIntent(), this.serviceConnection, 1);
    }

    private void unbindService() {
        TiContext tiContext;
        if (DBG) {
            Log.d(LCAT, "stop via unbindService for service proxy with intent id " + this.intentProxy.getIntExtra("$__TITANIUM_SERVICE_INTENT_ID__$", -1));
        }
        if ((tiContext = this.getTiContext()) == null) {
            Log.w(LCAT, "Cannot unbind service.  TiContext is null.");
            return;
        }
        TiApplication context = tiContext.getTiApp();
        if (context == null) {
            Log.w(LCAT, "Cannot unbind service.  tiContext.getTiApp() returned null");
            return;
        }
        if (this.service instanceof TiBaseService) {
            ((TiBaseService)this.service).unregisterBoundTiContext(this.getServiceIntentId());
        }
        context.unbindService(this.serviceConnection);
        this.serviceConnection = null;
    }

    protected void invokeBoundService(Service boundService) {
        this.service = boundService;
        if (!(boundService instanceof TiBaseService)) {
            Log.w(LCAT, "Service " + boundService.getClass().getSimpleName() + " is not a Ti Service.  Cannot start directly.");
            return;
        }
        TiBaseService tiService = (TiBaseService)boundService;
        if (DBG) {
            Log.d(LCAT, "Calling tiService.start for this proxy instance");
        }
        tiService.start(this);
    }
}

