/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.proxy;

import java.util.HashMap;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiRHelper;
import org.mozilla.javascript.Scriptable;

public class RProxy
extends KrollProxy {
    private static final String TAG = "TiAndroidRProxy";
    private static final boolean DBG = TiConfig.LOGD;
    public static final int RESOURCE_TYPE_ANDROID = 0;
    public static final int RESOURCE_TYPE_APPLICATION = 1;
    protected String name;
    protected int resourceType;
    protected HashMap<String, RProxy> subResources = new HashMap();

    public RProxy(TiContext context, int resourceType) {
        this(context, resourceType, null);
    }

    protected RProxy(TiContext context, int resourceType, String name) {
        super(context, false);
        this.resourceType = resourceType;
        this.name = name;
    }

    @Override
    public Object get(Scriptable scope, String name) throws NoSuchFieldException {
        if (!this.subResources.containsKey(name)) {
            String childName = this.name == null ? name : this.name + "." + name;
            this.subResources.put(name, new RProxy(this.getTiContext(), this.resourceType, childName));
        }
        return this.subResources.get(name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public Object getNativeValue() {
        if (DBG) {
            Log.d(TAG, "Getting resource " + (this.resourceType == 0 ? "android.R." : "R.") + this.name);
        }
        try {
            if (this.resourceType == 0) {
                return TiRHelper.getAndroidResource(this.name);
            }
            return TiRHelper.getApplicationResource(this.name);
        }
        catch (TiRHelper.ResourceNotFoundException e) {
            return super.getNativeValue();
        }
    }

    public int getResourceType() {
        return this.resourceType;
    }
}

