/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.proxy;

import android.os.Message;
import android.view.Menu;
import android.view.MenuItem;
import java.lang.constant.Constable;
import java.util.HashMap;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.proxy.MenuItemProxy;
import org.appcelerator.titanium.util.AsyncResult;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;

public class MenuProxy
extends KrollProxy {
    private static final String LCAT = "MenuProxy";
    private final boolean DBG = TiConfig.LOGD;
    private static final int MSG_FIRST_ID = 1000;
    private static final int MSG_ADD = 1100;
    private static final int MSG_CLOSE = 1101;
    private static final int MSG_CLEAR = 1102;
    private static final int MSG_REMOVE_GROUP = 1103;
    private static final int MSG_REMOVE_ITEM = 1104;
    private static final int MSG_SET_GROUP_ENABLED = 1105;
    private static final int MSG_SET_GROUP_VISIBLE = 1106;
    protected static final int MSG_LAST_ID = 1999;
    protected Menu menu;
    protected HashMap<MenuItem, MenuItemProxy> menuMap;

    public MenuProxy(TiContext tiContext, Menu menu) {
        super(tiContext);
        this.menu = menu;
        this.menuMap = new HashMap();
    }

    @Override
    public boolean handleMessage(Message msg) {
        AsyncResult result = null;
        result = (AsyncResult)msg.obj;
        switch (msg.what) {
            case 1100: {
                result.setResult(this.handleAdd((KrollDict)result.getArg()));
                return true;
            }
            case 1101: {
                this.handleClose();
                result.setResult(null);
                return true;
            }
            case 1102: {
                this.handleClear();
                result.setResult(null);
                return true;
            }
            case 1103: {
                this.handleRemoveGroup(msg.arg1);
                result.setResult(null);
                return true;
            }
            case 1104: {
                this.handleRemoveItem(msg.arg1);
                result.setResult(null);
                return true;
            }
            case 1105: {
                this.handleSetGroupEnabled((HashMap)result.getArg());
                result.setResult(null);
                return true;
            }
            case 1106: {
                this.handleSetGroupVisible((HashMap)result.getArg());
                result.setResult(null);
                return true;
            }
        }
        return super.handleMessage(msg);
    }

    public MenuItemProxy add(KrollDict d) {
        MenuItemProxy mip = null;
        if (this.getTiContext().isUIThread()) {
            mip = this.handleAdd(d);
            return mip;
        }
        return (MenuItemProxy)this.sendBlockingUiMessage(1100, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItemProxy handleAdd(KrollDict d) {
        MenuItemProxy mip = null;
        String title = "";
        int itemId = 0;
        int groupId = 0;
        int order = 0;
        if (d.containsKey("title")) {
            title = TiConvert.toString(d, "title");
        }
        if (d.containsKey("itemId")) {
            itemId = TiConvert.toInt(d, "itemId");
        }
        if (d.containsKey("groupId")) {
            groupId = TiConvert.toInt(d, "groupId");
        }
        if (d.containsKey("order")) {
            order = TiConvert.toInt(d, "order");
        }
        MenuItem item = this.menu.add(groupId, itemId, order, (CharSequence)title);
        mip = new MenuItemProxy(this.getTiContext(), item);
        HashMap<MenuItem, MenuItemProxy> hashMap = this.menuMap;
        synchronized (hashMap) {
            this.menuMap.put(item, mip);
        }
        return mip;
    }

    public void clear() {
        if (this.getTiContext().isUIThread()) {
            this.handleClear();
            return;
        }
        this.sendBlockingUiMessage(1102, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleClear() {
        if (this.menu != null) {
            this.menu.clear();
            HashMap<MenuItem, MenuItemProxy> hashMap = this.menuMap;
            synchronized (hashMap) {
                this.menuMap.clear();
            }
        }
    }

    public void close() {
        if (this.getTiContext().isUIThread()) {
            this.handleClose();
            return;
        }
        this.sendBlockingUiMessage(1101, null);
    }

    public void handleClose() {
        if (this.menu != null) {
            this.menu.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItemProxy findItem(int itemId) {
        MenuItemProxy mip = null;
        MenuItem item = this.menu.findItem(itemId);
        if (item != null) {
            HashMap<MenuItem, MenuItemProxy> hashMap = this.menuMap;
            synchronized (hashMap) {
                mip = this.menuMap.get(item);
            }
        }
        return mip;
    }

    public MenuItemProxy getItem(int index) {
        MenuItemProxy mip = null;
        MenuItem item = this.menu.getItem(index);
        if (item != null) {
            mip = this.menuMap.get(item);
        }
        return mip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItemProxy findItem(MenuItem item) {
        HashMap<MenuItem, MenuItemProxy> hashMap = this.menuMap;
        synchronized (hashMap) {
            return this.menuMap.get(item);
        }
    }

    public boolean hasVisibleItems() {
        return this.menu.hasVisibleItems();
    }

    public void removeGroup(int groupId) {
        if (this.getTiContext().isUIThread()) {
            this.handleRemoveGroup(groupId);
            return;
        }
        this.sendBlockingUiMessage(1103, groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRemoveGroup(int groupId) {
        HashMap<MenuItem, MenuItemProxy> hashMap = this.menuMap;
        synchronized (hashMap) {
            this.menu.removeGroup(groupId);
            HashMap<MenuItem, MenuItemProxy> mm = new HashMap<MenuItem, MenuItemProxy>(this.menu.size());
            int len = this.menu.size();
            for (int i = 0; i < len; ++i) {
                MenuItem mi = this.menu.getItem(i);
                MenuItemProxy mip = this.menuMap.get(mi);
                mm.put(mi, mip);
            }
            this.menuMap.clear();
            this.menuMap = mm;
        }
    }

    public void removeItem(int itemId) {
        if (this.getTiContext().isUIThread()) {
            this.handleRemoveItem(itemId);
            return;
        }
        this.sendBlockingUiMessage(1104, itemId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRemoveItem(int itemId) {
        HashMap<MenuItem, MenuItemProxy> hashMap = this.menuMap;
        synchronized (hashMap) {
            MenuItem mi = this.menu.findItem(itemId);
            if (mi != null) {
                MenuItemProxy mip = this.menuMap.remove(mi);
                if (mip != null) {
                    // empty if block
                }
                this.menu.removeItem(itemId);
            }
        }
    }

    public void setGroupCheckable(int groupId, boolean checkable, boolean exclusive) {
    }

    public void setGroupEnabled(int groupId, boolean enabled) {
        HashMap<String, Constable> args = new HashMap<String, Constable>();
        args.put("groupId", Integer.valueOf(groupId));
        args.put("enabled", Boolean.valueOf(enabled));
        if (this.getTiContext().isUIThread()) {
            this.handleSetGroupEnabled(args);
            return;
        }
        this.sendBlockingUiMessage(1105, args);
    }

    public void handleSetGroupEnabled(HashMap args) {
        this.menu.setGroupEnabled(((Integer)args.get("groupId")).intValue(), ((Boolean)args.get("enabled")).booleanValue());
    }

    public void setGroupVisible(int groupId, boolean visible) {
        HashMap<String, Constable> args = new HashMap<String, Constable>();
        args.put("groupId", Integer.valueOf(groupId));
        args.put("visible", Boolean.valueOf(visible));
        if (this.getTiContext().isUIThread()) {
            this.handleSetGroupVisible(args);
            return;
        }
        this.sendBlockingUiMessage(1106, args);
    }

    public void handleSetGroupVisible(HashMap args) {
        this.menu.setGroupVisible(((Integer)args.get("groupId")).intValue(), ((Boolean)args.get("visible")).booleanValue());
    }

    public int size() {
        return this.menu.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItemProxy[] getItems() {
        int len = this.menu.size();
        MenuItemProxy[] proxies = new MenuItemProxy[len];
        HashMap<MenuItem, MenuItemProxy> hashMap = this.menuMap;
        synchronized (hashMap) {
            for (int i = 0; i < len; ++i) {
                MenuItemProxy mip;
                MenuItem mi = this.menu.getItem(i);
                proxies[i] = mip = this.menuMap.get(mi);
            }
        }
        return proxies;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void setMenu(Menu menu) {
        if (this.menu != null && this.menu != menu) {
            if (this.DBG) {
                Log.w(LCAT, "A new menu has been set, cleaning up old menu first");
            }
            this.release();
        }
        this.menu = menu;
    }

    public void release() {
        if (this.menu != null) {
            this.menu.clear();
            this.menu.close();
            this.menu = null;
        }
        this.menuMap.clear();
    }
}

