/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.proxy;

import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiConvert;

public class IntentProxy
extends KrollProxy {
    private static final String TAG = "TiIntent";
    private static boolean DBG = TiConfig.LOGD;
    public static final int TYPE_ACTIVITY = 0;
    public static final int TYPE_SERVICE = 1;
    public static final int TYPE_BROADCAST = 2;
    protected Intent intent;
    protected int type = 0;
    protected static char[] escapeChars = new char[]{'\\', '/', ' ', '.', '$', '&', '@'};

    public IntentProxy(TiContext tiContext) {
        super(tiContext);
    }

    public IntentProxy(TiContext tiContext, Intent intent) {
        super(tiContext);
        this.intent = intent;
    }

    protected static String getURLClassName(String url, int type) {
        switch (type) {
            case 0: {
                return IntentProxy.getURLClassName(url, "Activity");
            }
            case 1: {
                return IntentProxy.getURLClassName(url, "Service");
            }
            case 2: {
                return IntentProxy.getURLClassName(url, "Broadcast");
            }
        }
        return null;
    }

    protected static String getURLClassName(String url, String appendage) {
        String className;
        List<String> parts = Arrays.asList(url.split("/"));
        if (parts.size() == 0) {
            return null;
        }
        int start = 0;
        if (parts.get(0).equals("app:") && parts.size() >= 3) {
            start = 2;
        }
        if ((className = TextUtils.join((CharSequence)"_", parts.subList(start, parts.size()))).endsWith(".js")) {
            className = className.substring(0, className.length() - 3);
        }
        className = className.length() > 1 ? className.substring(0, 1).toUpperCase() + className.substring(1) : className.toUpperCase();
        for (char escapeChar : escapeChars) {
            className = className.replace(escapeChar, '_');
        }
        return className + appendage;
    }

    @Override
    public void handleCreationDict(KrollDict dict) {
        this.intent = new Intent();
        String action = dict.getString("action");
        String url = dict.getString("url");
        String data = dict.getString("data");
        String className = dict.getString("className");
        String packageName = dict.getString("packageName");
        String type = dict.getString("type");
        int flags = 0;
        if (dict.containsKey("flags")) {
            flags = TiConvert.toInt(dict, "flags");
            if (DBG) {
                Log.d(TAG, "Setting flags: " + Integer.toString(flags));
            }
            this.intent.setFlags(flags);
        } else {
            this.setProperty("flags", this.intent.getFlags(), false);
        }
        if (action != null) {
            if (DBG) {
                Log.d(TAG, "Setting action: " + action);
            }
            this.intent.setAction(action);
        }
        if (packageName != null) {
            if (DBG) {
                Log.d(TAG, "Setting package: " + packageName);
            }
            this.intent.setPackage(packageName);
        }
        if (url != null) {
            if (DBG) {
                Log.d(TAG, "Creating intent for JS Activity/Service @ " + url);
            }
            packageName = TiApplication.getInstance().getPackageName();
            className = packageName + "." + IntentProxy.getURLClassName(url, this.type);
        }
        if (className != null) {
            if (packageName != null) {
                if (DBG) {
                    Log.d(TAG, "Both className and packageName set, using intent.setClassName(packageName, className");
                }
                this.intent.setClassName(packageName, className);
            } else {
                try {
                    Class<?> c = this.getClass().getClassLoader().loadClass(className);
                    this.intent.setClass(this.getTiContext().getActivity().getApplicationContext(), c);
                }
                catch (ClassNotFoundException e) {
                    Log.e(TAG, "Unable to locate class for name: " + className);
                    throw new IllegalStateException("Missing class for name: " + className, e);
                }
            }
        }
        if (type == null && action != null && action.equals("android.intent.action.SEND")) {
            type = "text/plain";
        }
        if (type != null) {
            if (DBG) {
                Log.d(TAG, "Setting type: " + type);
            }
            if (data != null) {
                this.intent.setDataAndType(Uri.parse((String)data), type);
            } else {
                this.intent.setType(type);
            }
        } else if (data != null) {
            this.intent.setData(Uri.parse((String)data));
        }
    }

    public void putExtra(String key, Object value) {
        if (value instanceof String) {
            this.intent.putExtra(key, (String)value);
        } else if (value instanceof Boolean) {
            this.intent.putExtra(key, (Serializable)((Boolean)value));
        } else if (value instanceof Double) {
            this.intent.putExtra(key, (Serializable)((Double)value));
        } else if (value instanceof Integer) {
            this.intent.putExtra(key, (Serializable)((Integer)value));
        } else if (value instanceof Long) {
            this.intent.putExtra(key, (Serializable)((Long)value));
        } else {
            Log.w(TAG, "Warning unimplemented put conversion for " + value.getClass().getCanonicalName() + " trying String");
            this.intent.putExtra(key, TiConvert.toString(value));
        }
    }

    public void addFlags(int flags) {
        this.intent.addFlags(flags);
    }

    public void setFlags(int flags) {
        this.intent.setFlags(flags);
    }

    public int getFlags() {
        return this.intent.getFlags();
    }

    public void putExtraUri(String key, String uri) {
        this.intent.putExtra(key, (Parcelable)Uri.parse((String)uri));
    }

    public void addCategory(String category) {
        if (category != null) {
            if (DBG) {
                Log.d(TAG, "Adding category: " + category);
            }
            this.intent.addCategory(category);
        }
    }

    public String getStringExtra(String name) {
        return this.intent.getStringExtra(name);
    }

    public boolean getBooleanExtra(String name, boolean defaultValue) {
        return this.intent.getBooleanExtra(name, defaultValue);
    }

    public int getIntExtra(String name, int defaultValue) {
        return this.intent.getIntExtra(name, defaultValue);
    }

    public long getLongExtra(String name, long defaultValue) {
        return this.intent.getLongExtra(name, defaultValue);
    }

    public double getDoubleExtra(String name, double defaultValue) {
        return this.intent.getDoubleExtra(name, defaultValue);
    }

    public String getData() {
        return this.intent.getDataString();
    }

    public Intent getIntent() {
        return this.intent;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean hasExtra(String name) {
        if (this.intent != null) {
            return this.intent.hasExtra(name);
        }
        return false;
    }
}

