/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.proxy;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.kroll.annotations.Kroll;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.kroll.KrollCallback;
import org.appcelerator.titanium.proxy.IntentProxy;
import org.appcelerator.titanium.util.TiActivityResultHandler;
import org.appcelerator.titanium.util.TiActivitySupport;
import org.appcelerator.titanium.util.TiActivitySupportHelper;
import org.appcelerator.titanium.util.TiConfig;

public class ActivityProxy
extends KrollProxy
implements TiActivityResultHandler {
    private static final String TAG = "ActivityProxy";
    private static boolean DBG = TiConfig.LOGD;
    protected Activity activity;
    protected IntentProxy intentProxy;
    protected KrollCallback resultCallback;

    public ActivityProxy(TiContext tiContext) {
        super(tiContext);
    }

    public ActivityProxy(TiContext tiContext, Activity activity) {
        this(tiContext);
        this.setActivity(tiContext, activity);
    }

    public void setActivity(TiContext tiContext, Activity activity) {
        this.activity = activity;
        Intent intent = activity.getIntent();
        if (intent != null) {
            this.intentProxy = new IntentProxy(tiContext, activity.getIntent());
        }
    }

    protected Activity getActivity(KrollInvocation invocation) {
        Activity activity = this.activity;
        if (activity != null) {
            return activity;
        }
        if (invocation != null && (activity = invocation.getTiContext().getActivity()) != null) {
            return activity;
        }
        activity = this.getTiContext().getActivity();
        if (activity != null) {
            return activity;
        }
        activity = this.getTiContext().getRootActivity();
        if (activity != null) {
            return activity;
        }
        return null;
    }

    public void startActivity(KrollInvocation invocation, IntentProxy intent) {
        Activity activity = this.getActivity(invocation);
        if (activity != null) {
            activity.startActivity(intent.getIntent());
        }
    }

    public void startActivityForResult(KrollInvocation invocation, IntentProxy intent, KrollCallback callback) {
        Activity activity = this.getActivity(invocation);
        if (activity != null) {
            TiActivitySupport support = null;
            support = activity instanceof TiActivitySupport ? (TiActivitySupport)activity : new TiActivitySupportHelper(activity);
            this.resultCallback = callback;
            int requestCode = support.getUniqueResultCode();
            support.launchActivityForResult(intent.getIntent(), requestCode, this);
        }
    }

    public void startActivityFromChild(KrollInvocation invocation, ActivityProxy child, IntentProxy intent, int requestCode) {
        Activity activity = this.getActivity(invocation);
        if (activity != null) {
            activity.startActivityFromChild(child.getActivity(), intent.getIntent(), requestCode);
        }
    }

    public boolean startActivityIfNeeded(KrollInvocation invocation, IntentProxy intent, int requestCode) {
        Activity activity = this.getActivity(invocation);
        if (activity != null) {
            return activity.startActivityIfNeeded(intent.getIntent(), requestCode);
        }
        return false;
    }

    public boolean startNextMatchingActivity(KrollInvocation invocation, IntentProxy intent) {
        Activity activity = this.getActivity(invocation);
        if (activity != null) {
            return activity.startNextMatchingActivity(intent.getIntent());
        }
        return false;
    }

    public String getString(KrollInvocation invocation, int resId, Object[] formatArgs) {
        Activity activity = this.getActivity(invocation);
        if (activity != null) {
            if (formatArgs == null || formatArgs.length == 0) {
                return activity.getString(resId);
            }
            return activity.getString(resId, formatArgs);
        }
        return null;
    }

    public IntentProxy getIntent() {
        return this.intentProxy;
    }

    public void setRequestedOrientation(KrollInvocation invocation, int orientation) {
        Activity activity = this.getActivity(invocation);
        if (activity != null) {
            activity.setRequestedOrientation(orientation);
        }
    }

    public void setResult(KrollInvocation invocation, int resultCode, @Kroll.argument(optional=true) IntentProxy intent) {
        Activity activity = this.getActivity(invocation);
        if (activity != null) {
            if (intent == null) {
                activity.setResult(resultCode);
            } else {
                activity.setResult(resultCode, intent.getIntent());
            }
        }
    }

    public void finish(KrollInvocation invocation) {
        Activity activity = this.getActivity(invocation);
        if (activity != null) {
            activity.finish();
        }
    }

    @Override
    public void onResult(Activity activity, int requestCode, int resultCode, Intent data) {
        if (this.resultCallback == null) {
            return;
        }
        KrollDict event = new KrollDict();
        event.put("requestCode", requestCode);
        event.put("resultCode", resultCode);
        event.put("intent", new IntentProxy(this.getTiContext(), data));
        event.put("source", this);
        this.resultCallback.callAsync(event);
    }

    @Override
    public void onError(Activity activity, int requestCode, Exception e) {
        if (this.resultCallback == null) {
            return;
        }
        KrollDict event = new KrollDict();
        event.put("requestCode", requestCode);
        event.put("error", e.getMessage());
        event.put("source", this);
        this.resultCallback.callAsync(event);
    }

    public Context getContext() {
        if (this.activity == null) {
            return this.getTiContext().getActivity().getApplication();
        }
        return this.activity;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public void release() {
        this.activity = null;
    }
}

