/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.kroll;

import android.os.Looper;
import android.os.Process;
import org.appcelerator.titanium.kroll.KrollContext;
import org.appcelerator.titanium.util.TiConfig;

public class KrollHandlerThread
extends Thread {
    private static final String TAG = "KrollHandlerThread";
    private static final boolean DBG = TiConfig.DEBUG;
    private int mPriority;
    private int mTid = -1;
    private Looper mLooper;
    private KrollContext krollContext;

    public KrollHandlerThread(String name, KrollContext krollContext) {
        this(name, 0, krollContext);
    }

    public KrollHandlerThread(String name, int priority, KrollContext krollContext) {
        super(name);
        this.mPriority = priority;
        this.krollContext = krollContext;
    }

    public KrollHandlerThread(String name, int priority, int stackSize, KrollContext krollContext) {
        super(null, null, name, stackSize);
        this.mPriority = priority;
        this.krollContext = krollContext;
    }

    protected void onLooperPrepared() {
        this.krollContext.initContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.mTid = Process.myTid();
        Looper.prepare();
        KrollHandlerThread krollHandlerThread = this;
        synchronized (krollHandlerThread) {
            this.mLooper = Looper.myLooper();
            Process.setThreadPriority((int)this.mPriority);
            this.notifyAll();
        }
        this.onLooperPrepared();
        Looper.loop();
        this.krollContext.threadEnded();
        this.mTid = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Looper getLooper() {
        if (!this.isAlive()) {
            return null;
        }
        KrollHandlerThread krollHandlerThread = this;
        synchronized (krollHandlerThread) {
            while (this.isAlive() && this.mLooper == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.mLooper;
    }

    public boolean quit() {
        Looper looper = this.getLooper();
        if (looper != null) {
            looper.quit();
            return true;
        }
        return false;
    }

    public int getThreadId() {
        return this.mTid;
    }

    public KrollContext getKrollContext() {
        return this.krollContext;
    }
}

