/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.kroll;

import android.app.Activity;
import android.os.Handler;
import android.os.Message;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.appcelerator.kroll.KrollEvaluator;
import org.appcelerator.titanium.TiApplication;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiMessageQueue;
import org.appcelerator.titanium.TiScriptRunner;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.io.TiFileFactory;
import org.appcelerator.titanium.kroll.KrollHandlerThread;
import org.appcelerator.titanium.kroll.KrollThreadListener;
import org.appcelerator.titanium.util.AsyncResult;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiFileHelper2;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class KrollContext
implements Handler.Callback {
    private static final String LCAT = "KrollContext";
    private static boolean DBG = TiConfig.DEBUG;
    private static final int MSG_EVAL_STRING = 1000;
    private static final int MSG_EVAL_FILE = 1001;
    private static final int MSG_EVAL_COMMONJS = 1002;
    private static final String STRING_SOURCE = "<anonymous>";
    public static final String CONTEXT_KEY = "krollContext";
    private static AtomicInteger instanceCounter;
    private static KrollEvaluator defaultEvaluator;
    private static KrollEvaluator evaluator;
    private static KrollThreadListener threadListener;
    private KrollHandlerThread thread;
    private TiContext tiContext;
    private ScriptableObject jsScope;
    private String sourceUrl;
    private int krollThreadId;
    private CountDownLatch initialized;
    private TiMessageQueue messageQueue;
    private boolean useOptimization;

    protected KrollContext(TiContext tiContext, String sourceUrl) {
        this.tiContext = tiContext;
        this.sourceUrl = sourceUrl;
        this.krollThreadId = KrollContext.getInstanceCounter().incrementAndGet();
        StringBuilder threadName = new StringBuilder();
        threadName.append("kroll$").append(this.krollThreadId);
        if (sourceUrl != null) {
            threadName.append(": ").append(sourceUrl);
        }
        this.thread = new KrollHandlerThread(threadName.toString(), 0, tiContext.getTiApp().getThreadStackSize(), this);
        this.initialized = new CountDownLatch(1);
        TiApplication app = tiContext.getTiApp();
        this.useOptimization = app.getDeployType() == "production" || app.forceCompileJS();
        this.thread.start();
        this.requireInitialized();
    }

    public static KrollEvaluator getDefaultKrollEvaluator() {
        return defaultEvaluator;
    }

    public static KrollEvaluator getKrollEvaluator() {
        return evaluator;
    }

    public static void setKrollEvaluator(KrollEvaluator e) {
        evaluator = e;
    }

    public static void setThreadListener(KrollThreadListener l) {
        threadListener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initContext() {
        if (DBG) {
            Log.d(LCAT, "Context Thread: " + Thread.currentThread().getName());
        }
        if (threadListener != null) {
            threadListener.threadStarted(this.thread);
        }
        this.messageQueue = TiMessageQueue.getMessageQueue();
        this.messageQueue.setCallback(this);
        Context ctx = this.enter();
        try {
            if (DBG) {
                Log.d(LCAT, "Context entered, preparing scope");
            }
            this.jsScope = ctx.initStandardObjects();
            if (DBG) {
                Log.d(LCAT, "Initialized scope: " + this.jsScope);
            }
            this.initialized.countDown();
        }
        finally {
            this.exit();
        }
    }

    protected void threadEnded() {
        if (threadListener != null) {
            threadListener.threadEnded(this.thread);
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1000: {
                AsyncResult result = (AsyncResult)msg.obj;
                String src = msg.getData().getString("src");
                result.setResult(this.handleEval(src));
                return true;
            }
            case 1001: {
                AsyncResult result = (AsyncResult)msg.obj;
                String filename = msg.getData().getString("filename");
                result.setResult(this.handleEvalFile(filename));
                return true;
            }
            case 1002: {
                AsyncResult result = (AsyncResult)msg.obj;
                String filename = msg.getData().getString("filename");
                result.setResult(this.handleEvalCommonJsModule(filename));
                return true;
            }
        }
        return false;
    }

    public void post(Runnable r) {
        this.messageQueue.post(r);
    }

    protected boolean isOurThread() {
        if (DBG) {
            Log.d(LCAT, "ThreadId: " + this.thread.getId() + " currentThreadId: " + Thread.currentThread().getId());
        }
        return this.thread.getId() == Thread.currentThread().getId();
    }

    public KrollHandlerThread getThread() {
        return this.thread;
    }

    public TiContext getTiContext() {
        return this.tiContext;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public int getKrollThreadId() {
        return this.krollThreadId;
    }

    public Scriptable getScope() {
        this.requireInitialized();
        return this.jsScope;
    }

    public Object evalFile(String filename) {
        if (DBG) {
            Log.i(LCAT, "evalFile: " + filename);
        }
        if (this.isOurThread()) {
            return this.handleEvalFile(filename);
        }
        AsyncResult result = new AsyncResult();
        Message msg = this.messageQueue.getHandler().obtainMessage(1001, (Object)result);
        msg.getData().putString("filename", filename);
        return TiMessageQueue.getMessageQueue().sendBlockingMessage(msg, this.messageQueue, result);
    }

    public Object evalCommonJsModule(String filename) {
        if (DBG) {
            Log.d(LCAT, "evalCommonJsModule: " + filename);
        }
        if (this.isOurThread()) {
            return this.handleEvalCommonJsModule(filename);
        }
        AsyncResult result = new AsyncResult();
        Message msg = this.messageQueue.getHandler().obtainMessage(1002, (Object)result);
        msg.getData().putString("filename", filename);
        return TiMessageQueue.getMessageQueue().sendBlockingMessage(msg, this.messageQueue, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object runCompiledScript(String filename) {
        String relativePath = TiFileHelper2.getResourceRelativePath(filename);
        if (relativePath == null) {
            return this.evaluateScript(filename);
        }
        Context context = this.enter(true);
        try {
            Log.d(LCAT, "Running pre-compiled script: " + relativePath);
            Object object = TiScriptRunner.getInstance().runScript(context, (Scriptable)this.jsScope, relativePath);
            return object;
        }
        catch (ClassNotFoundException e) {
            Log.e(LCAT, "Couldn't find pre-compiled class for script: " + relativePath, e);
        }
        finally {
            this.exit();
        }
        return ScriptableObject.NOT_FOUND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object runCompiledScriptAsModule(String filename) {
        String relativePath = TiFileHelper2.getResourceRelativePath(filename);
        if (relativePath == null) {
            return this.evaluateScript(filename);
        }
        Context context = this.enter(true);
        try {
            Scriptable scope = context.newObject((Scriptable)this.jsScope);
            Scriptable exports = context.newObject(scope);
            scope.put("exports", scope, (Object)exports);
            Log.i(LCAT, "Running CommonJS module script: " + relativePath);
            TiScriptRunner.getInstance().runScript(context, scope, relativePath);
            Scriptable scriptable = exports;
            return scriptable;
        }
        catch (ClassNotFoundException e) {
            Log.e(LCAT, "Couldn't find pre-compiled class for CommonJS module: " + relativePath, e);
        }
        finally {
            this.exit();
        }
        return ScriptableObject.NOT_FOUND;
    }

    public Object evaluateScript(String filename) {
        String[] parts = new String[]{filename};
        TiBaseFile tbf = TiFileFactory.createTitaniumFile(this.tiContext, parts, false);
        Context context = this.enter(false);
        return evaluator.evaluateFile(context, (Scriptable)this.jsScope, tbf, filename, 1, null);
    }

    public Object evaluateScriptAsModule(String filename) {
        String[] parts = new String[]{filename};
        TiBaseFile tbf = TiFileFactory.createTitaniumFile(this.tiContext, parts, false);
        if (!tbf.exists()) {
            Context.throwAsScriptRuntimeEx((Throwable)new Exception("Module file " + filename + " does not exist."));
            return null;
        }
        Log.i(LCAT, "Evaluating CommonJS module script: " + filename);
        Context context = this.enter(false);
        Scriptable scope = context.newObject((Scriptable)this.jsScope);
        Scriptable exports = context.newObject(scope);
        scope.put("exports", scope, (Object)exports);
        evaluator.evaluateFile(context, scope, tbf, filename, 1, null);
        return exports;
    }

    public Object handleEvalFile(String filename) {
        this.requireInitialized();
        Object result = null;
        try {
            result = this.useOptimization ? this.runCompiledScript(filename) : this.evaluateScript(filename);
        }
        catch (EcmaError e) {
            evaluator.handleEcmaError(e);
        }
        catch (EvaluatorException e) {
            evaluator.handleEvaluatorException(e);
        }
        catch (Exception e) {
            evaluator.handleException(e);
        }
        return result;
    }

    public Object handleEvalCommonJsModule(String filename) {
        this.requireInitialized();
        Object result = null;
        try {
            result = this.useOptimization ? this.runCompiledScriptAsModule(filename) : this.evaluateScriptAsModule(filename);
        }
        catch (EcmaError e) {
            evaluator.handleEcmaError(e);
        }
        catch (EvaluatorException e) {
            evaluator.handleEvaluatorException(e);
        }
        catch (Exception e) {
            evaluator.handleException(e);
        }
        return result;
    }

    public Object eval(String src) {
        if (this.isOurThread()) {
            return this.handleEval(src);
        }
        AsyncResult result = new AsyncResult();
        Message msg = this.messageQueue.getHandler().obtainMessage(1000, (Object)result);
        msg.getData().putString("src", src);
        return TiMessageQueue.getMessageQueue().sendBlockingMessage(msg, this.messageQueue, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleEval(String src) {
        this.requireInitialized();
        Object result = null;
        Context ctx = this.enter(false);
        try {
            result = evaluator.evaluateString(ctx, (Scriptable)this.jsScope, src, STRING_SOURCE, 1, null);
        }
        catch (EcmaError e) {
            evaluator.handleEcmaError(e);
        }
        catch (EvaluatorException e) {
            evaluator.handleEvaluatorException(e);
        }
        catch (Exception e) {
            evaluator.handleException(e);
        }
        finally {
            this.exit();
        }
        return result;
    }

    public InputStream getResourcesInputStream(String filename) throws IOException {
        InputStream is = null;
        Activity activity = this.tiContext.getActivity();
        if (activity != null) {
            is = activity.getAssets().open(TiFileHelper2.getResourcesPath(filename));
        }
        return is;
    }

    public void put(String name, Scriptable object) {
        this.jsScope.put(name, (Scriptable)this.jsScope, (Object)object);
    }

    public Context enter() {
        return this.enter(this.useOptimization);
    }

    public Context enter(boolean useOptimization) {
        Context ctx = Context.enter();
        if (!useOptimization) {
            ctx.setOptimizationLevel(-1);
        }
        ctx.setErrorReporter((ErrorReporter)this.getTiContext());
        ctx.putThreadLocal((Object)CONTEXT_KEY, (Object)this);
        return ctx;
    }

    public void exit() {
        Context.exit();
    }

    public static KrollContext getKrollContext(Context context) {
        return (KrollContext)context.getThreadLocal((Object)CONTEXT_KEY);
    }

    public static KrollContext getCurrentKrollContext() {
        Context ctx = Context.getCurrentContext();
        if (ctx == null) {
            return null;
        }
        return KrollContext.getKrollContext(ctx);
    }

    private void requireInitialized() {
        try {
            this.initialized.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected static AtomicInteger getInstanceCounter() {
        if (instanceCounter == null) {
            instanceCounter = new AtomicInteger();
        }
        return instanceCounter;
    }

    public static final KrollContext createContext(TiContext tiContext, String loadFile) {
        return new KrollContext(tiContext, loadFile);
    }

    public TiMessageQueue getMessageQueue() {
        return this.messageQueue;
    }

    public void release() {
        if (this.thread.getLooper() != null) {
            this.thread.getLooper().quit();
        }
    }

    static {
        evaluator = defaultEvaluator = new DefaultEvaluator();
    }

    public static final class DefaultEvaluator
    implements KrollEvaluator {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object evaluateFile(Context context, Scriptable scope, TiBaseFile file, String filename, int lineNo, Object securityDomain) {
            BufferedReader br = null;
            Object result = Scriptable.NOT_FOUND;
            try {
                br = new BufferedReader(new InputStreamReader(file.getInputStream()), 4000);
                Log.d(KrollContext.LCAT, "Running evaluated script: " + filename);
                result = context.evaluateReader(scope, (Reader)br, filename, 1, null);
            }
            catch (IOException e) {
                Log.e(KrollContext.LCAT, "IOException reading file: " + filename, e);
                Context.throwAsScriptRuntimeEx((Throwable)e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {}
                }
            }
            return result;
        }

        @Override
        public Object evaluateString(Context context, Scriptable scope, String src, String sourceName, int lineNo, Object securityDomain) {
            return context.evaluateString(scope, src, sourceName, lineNo, securityDomain);
        }

        @Override
        public void handleEcmaError(EcmaError error) {
            Log.e(KrollContext.LCAT, "ECMA Error evaluating source: " + error.getMessage(), error);
            Context.reportRuntimeError((String)error.getMessage(), (String)error.sourceName(), (int)error.lineNumber(), (String)error.lineSource(), (int)error.columnNumber());
        }

        @Override
        public void handleEvaluatorException(EvaluatorException ex) {
            Log.e(KrollContext.LCAT, "Error evaluating source: " + ex.getMessage(), ex);
            Context.reportRuntimeError((String)ex.getMessage(), (String)ex.sourceName(), (int)ex.lineNumber(), (String)ex.lineSource(), (int)ex.columnNumber());
        }

        @Override
        public void handleException(Exception ex) {
            Log.e(KrollContext.LCAT, "Error: " + ex.getMessage(), ex);
            Context.throwAsScriptRuntimeEx((Throwable)ex);
        }
    }
}

