/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.kroll;

import org.appcelerator.kroll.KrollConvertable;
import org.appcelerator.kroll.KrollConverter;
import org.appcelerator.kroll.KrollDict;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollMethod;
import org.appcelerator.kroll.KrollObject;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.kroll.KrollContext;
import org.appcelerator.titanium.util.Log;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class KrollCallback
extends KrollMethod
implements KrollConvertable {
    private static final String LCAT = "KrollCallback";
    protected static final String ANONYMOUS_METHOD_NAME = "(anonymous)";
    protected KrollContext kroll;
    protected Scriptable scope;
    protected Scriptable thisObj;
    protected Function method;

    public KrollCallback(KrollContext context, Scriptable scope, Scriptable thisObj, Function method2) {
        super(null);
        this.kroll = context;
        this.scope = scope;
        this.thisObj = thisObj;
        this.method = method2;
    }

    public boolean isWithinTiContext(TiContext context) {
        TiContext krollTiContext;
        if (this.kroll != null && (krollTiContext = this.kroll.getTiContext()) != null) {
            return krollTiContext.equals(context);
        }
        return false;
    }

    protected KrollInvocation createInvocation() {
        return this.createInvocation(null);
    }

    protected KrollInvocation createInvocation(TiContext context) {
        String m;
        String methodName = ANONYMOUS_METHOD_NAME;
        Object methodNameObject = this.method.get("name", (Scriptable)this.method);
        if (methodNameObject != null && methodNameObject instanceof String && (m = (String)methodNameObject).length() > 0) {
            methodName = m;
        }
        if (context == null) {
            context = this.kroll == null ? TiContext.getCurrentTiContext() : this.kroll.getTiContext();
        }
        KrollProxy proxy2 = this.thisObj instanceof KrollObject ? ((KrollObject)this.thisObj).getProxy() : null;
        KrollInvocation inv = KrollInvocation.createMethodInvocation(context, this.scope, this.thisObj, methodName, this, proxy2);
        return inv;
    }

    public void callAsync() {
        this.callAsync(new Object[0]);
    }

    public void callAsync(KrollDict properties) {
        this.callAsync(new Object[]{properties});
    }

    public void callAsync(Object[] args) {
        this.callAsync(null, args);
    }

    public void callAsync(TiContext context, Object[] args) {
        KrollInvocation invocation = this.createInvocation(context);
        this.callAsync(invocation, args, true);
    }

    public Object callSync() {
        return this.callSync(new Object[0]);
    }

    public Object callSync(KrollDict properties) {
        return this.callSync(new Object[]{properties});
    }

    public Object callSync(Object[] args) {
        return this.callSync((TiContext)null, args);
    }

    public Object callSync(TiContext context, Object[] args) {
        KrollInvocation invocation = this.createInvocation(context);
        Object result = this.callSync(invocation, args);
        invocation.recycle();
        return result;
    }

    protected KrollContext getKrollContext(KrollInvocation invocation) {
        KrollContext kroll = null;
        if (invocation.getTiContext() != null) {
            kroll = invocation.getTiContext().getKrollContext();
        }
        if (kroll == null) {
            kroll = this.kroll;
        }
        return kroll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callSync(KrollInvocation invocation, Object[] args) {
        if (args == null) {
            args = new Object[]{};
        }
        KrollContext kroll = this.getKrollContext(invocation);
        Context ctx = kroll.enter();
        try {
            Object[] jsArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object jsArg;
                jsArgs[i] = jsArg = KrollConverter.getInstance().convertNative(invocation, args[i]);
            }
            Object object = KrollConverter.getInstance().convertJavascript(invocation, this.method.call(ctx, this.scope, this.thisObj, jsArgs), Object.class);
            return object;
        }
        catch (EcmaError e) {
            Log.e(LCAT, "ECMA Error evaluating source, invocation: " + invocation + ", message: " + e.getMessage(), e);
            Context.reportRuntimeError((String)e.getMessage(), (String)e.sourceName(), (int)e.lineNumber(), (String)e.lineSource(), (int)e.columnNumber());
        }
        catch (EvaluatorException e) {
            Log.e(LCAT, "Error evaluating source, invocation: " + invocation + ", message: " + e.getMessage(), e);
            Context.reportRuntimeError((String)e.getMessage(), (String)e.sourceName(), (int)e.lineNumber(), (String)e.lineSource(), (int)e.columnNumber());
        }
        catch (Exception e) {
            Log.e(LCAT, "Error, invocation: " + invocation + ", message: " + e.getMessage(), e);
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
        catch (Throwable e) {
            Log.e(LCAT, "Unhandled throwable, invocation:" + invocation + ", message: " + e.getMessage(), e);
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
        finally {
            kroll.exit();
        }
        return KrollProxy.UNDEFINED;
    }

    public void callAsync(final KrollInvocation invocation, final Object[] args, final boolean recycleInvocation) {
        KrollContext kroll = this.getKrollContext(invocation);
        kroll.getMessageQueue().getHandler().post(new Runnable(){

            @Override
            public void run() {
                KrollCallback.this.callSync(invocation, args);
                if (recycleInvocation) {
                    invocation.recycle();
                }
            }
        });
    }

    @Override
    public Object invoke(KrollInvocation invocation, Object[] args) {
        KrollInvocation invocationCopy = invocation.copy();
        this.callAsync(invocationCopy, args, true);
        return KrollProxy.UNDEFINED;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KrollCallback)) {
            return false;
        }
        KrollCallback kb = (KrollCallback)obj;
        return this.method.equals(kb.method);
    }

    public Object toJSFunction() {
        return Context.javaToJS((Object)this.method, (Scriptable)this.kroll.getScope());
    }

    public Function getMethod() {
        return this.method;
    }

    public void setThisObj(Scriptable thisObj) {
        this.thisObj = thisObj;
    }

    public void setThisProxy(KrollProxy proxy2) {
        this.setThisObj((Scriptable)proxy2.getKrollObject());
    }

    @Override
    public Object getJavascriptValue() {
        return this.getMethod();
    }

    @Override
    public Object getNativeValue() {
        return this;
    }
}

