/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.kroll;

import java.io.IOException;
import org.appcelerator.kroll.KrollConverter;
import org.appcelerator.kroll.KrollInvocation;
import org.appcelerator.kroll.KrollModule;
import org.appcelerator.kroll.KrollObject;
import org.appcelerator.kroll.KrollProxy;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.kroll.KrollContext;
import org.mozilla.javascript.Scriptable;
import ti.modules.titanium.TitaniumModule;

public class KrollBridge {
    private static TitaniumModule tiModule;
    private KrollContext kroll;
    private KrollObject titanium;

    public KrollBridge(KrollContext kroll) {
        this.kroll = kroll;
        TiContext tiContext = kroll.getTiContext();
        tiContext.setKrollBridge(this);
        if (tiModule == null) {
            tiModule = new TitaniumModule(kroll.getTiContext());
        }
        this.titanium = new KrollObject(tiModule);
        tiModule.bindContextSpecific(this);
        tiContext.getTiApp().bindModules(this, tiModule);
    }

    public Scriptable getObject(Scriptable globalObject, String ... objects) {
        Scriptable object = globalObject;
        for (int i = 0; i < objects.length; ++i) {
            Object child = object.get(objects[i], object);
            if (!(child instanceof Scriptable)) {
                return null;
            }
            object = (Scriptable)child;
        }
        return object;
    }

    public KrollObject getObject(String ... objects) {
        Scriptable sObject = this.getObject((Scriptable)this.titanium, objects);
        if (sObject instanceof KrollObject) {
            return (KrollObject)sObject;
        }
        return null;
    }

    public KrollObject getObject(String name) {
        if (name == null) {
            return this.titanium;
        }
        return this.getObject(name.split("\\."));
    }

    public void bindToTopLevel(String topLevelName, Object value) {
        if (value instanceof KrollProxy) {
            value = ((KrollProxy)value).getKrollObject();
        }
        Scriptable parent = this.kroll.getScope();
        String name = topLevelName;
        if (topLevelName.contains(".")) {
            int lastDot = topLevelName.lastIndexOf(".");
            String parentName = topLevelName.substring(0, lastDot);
            parent = this.getObject(this.kroll.getScope(), parentName.split("\\."));
            if (parent == null) {
                parent = this.kroll.getScope();
            } else {
                name = topLevelName.substring(lastDot + 1);
            }
        }
        parent.put(name, parent, value);
    }

    public void bindToTopLevel(String topLevelName, String objectName) {
        this.bindToTopLevel(topLevelName, (Object)this.getObject(objectName));
    }

    public void bindContextSpecific(String ctxSpecificName, String objectName) {
        int lastDot = ctxSpecificName.lastIndexOf(46);
        if (lastDot < 0) {
            return;
        }
        String objName = ctxSpecificName.substring(0, lastDot);
        String ctxName = ctxSpecificName.substring(lastDot + 1);
        Scriptable object = this.getObject((Scriptable)this.titanium, objectName);
        this.bindContextSpecific(objName, ctxName, object);
    }

    public void bindContextSpecific(String objectName, String ctxSpecificName, Object value) {
        KrollObject object = this.titanium;
        if (objectName != null) {
            object = this.getObject((Scriptable)this.titanium, objectName);
        }
        if (object != null) {
            KrollInvocation invocation = KrollInvocation.createPropertySetInvocation((Scriptable)object, (Scriptable)object, ctxSpecificName, null, null);
            Object convertedValue = KrollConverter.getInstance().convertNative(invocation, value);
            object.put(ctxSpecificName, (Scriptable)object, convertedValue);
            invocation.recycle();
        }
    }

    public KrollModule getModule(String moduleName) {
        KrollObject object = this.getObject(moduleName);
        if (object != null) {
            return (KrollModule)object.getProxy();
        }
        return null;
    }

    public Object evalFile(String filename) throws IOException {
        return this.kroll.evalFile(filename);
    }

    public Object evalCommonJsModule(String filename) throws IOException {
        return this.kroll.evalCommonJsModule(filename);
    }

    public Object evalJS(String src) {
        return this.kroll.eval(src);
    }

    public KrollContext getKrollContext() {
        return this.kroll;
    }

    public Scriptable getScope() {
        return this.kroll.getScope();
    }

    public KrollProxy getRootObject() {
        return this.titanium.getProxy();
    }

    public void release() {
        if (this.kroll != null) {
            this.kroll.release();
            this.kroll = null;
        }
    }
}

