/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.io;

import android.database.Cursor;
import android.net.Uri;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.io.TiBaseFile;

public class TitaniumBlob
extends TiBaseFile {
    protected String url;
    protected String name;
    protected String path;

    public TitaniumBlob(TiContext tiContext, String url) {
        super(tiContext, 3);
        this.url = url;
        if (url != null) {
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        String[] projection = new String[]{"_display_name", "_data"};
        Cursor c = null;
        try {
            c = this.getTiContext().getActivity().getContentResolver().query(Uri.parse((String)this.url), projection, null, null, null);
            if (c.moveToNext()) {
                this.name = c.getString(0);
                this.path = c.getString(1);
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    public void setUrl(String url) {
        this.url = url;
        if (url != null) {
            this.init();
        }
    }

    @Override
    public String nativePath() {
        return this.url;
    }

    public String toURL() {
        return this.url;
    }

    @Override
    public String name() {
        return this.name;
    }

    public File getFile() {
        return new File(this.path);
    }

    public String getContentType() {
        return this.getTiContext().getActivity().getContentResolver().getType(Uri.parse((String)this.url));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getTiContext().getActivity().getContentResolver().openInputStream(Uri.parse((String)this.url));
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    @Override
    public File getNativeFile() {
        return new File(this.path);
    }
}

