/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.io;

import android.content.ContextWrapper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.TiFastDev;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;
import org.appcelerator.titanium.util.TiFileHelper2;

public class TiResourceFile
extends TiBaseFile {
    private static final String LCAT = "TiResourceFile";
    private static final boolean DBG = TiConfig.LOGD;
    private final String path;

    public TiResourceFile(TiContext tiContext, String path) {
        super(tiContext, 2);
        this.path = path;
    }

    @Override
    public TiBaseFile resolve() {
        return this;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream in = null;
        ContextWrapper context = this.getTiContext().getAndroidContext();
        if (context != null) {
            String p = TiFileHelper2.joinSegments("Resources", this.path);
            in = TiFastDev.isFastDevEnabled() ? TiFastDev.getInstance().openInputStream(this.path) : context.getAssets().open(p);
        }
        return in;
    }

    @Override
    public OutputStream getOutputStream() {
        return null;
    }

    @Override
    public File getNativeFile() {
        return new File(this.toURL());
    }

    @Override
    public void write(String data, boolean append) throws IOException {
        throw new IOException("read only");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void open(int mode, boolean binary) throws IOException {
        if (mode != 0) throw new IOException("Resource file may not be written.");
        InputStream in = this.getInputStream();
        if (in == null) throw new FileNotFoundException("File does not exist: " + this.path);
        if (binary) {
            this.instream = new BufferedInputStream(in);
        } else {
            this.inreader = new BufferedReader(new InputStreamReader(in, "utf-8"));
        }
        this.opened = true;
    }

    @Override
    public TiBlob read() throws IOException {
        return TiBlob.blobFromFile(this.getTiContext(), this);
    }

    @Override
    public String readLine() throws IOException {
        String result = null;
        if (!this.opened) {
            throw new IOException("Must open before calling readLine");
        }
        if (this.binary) {
            throw new IOException("File opened in binary mode, readLine not available.");
        }
        try {
            result = this.inreader.readLine();
        }
        catch (IOException e) {
            Log.e(LCAT, "Error reading a line from the file: ", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        boolean result = false;
        InputStream is = null;
        try {
            is = this.getInputStream();
            result = is != null;
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    @Override
    public String name() {
        int idx = this.path.lastIndexOf("/");
        if (idx != -1) {
            return this.path.substring(idx);
        }
        return this.path;
    }

    @Override
    public String extension() {
        int idx = this.path.lastIndexOf(".");
        if (idx != -1) {
            return this.path.substring(idx + 1);
        }
        return null;
    }

    @Override
    public String nativePath() {
        return this.toURL();
    }

    @Override
    public double spaceAvailable() {
        return 0.0;
    }

    public String toURL() {
        return "file:///android_asset/Resources/" + this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() {
        if (TiFastDev.isFastDevEnabled()) {
            return TiFastDev.getInstance().getLength(this.path);
        }
        long length = 0L;
        InputStream is = null;
        try {
            is = this.getInputStream();
            length = is.available();
        }
        catch (IOException e) {
            Log.w(LCAT, "Error while trying to determine file size: " + e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Log.w(LCAT, e.getMessage(), e);
                }
            }
        }
        return length;
    }

    @Override
    public List<String> getDirectoryListing() {
        ArrayList<String> listing = new ArrayList<String>();
        try {
            String[] names;
            String lpath = TiFileHelper2.joinSegments("Resources", this.path);
            if (lpath.endsWith("/")) {
                lpath = lpath.substring(0, lpath.lastIndexOf("/"));
            }
            if ((names = this.getTiContext().getAndroidContext().getAssets().list(lpath)) != null) {
                int len = names.length;
                for (int i = 0; i < len; ++i) {
                    listing.add(names[i]);
                }
            }
        }
        catch (IOException e) {
            Log.e(LCAT, "Error while getting a directory listing: " + e.getMessage(), e);
        }
        return listing;
    }

    public String toString() {
        return this.toURL();
    }
}

