/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.io;

import android.net.Uri;
import android.os.StatFs;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.io.TiBaseFile;
import org.appcelerator.titanium.io.TiFileFactory;
import org.appcelerator.titanium.util.Log;
import org.appcelerator.titanium.util.TiConfig;

public class TiFile
extends TiBaseFile {
    private static final String LCAT = "TiFile";
    private static final boolean DBG = TiConfig.LOGD;
    private final File file;
    private final String path;

    public TiFile(TiContext tiContext, File file, String path, boolean stream) {
        super(tiContext, 1);
        this.file = file;
        this.path = path;
        this.stream = stream;
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    @Override
    public boolean isReadonly() {
        return this.file.canRead() && !this.file.canWrite();
    }

    @Override
    public boolean isWriteable() {
        return this.file.canWrite();
    }

    @Override
    public boolean createDirectory(boolean recursive) {
        if (recursive) {
            return this.file.mkdirs();
        }
        return this.file.mkdir();
    }

    private boolean deleteTree(File d) {
        File[] files;
        boolean deleted = true;
        for (File f : files = d.listFiles()) {
            if (f.isFile()) {
                deleted = f.delete();
                if (deleted) continue;
                break;
            }
            if (!this.deleteTree(f)) break;
            deleted = f.delete();
        }
        return deleted;
    }

    @Override
    public boolean deleteDirectory(boolean recursive) {
        boolean deleted = false;
        if (recursive) {
            deleted = this.deleteTree(this.file);
            if (deleted) {
                deleted = this.file.delete();
            }
        } else {
            deleted = this.file.delete();
        }
        return deleted;
    }

    @Override
    public boolean deleteFile() {
        return this.file.delete();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public double createTimestamp() {
        return this.file.lastModified();
    }

    @Override
    public double modificationTimestamp() {
        return this.file.lastModified();
    }

    @Override
    public String name() {
        return this.file.getName();
    }

    @Override
    public String extension() {
        String name = this.file.getName();
        int idx = name.lastIndexOf(".");
        if (idx != -1) {
            return name.substring(idx + 1);
        }
        return null;
    }

    @Override
    public String nativePath() {
        String p = null;
        if (this.file != null) {
            p = "file://" + this.file.getAbsolutePath();
        }
        return p;
    }

    public String toURL() {
        String url = null;
        url = Uri.fromFile((File)this.file).toString();
        return url;
    }

    @Override
    public long size() {
        return this.file.length();
    }

    @Override
    public double spaceAvailable() {
        StatFs stat = new StatFs(this.file.getPath());
        return (double)stat.getAvailableBlocks() * (double)stat.getBlockSize();
    }

    @Override
    public boolean setReadonly() {
        this.file.setReadOnly();
        return this.isReadonly();
    }

    public String toString() {
        return this.path;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(1);
    }

    public OutputStream getOutputStream(int mode) throws IOException {
        return new FileOutputStream(this.file, mode == 2);
    }

    @Override
    public File getNativeFile() {
        return this.file;
    }

    @Override
    public List<String> getDirectoryListing() {
        File dir = this.getNativeFile();
        ArrayList<String> listing = new ArrayList<String>();
        String[] names = dir.list();
        if (names != null) {
            int len = names.length;
            for (int i = 0; i < len; ++i) {
                listing.add(names[i]);
            }
        }
        return listing;
    }

    @Override
    public TiBaseFile getParent() {
        File p;
        TiBaseFile parentFile = null;
        File f = this.getNativeFile();
        if (f != null && (p = f.getParentFile()) != null) {
            parentFile = TiFileFactory.createTitaniumFile(this.getTiContext(), "file://" + p.getAbsolutePath(), false);
        }
        return parentFile;
    }

    @Override
    public void open(int mode, boolean binary) throws IOException {
        this.binary = binary;
        if (mode == 0) {
            if (!this.file.exists()) {
                throw new FileNotFoundException(this.file.getAbsolutePath());
            }
            if (binary) {
                this.instream = new BufferedInputStream(this.getInputStream());
            } else {
                this.inreader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "utf-8"));
            }
        } else {
            OutputStream os = this.getOutputStream(mode);
            if (binary) {
                this.outstream = new BufferedOutputStream(os);
            } else {
                this.outwriter = new BufferedWriter(new OutputStreamWriter(os));
            }
            Object var3_3 = null;
        }
        this.opened = true;
    }

    @Override
    public TiBlob read() throws IOException {
        return TiBlob.blobFromFile(this.getTiContext(), this);
    }

    @Override
    public String readLine() throws IOException {
        String result = null;
        if (!this.opened) {
            throw new IOException("Must open before calling readLine");
        }
        if (this.binary) {
            throw new IOException("File opened in binary mode, readLine not available.");
        }
        try {
            result = this.inreader.readLine();
        }
        catch (IOException e) {
            Log.e(LCAT, "Error reading a line from the file: ", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(TiBlob blob, boolean append) throws IOException {
        if (DBG) {
            Log.d(LCAT, "write called for file = " + this.file);
        }
        if (blob != null) {
            if (!this.stream) {
                try {
                    this.open(append ? 2 : 1, true);
                    this.copyStream(blob.getInputStream(), this.outstream);
                }
                finally {
                    this.close();
                }
            } else {
                if (!this.opened) {
                    throw new IOException("Must open before calling write");
                }
                if (this.binary) {
                    this.copyStream(blob.getInputStream(), this.outstream);
                } else {
                    this.outwriter.write(new String(blob.getBytes(), "UTF-8"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFromUrl(String url, boolean append) throws IOException {
        String[] parts;
        TiBaseFile f;
        TiContext tiContext;
        if (DBG) {
            Log.d(LCAT, "write called for file = " + this.file);
        }
        if ((tiContext = this.getTiContext()) != null && (f = TiFileFactory.createTitaniumFile(tiContext, parts = new String[]{url}, append)) != null) {
            if (!this.stream) {
                InputStream is = null;
                try {
                    this.open(append ? 2 : 1, true);
                    is = f.getInputStream();
                    this.copyStream(is, this.outstream);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    this.close();
                }
            }
            if (!this.opened) {
                throw new IOException("Must open before calling write");
            }
            if (this.binary) {
                InputStream is = null;
                try {
                    is = f.getInputStream();
                    this.copyStream(is, this.outstream);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            BufferedReader ir = null;
            try {
                ir = new BufferedReader(new InputStreamReader(f.getInputStream(), "utf-8"));
                this.copyStream(ir, this.outwriter);
            }
            finally {
                if (ir != null) {
                    ir.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String data, boolean append) throws IOException {
        if (DBG) {
            Log.d(LCAT, "write called for file = " + this.file);
        }
        if (!this.stream) {
            try {
                this.open(append ? 2 : 1, false);
                this.outwriter.write(data);
            }
            finally {
                this.close();
            }
        } else {
            if (!this.opened) {
                throw new IOException("Must open before calling write");
            }
            if (this.binary) {
                this.outstream.write(data.getBytes());
            } else {
                this.outwriter.write(data);
            }
        }
    }

    @Override
    public void writeLine(String data) throws IOException {
        if (!this.opened) {
            throw new IOException("Must open before calling readLine");
        }
        if (this.binary) {
            throw new IOException("File opened in binary mode, writeLine not available.");
        }
        this.outwriter.write(data);
        this.outwriter.write("\n");
    }
}

