/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.List;
import org.appcelerator.titanium.TiBlob;
import org.appcelerator.titanium.TiContext;
import org.appcelerator.titanium.io.TiFileFactory;
import org.appcelerator.titanium.util.Log;

public abstract class TiBaseFile {
    private static final String LCAT = "TiBaseFile";
    public static final int MODE_READ = 0;
    public static final int MODE_WRITE = 1;
    public static final int MODE_APPEND = 2;
    protected static final int TYPE_FILE = 1;
    protected static final int TYPE_RESOURCE = 2;
    protected static final int TYPE_BLOB = 3;
    protected int type;
    protected boolean typeFile;
    protected boolean typeDir;
    protected boolean flagHidden;
    protected boolean flagSymbolicLink;
    protected boolean modeExecutable;
    protected boolean modeRead;
    protected boolean modeWrite;
    protected boolean opened;
    protected InputStream instream;
    protected BufferedReader inreader;
    protected OutputStream outstream;
    protected BufferedWriter outwriter;
    protected boolean stream;
    protected boolean binary;
    protected WeakReference<TiContext> weakTiContext;

    protected TiBaseFile(TiContext tiContext, int type) {
        this.weakTiContext = new WeakReference<TiContext>(tiContext);
        this.type = type;
        this.typeFile = true;
        this.typeDir = false;
        this.flagHidden = false;
        this.flagSymbolicLink = false;
        this.modeExecutable = false;
        this.modeRead = true;
        this.modeWrite = false;
        this.opened = false;
        this.instream = null;
        this.inreader = null;
        this.outstream = null;
        this.outwriter = null;
        this.stream = false;
        this.binary = false;
    }

    protected TiContext getTiContext() {
        return (TiContext)this.weakTiContext.get();
    }

    public boolean isFile() {
        return this.typeFile;
    }

    public boolean isDirectory() {
        return this.typeDir;
    }

    public boolean isExecutable() {
        return this.modeExecutable;
    }

    public boolean isReadonly() {
        return this.modeRead && !this.modeWrite;
    }

    public boolean isWriteable() {
        return this.modeWrite;
    }

    public boolean isHidden() {
        return this.flagHidden;
    }

    public boolean isSymbolicLink() {
        return this.flagSymbolicLink;
    }

    public boolean copy(String destination) throws IOException {
        TiContext tiContext;
        InputStream is = null;
        OutputStream os = null;
        boolean copied = false;
        if (destination != null && (tiContext = this.getTiContext()) != null) {
            try {
                String[] parts;
                TiBaseFile bf;
                is = this.getInputStream();
                if (is != null && (bf = TiFileFactory.createTitaniumFile(tiContext, parts = new String[]{destination}, false)) != null && (os = bf.getOutputStream()) != null) {
                    byte[] buf = new byte[8096];
                    int count = 0;
                    is = new BufferedInputStream(is);
                    os = new BufferedOutputStream(os);
                    while ((count = is.read(buf)) != -1) {
                        os.write(buf, 0, count);
                    }
                    copied = true;
                }
            }
            catch (IOException e) {
                Log.e(LCAT, "Error while copying file: ", e);
                throw e;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                        is = null;
                    }
                    catch (IOException e) {}
                }
                if (os != null) {
                    try {
                        os.close();
                        os = null;
                    }
                    catch (IOException e) {}
                }
            }
        }
        return copied;
    }

    public boolean createDirectory(boolean recursive) {
        this.logNotSupported("createDirectory");
        return false;
    }

    public boolean createShortcut() {
        this.logNotSupported("createShortcut");
        return false;
    }

    public double createTimestamp() {
        this.logNotSupported("createTimestamp");
        return 0.0;
    }

    public boolean deleteDirectory(boolean recursive) {
        this.logNotSupported("deleteDirectory");
        return false;
    }

    public boolean deleteFile() {
        this.logNotSupported("deleteFile");
        return false;
    }

    public boolean exists() {
        this.logNotSupported("exists");
        return false;
    }

    public String extension() {
        this.logNotSupported("extensionsion");
        return null;
    }

    public List<String> getDirectoryListing() {
        this.logNotSupported("getDirectoryListing");
        return null;
    }

    public TiBaseFile getParent() {
        this.logNotSupported("getParent");
        return null;
    }

    public double modificationTimestamp() {
        this.logNotSupported("modificationTimestamp");
        return 0.0;
    }

    public boolean move(String destination) throws IOException {
        TiContext tiContext;
        boolean moved = false;
        if (destination != null && (tiContext = this.getTiContext()) != null) {
            String[] parts = new String[]{destination};
            TiBaseFile bf = TiFileFactory.createTitaniumFile(tiContext, parts, false);
            if (bf != null) {
                if (bf.exists()) {
                    throw new IOException("Destination already exists.");
                }
                File fsrc = this.getNativeFile();
                if (fsrc == null) {
                    throw new FileNotFoundException("Source is not a true file.");
                }
                File fdest = bf.getNativeFile();
                if (fdest == null) {
                    throw new FileNotFoundException("Destination is not a valid location for writing");
                }
                if (this.copy(destination)) {
                    moved = this.deleteFile();
                }
            } else {
                throw new FileNotFoundException("Destination not found: " + destination);
            }
        }
        return moved;
    }

    public String name() {
        this.logNotSupported("name");
        return null;
    }

    public String nativePath() {
        this.logNotSupported("nativePath");
        return null;
    }

    public TiBlob read() throws IOException {
        this.logNotSupported("read");
        return null;
    }

    public String readLine() throws IOException {
        this.logNotSupported("readLine");
        return null;
    }

    public boolean rename(String destination) {
        File f;
        boolean renamed = false;
        if (destination != null && (f = this.getNativeFile()) != null) {
            File dest = new File(f.getParent(), destination);
            renamed = f.renameTo(dest);
        }
        return renamed;
    }

    public TiBaseFile resolve() {
        this.logNotSupported("resolve");
        return null;
    }

    public boolean setExecutable() {
        this.logNotSupported("setExecutable");
        return false;
    }

    public boolean setReadonly() {
        this.logNotSupported("setReadonly");
        return false;
    }

    public boolean setWriteable() {
        this.logNotSupported("setWriteable");
        return false;
    }

    public long size() {
        this.logNotSupported("size");
        return 0L;
    }

    public double spaceAvailable() {
        this.logNotSupported("spaceAvailable");
        return 0.0;
    }

    public void unzip(String destination) {
        this.logNotSupported("unzip");
    }

    public void write(TiBlob blob, boolean append) throws IOException {
    }

    public void write(String data, boolean append) throws IOException {
        this.logNotSupported("write");
    }

    public void writeFromUrl(String url, boolean append) throws IOException {
        this.logNotSupported("writeFromUrl");
    }

    public void writeLine(String data) throws IOException {
        this.logNotSupported("writeLine");
    }

    public void close() throws IOException {
        if (this.opened) {
            if (this.instream != null) {
                try {
                    this.instream.close();
                }
                catch (IOException e) {
                    throw new IOException("Error closing file");
                }
                this.instream = null;
            }
            if (this.inreader != null) {
                try {
                    this.inreader.close();
                }
                catch (IOException e) {
                    throw new IOException("Error closing file");
                }
                this.inreader = null;
            }
            if (this.outstream != null) {
                try {
                    this.outstream.close();
                }
                catch (IOException e) {
                    throw new IOException("Error closing file");
                }
                this.outstream = null;
            }
            if (this.outwriter != null) {
                try {
                    this.outwriter.close();
                }
                catch (IOException e) {
                    throw new IOException("Error closing file");
                }
                this.outwriter = null;
            }
            this.opened = false;
        }
        this.binary = false;
    }

    public boolean isOpen() {
        return this.opened;
    }

    public void open(int mode, boolean binary) throws IOException {
        this.logNotSupported("open");
    }

    protected void logNotSupported(String method2) {
        if (method2 == null) {
            method2 = Thread.currentThread().getStackTrace()[1].getMethodName();
        }
        Log.w(LCAT, "Method is not supported " + this.getClass().getName() + " : " + method2);
    }

    protected void copyStream(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[8096];
        int count = 0;
        while ((count = is.read(buf)) != -1) {
            os.write(buf, 0, count);
        }
    }

    protected void copyStream(Reader r, Writer w) throws IOException {
        char[] buf = new char[8096];
        int count = 0;
        while ((count = r.read(buf, 0, count)) != -1) {
            w.write(buf, 0, count);
        }
    }

    public InputStream getExistingInputStream() {
        return this.instream;
    }

    public OutputStream getExistingOutputStream() {
        return this.outstream;
    }

    public abstract InputStream getInputStream() throws IOException;

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract File getNativeFile();
}

