/*
 * Decompiled with CFR 0.152.
 */
package org.appcelerator.titanium.analytics;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.IBinder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.appcelerator.titanium.analytics.TiAnalyticsModel;
import org.appcelerator.titanium.util.Log;
import org.json.JSONArray;
import org.json.JSONObject;

public class TiAnalyticsService
extends Service {
    private static final String LCAT = "TiAnalyticsSvc";
    private static final int BUCKET_SIZE_FAST_NETWORK = 10;
    private static final int BUCKET_SIZE_SLOW_NETWORK = 5;
    private static final String ANALYTICS_URL = "https://api.appcelerator.net/p/v2/mobile-track";
    private static AtomicBoolean sending;
    private ConnectivityManager connectivityManager;

    public TiAnalyticsService() {
        if (sending == null) {
            sending = new AtomicBoolean(false);
        }
    }

    public void onCreate() {
        super.onCreate();
        this.connectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
    }

    public void onDestroy() {
        super.onDestroy();
        this.connectivityManager = null;
    }

    public void onStart(Intent intent, final int startId) {
        super.onStart(intent, startId);
        if (!sending.compareAndSet(false, true)) {
            Log.i(LCAT, "Send already in progress, skipping intent");
        }
        final TiAnalyticsService self = this;
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.w(TiAnalyticsService.LCAT, "Analytics Service Started");
                try {
                    if (TiAnalyticsService.this.connectivityManager == null) {
                        Log.w(TiAnalyticsService.LCAT, "Connectivity manager not available.");
                        TiAnalyticsService.this.stopSelf(startId);
                        return;
                    }
                    TiAnalyticsModel model = new TiAnalyticsModel((Context)self);
                    if (!model.hasEvents()) {
                        Log.i(TiAnalyticsService.LCAT, "No events to send.");
                        TiAnalyticsService.this.stopSelf(startId);
                        return;
                    }
                    while (model.hasEvents()) {
                        if (TiAnalyticsService.this.canSend()) {
                            HashMap<Integer, JSONObject> events = model.getEventsAsJSON(10);
                            int len = events.size();
                            int[] eventIds = new int[len];
                            Iterator<Integer> keys = events.keySet().iterator();
                            JSONArray records = new JSONArray();
                            for (int i = 0; i < len; ++i) {
                                int id;
                                eventIds[i] = id = keys.next().intValue();
                                records.put((Object)events.get(id));
                            }
                            boolean deleteEvents = true;
                            if (records.length() > 0) {
                                String jsonData = records.toString() + "\n";
                                Log.i(TiAnalyticsService.LCAT, "Sending " + records.length() + " analytics events.");
                                try {
                                    HttpPost httpPost = new HttpPost(TiAnalyticsService.ANALYTICS_URL);
                                    StringEntity entity = new StringEntity(jsonData);
                                    entity.setContentType("text/json");
                                    httpPost.setEntity((HttpEntity)entity);
                                    BasicHttpParams httpParams = new BasicHttpParams();
                                    HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)5000);
                                    DefaultHttpClient client = new DefaultHttpClient((HttpParams)httpParams);
                                    BasicResponseHandler responseHandler = new BasicResponseHandler();
                                    client.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                                    String response = (String)client.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
                                }
                                catch (Throwable t) {
                                    Log.e(TiAnalyticsService.LCAT, "Error posting events: " + t.getMessage(), t);
                                    deleteEvents = false;
                                    records = null;
                                    break;
                                }
                            }
                            records = null;
                            if (deleteEvents) {
                                model.deleteEvents(eventIds);
                            }
                            events.clear();
                            continue;
                        }
                        Log.i(TiAnalyticsService.LCAT, "Network unavailable, can't send analytics");
                        break;
                    }
                    Log.w(TiAnalyticsService.LCAT, "Stopping Analytics Service");
                    TiAnalyticsService.this.stopSelf(startId);
                }
                catch (Throwable t) {
                    Log.e(TiAnalyticsService.LCAT, "Unhandle exception in analytics thread: ", t);
                    TiAnalyticsService.this.stopSelf(startId);
                }
                finally {
                    if (!sending.compareAndSet(true, false)) {
                        Log.w(TiAnalyticsService.LCAT, "Expected to be in a sending state. Sending was already false.");
                    }
                }
            }
        });
        t.setPriority(1);
        t.start();
    }

    private boolean canSend() {
        boolean result = false;
        NetworkInfo netInfo = null;
        try {
            netInfo = this.connectivityManager.getActiveNetworkInfo();
        }
        catch (SecurityException e) {
            Log.w(LCAT, "Connectivity permissions have been removed from AndroidManifest.xml: " + e.getMessage());
        }
        if (netInfo != null && netInfo.isConnected() && !netInfo.isRoaming()) {
            result = true;
        }
        return result;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }
}

